/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.api;

import com.modelengineers.lismo3_0.api.Lismo;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class IdleTimer {
    private final int timeoutSeconds;
    private final Lismo lismo;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Idle Timer");
        }
    });
    private ScheduledFuture<?> timer;

    IdleTimer(Lismo lismo, int n) {
        this.lismo = lismo;
        this.timeoutSeconds = n;
    }

    public synchronized void start() {
        this.stop();
        this.timer = this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                IdleTimer.this.lismo.setIdle(true);
            }
        }, (long)this.timeoutSeconds, TimeUnit.SECONDS);
    }

    public synchronized boolean restart() {
        if (this.timer != null && !this.timer.isDone()) {
            this.start();
            return true;
        }
        return false;
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel(true);
            this.timer = null;
        }
    }
}

