/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.license;

import com.modelengineers.license.WindowsRegistryInaccessibleException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WindowsRegistryUtils {
    private static final String QUERY = "query";

    private WindowsRegistryUtils() {
    }

    public static String getCommonAppData() throws WindowsRegistryInaccessibleException {
        return WindowsRegistryUtils.queryValue("HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Common AppData");
    }

    public static List<String> queryKeys(String keyPath) throws WindowsRegistryInaccessibleException {
        ArrayList<String> keyNames = new ArrayList<String>();
        List<String> lines = WindowsRegistryUtils.regCmd(QUERY, keyPath);
        for (String line : lines) {
            if (line.startsWith("!") || line.isEmpty() || !line.startsWith(keyPath) || line.equals(keyPath)) continue;
            keyNames.add(new File(line).getName());
        }
        return keyNames;
    }

    public static String queryValue(String keyPath, String valueName) throws WindowsRegistryInaccessibleException {
        List<String> lines = WindowsRegistryUtils.regCmd(QUERY, keyPath, "/v", valueName);
        return WindowsRegistryUtils.findValues(lines).get(valueName);
    }

    public static String queryDefaultValue(String keyPath) throws WindowsRegistryInaccessibleException {
        List<String> lines = WindowsRegistryUtils.regCmd(QUERY, keyPath, "/ve");
        return WindowsRegistryUtils.findValues(lines).get("<NO NAME>");
    }

    public static Map<String, String> queryValues(String keyPath) throws WindowsRegistryInaccessibleException {
        List<String> lines = WindowsRegistryUtils.regCmd(QUERY, keyPath);
        return WindowsRegistryUtils.findValues(lines);
    }

    protected static Map<String, String> findValues(List<String> lines) {
        String regxLeadingSpace = "^ {4}";
        String regxValueName = "([\\w\\<\\> ]+?)";
        String regxFirstSeparatorSpace = "([ ]{4}|\t)";
        String regxType = "REG_SZ";
        String regxLastSeparatorSpace = "($|[ ]{4}|\t)";
        String regxTrailingValueContent = "(.*)$";
        String regex = "^ {4}([\\w\\<\\> ]+?)([ ]{4}|\t)REG_SZ($|[ ]{4}|\t)(.*)$";
        HashMap<String, String> values = new HashMap<String, String>();
        for (String line : lines) {
            if (!line.matches("^ {4}([\\w\\<\\> ]+?)([ ]{4}|\t)REG_SZ($|[ ]{4}|\t)(.*)$")) continue;
            values.put(line.replaceFirst("^ {4}([\\w\\<\\> ]+?)([ ]{4}|\t)REG_SZ($|[ ]{4}|\t)(.*)$", "$1"), line.replaceFirst("^ {4}([\\w\\<\\> ]+?)([ ]{4}|\t)REG_SZ($|[ ]{4}|\t)(.*)$", "$4"));
        }
        return values;
    }

    public static void addValue(String keyPath, String valueName, String value) throws WindowsRegistryInaccessibleException {
        WindowsRegistryUtils.regCmd("add", keyPath, "/v", valueName, "/d", value, "/f");
    }

    public static void deleteValue(String keyPath, String valueName) throws WindowsRegistryInaccessibleException {
        WindowsRegistryUtils.regCmd("delete", keyPath, "/v", valueName, "/f");
    }

    private static List<String> regCmd(String cmd, String ... arguments) throws WindowsRegistryInaccessibleException {
        Process queryProcess;
        ArrayList<String> cmdline = new ArrayList<String>(Arrays.asList(WindowsRegistryUtils.getNativeRegistryToolExecutable(), cmd));
        cmdline.addAll(Arrays.asList(arguments));
        ProcessBuilder pBuilder = new ProcessBuilder(cmdline);
        try {
            queryProcess = pBuilder.start();
        }
        catch (IOException e) {
            throw new WindowsRegistryInaccessibleException(e);
        }
        BufferedLineStreamReader blsr = new BufferedLineStreamReader(queryProcess.getInputStream());
        blsr.start();
        try {
            queryProcess.waitFor();
            blsr.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return blsr.getLines();
    }

    private static String getNativeRegistryToolExecutable() {
        String windir = System.getenv("windir");
        File nativeRegexe = new File(new File(windir, "Sysnative"), "reg.exe");
        if (nativeRegexe.isFile()) {
            return nativeRegexe.getPath();
        }
        return "reg.exe";
    }

    static class BufferedLineStreamReader
    extends Thread {
        private ArrayList<String> lines;
        private InputStream is;

        BufferedLineStreamReader(InputStream is) {
            this.is = is;
            this.lines = new ArrayList();
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));){
                String nextline;
                while ((nextline = reader.readLine()) != null) {
                    this.lines.add(nextline);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public List<String> getLines() {
            return this.lines;
        }
    }
}

