/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.license;

import com.modelengineers.license.ExecuteCommanding;
import com.modelengineers.license.JavaUtilities;
import com.modelengineers.license.LicenseManagerUI;
import com.modelengineers.license.WindowsRegistryInaccessibleException;
import com.modelengineers.license.WindowsRegistryUtils;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class EnvironmentVariablesHandler {
    public static final String MES_SPECIFIC_LICENSE_SPECIFICATION_NAME = "MES_LICENSE_FILE";
    public static final String GENERAL_LICENSE_SPECIFICATION_NAME = "LM_LICENSE_FILE";
    public static final String LICENSE_WIN_REGISTRY_KEY = "HKEY_CURRENT_USER\\Software\\FLEXlm License Manager";
    public static final String LICENSE_LINUX_REGISTRY_PATH = System.getProperty("user.home") + "/.flexlmrc";
    private static final String MESSAGE_FLEXERA_LICENSE_SPEC_VARIABLE_DEFINED = "Warning: The environment variable %s with value '%s' exists on this system." + System.lineSeparator() + System.lineSeparator() + "The presence of this variable invalidates the selected configuration. You can configure using this variable by selecting '" + "MES Environment Variable" + "'.";
    private static final String MESSAGE_WIN_REGISTRY_ENTRY_FOUND = "Warning: The Flexera variable %s with value '%s' is specified in the Windows registry." + System.lineSeparator() + System.lineSeparator() + "The presence of this variable invalidates the selected configuration. You can configure using this variable by selecting '" + "MES Environment Variable" + "'.";
    private static final String MESSAGE_LINUX_REGISTRY_ENTRY_FOUND = "Warning: The Flexera variable %s with %s is specified in $HOME/.flexlmrc." + System.lineSeparator() + System.lineSeparator() + "The presence of this variable invalidates the selected configuration. You can configure using this variable by selecting '" + "MES Environment Variable" + "'.";
    private static final String ENVIRONMENT_VARIABLE_CHANGED_REASON_MESSAGE = "Warning: You are about to change an environment variable." + System.lineSeparator() + "This type of change requires the restart of the license manager and the parent tool." + System.lineSeparator() + "Therefore, the License Manager will be closed. If you want to continue with configuration, you have to restart the License Manager." + System.lineSeparator() + System.lineSeparator() + "If the License Manager was started from within an MES tool (e.g. MXAM), this MES tool also requires a restart to enable the new configuration." + System.lineSeparator() + System.lineSeparator() + "Do you want to continue (with closing the License Manager)?";
    public static final String MESSAGE_GENERAL_FLEXERA_VALUE_DEFINED_MESSAGE = "Warning: The environment variable LM_LICENSE_FILE exists on this system." + System.lineSeparator() + System.lineSeparator() + "The current configuration shows this variable's value. If you change it, the value will be saved in the MES_LICENSE_FILE to prevent a conflict with the configuration for other Flexera licensed tools. " + System.lineSeparator() + System.lineSeparator() + "While the LM_LICENSE_FILE exists, you can only configure the license for MES tools by setting the MES_LICENSE_FILE variable. All other configurations in the License Manager will be invalid.";
    private final Properties flexeraPropertiesInLinux = new Properties();
    private LicenseManagerUI ui;

    public EnvironmentVariablesHandler(LicenseManagerUI licenseManagerUI) {
        this.ui = licenseManagerUI;
        if (Platform.isLinux()) {
            this.loadFlexeraPropertiesInLinux();
        }
    }

    private void loadFlexeraPropertiesInLinux() {
        File configFile = new File(LICENSE_LINUX_REGISTRY_PATH);
        if (configFile.isFile() && configFile.canRead()) {
            try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
                this.flexeraPropertiesInLinux.load(in);
            }
            catch (IOException ioe) {
                LicenseManagerUI.logWarn("Error during loading Flexera properties.", ioe);
            }
        }
    }

    public String getFlexeraVariableValue() {
        String flexeraVariableValue = this.getFlexeraVariableValue(MES_SPECIFIC_LICENSE_SPECIFICATION_NAME);
        if (null == flexeraVariableValue) {
            flexeraVariableValue = this.getFlexeraVariableValue(GENERAL_LICENSE_SPECIFICATION_NAME);
        }
        return flexeraVariableValue;
    }

    public String getFlexeraVariableValue(String variable) {
        String regVariable;
        StringBuilder flexeraVarValue = new StringBuilder();
        String envVariable = this.getEnvironmentVariableValue(variable);
        if (envVariable != null && !envVariable.isEmpty()) {
            flexeraVarValue.append(envVariable);
        }
        if ((regVariable = this.getLicenseVariableInRegistry(variable)) != null) {
            if (flexeraVarValue.length() != 0) {
                flexeraVarValue.append(File.pathSeparator);
            }
            flexeraVarValue.append(regVariable);
        }
        return flexeraVarValue.length() == 0 ? null : this.removeDuplicates(flexeraVarValue.toString());
    }

    private String removeDuplicates(String value) {
        List<String> values = new JavaUtilities.StringSplitter(File.pathSeparator).withUniqueHandling().split(value);
        return new JavaUtilities.StringJoiner(File.pathSeparator).join(values);
    }

    private String getLicenseVariableInRegistry(String variable) {
        if (Platform.isWindows()) {
            return this.getLicenseVariableInWinRegistry(variable);
        }
        if (Platform.isLinux()) {
            return this.getLicenseVariableInLinuxRegistry(variable);
        }
        return null;
    }

    public void setLicenseVariable(String serverIPValue, String licenseFileValue) {
        String concat = "";
        if (!serverIPValue.isEmpty()) {
            concat = concat + serverIPValue;
        }
        if (!licenseFileValue.isEmpty()) {
            if (!concat.isEmpty()) {
                concat = concat + File.pathSeparator;
            }
            concat = concat + licenseFileValue;
        }
        this.setLicenseVariable(concat);
    }

    private void setLicenseVariable(String newValue) {
        if (this.ui.warnDialog("Environment Variable changed", ENVIRONMENT_VARIABLE_CHANGED_REASON_MESSAGE) == 0) {
            if (this.variableIsInRegistry()) {
                this.setLicenseVariableInRegistry(newValue);
            }
            if (this.variableIsInEnvironment()) {
                this.setLicenseVariableInEnvironment(newValue);
            }
            System.exit(0);
        }
    }

    private boolean variableIsInRegistry() {
        return this.getLicenseVariableInRegistry(GENERAL_LICENSE_SPECIFICATION_NAME) != null || this.getLicenseVariableInRegistry(MES_SPECIFIC_LICENSE_SPECIFICATION_NAME) != null;
    }

    private boolean variableIsInEnvironment() {
        return this.getEnvironmentVariableValue(GENERAL_LICENSE_SPECIFICATION_NAME) != null || this.getEnvironmentVariableValue(MES_SPECIFIC_LICENSE_SPECIFICATION_NAME) != null;
    }

    private void setLicenseVariableInRegistry(String newValue) {
        if (Platform.isLinux()) {
            this.setLicenseVariableInLinuxRegistry(newValue);
        } else if (Platform.isWindows()) {
            this.setLicenseVariableInWinRegistry(newValue);
        } else {
            throw new UnsupportedOperationException("Current OP not supported.");
        }
    }

    private void setLicenseVariableInLinuxRegistry(String newValue) {
        if (newValue == null || newValue.isEmpty()) {
            this.flexeraPropertiesInLinux.remove(MES_SPECIFIC_LICENSE_SPECIFICATION_NAME);
        } else {
            this.flexeraPropertiesInLinux.put(MES_SPECIFIC_LICENSE_SPECIFICATION_NAME, newValue);
        }
        File configFile = new File(LICENSE_LINUX_REGISTRY_PATH);
        if (!configFile.isFile() || !configFile.canWrite()) {
            this.ui.writeWarning("Not be able to config " + LICENSE_LINUX_REGISTRY_PATH + ". Please check your access rights.");
        } else {
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8);){
                this.flexeraPropertiesInLinux.store(out, "Flexera Properties");
            }
            catch (IOException ioe) {
                this.ui.writeWarning("Error during storing the Flexera properties: " + ioe.getMessage());
            }
        }
    }

    private void setLicenseVariableInWinRegistry(String newValue) {
        if (newValue.isEmpty()) {
            this.removeLicenseVariableInRegistry();
        } else {
            try {
                WindowsRegistryUtils.addValue(LICENSE_WIN_REGISTRY_KEY, MES_SPECIFIC_LICENSE_SPECIFICATION_NAME, newValue);
            }
            catch (WindowsRegistryInaccessibleException e) {
                this.ui.writeWarning(e.getMessage());
            }
        }
    }

    private void removeLicenseVariableInRegistry() {
        try {
            WindowsRegistryUtils.deleteValue(LICENSE_WIN_REGISTRY_KEY, MES_SPECIFIC_LICENSE_SPECIFICATION_NAME);
        }
        catch (WindowsRegistryInaccessibleException e) {
            this.ui.writeWarning(e.getMessage());
        }
    }

    private void setLicenseVariableInEnvironment(String newValue) {
        if (Platform.isLinux()) {
            return;
        }
        this.doSetLicenseVariableInEnvironment(newValue.isEmpty() ? "\"\"" : newValue);
    }

    private void doSetLicenseVariableInEnvironment(String newValue) {
        SetEnvironmentVariableCommand command = new SetEnvironmentVariableCommand("setx MES_LICENSE_FILE " + newValue);
        new Thread(command).start();
    }

    private String getLicenseVariableInLinuxRegistry(String variable) {
        return this.flexeraPropertiesInLinux.getProperty(variable);
    }

    private String getLicenseVariableInWinRegistry(String variable) {
        try {
            return WindowsRegistryUtils.queryValue(LICENSE_WIN_REGISTRY_KEY, variable);
        }
        catch (Exception rie) {
            LicenseManagerUI.logWarn("Registry request failed.", rie);
            return null;
        }
    }

    private String getEnvironmentVariableValue(String key) {
        return System.getenv(key);
    }

    public String getEnvironmentLicenseDefinedWarning() {
        String mesLicenseFileValue = this.getEnvironmentVariableValue(MES_SPECIFIC_LICENSE_SPECIFICATION_NAME);
        if (mesLicenseFileValue != null) {
            return String.format(MESSAGE_FLEXERA_LICENSE_SPEC_VARIABLE_DEFINED, MES_SPECIFIC_LICENSE_SPECIFICATION_NAME, mesLicenseFileValue);
        }
        String lmLicenseFileValue = this.getEnvironmentVariableValue(GENERAL_LICENSE_SPECIFICATION_NAME);
        if (lmLicenseFileValue != null) {
            return String.format(MESSAGE_FLEXERA_LICENSE_SPEC_VARIABLE_DEFINED, GENERAL_LICENSE_SPECIFICATION_NAME, lmLicenseFileValue);
        }
        String mesLicenseFromRegistry = this.getLicenseVariableInRegistry(MES_SPECIFIC_LICENSE_SPECIFICATION_NAME);
        if (mesLicenseFromRegistry != null) {
            return this.getPlatformDepenendentRegistryWarning(MES_SPECIFIC_LICENSE_SPECIFICATION_NAME, mesLicenseFromRegistry);
        }
        String lmLicenseFromRegistry = this.getLicenseVariableInRegistry(GENERAL_LICENSE_SPECIFICATION_NAME);
        if (lmLicenseFromRegistry != null) {
            return this.getPlatformDepenendentRegistryWarning(GENERAL_LICENSE_SPECIFICATION_NAME, lmLicenseFromRegistry);
        }
        return "";
    }

    public String getEmptyEnvironmentLicenseDefinedWarning() {
        return this.getEnvironmentLicenseDefinedWarning();
    }

    public String getPlatformDepenendentRegistryWarning(String flexeraVariableKey, String flexeraVariableValue) {
        if (Platform.isWindows()) {
            return String.format(MESSAGE_WIN_REGISTRY_ENTRY_FOUND, flexeraVariableKey, flexeraVariableValue);
        }
        if (Platform.isLinux()) {
            if (flexeraVariableValue.isEmpty()) {
                return String.format(MESSAGE_LINUX_REGISTRY_ENTRY_FOUND, flexeraVariableKey, "no value");
            }
            return String.format(MESSAGE_LINUX_REGISTRY_ENTRY_FOUND, flexeraVariableKey, "value '" + flexeraVariableValue + "'");
        }
        return "";
    }

    public static String parseServerIPValues(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        for (String part : input.split(File.pathSeparator)) {
            if (!part.contains("@")) continue;
            if (builder.length() != 0) {
                builder.append(File.pathSeparator);
            }
            builder.append(part);
        }
        return builder.toString();
    }

    public static String parseLicenseFileValues(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        for (String part : input.split(File.pathSeparator)) {
            if (part.contains("@")) continue;
            if (builder.length() != 0) {
                builder.append(File.pathSeparator);
            }
            builder.append(part);
        }
        return builder.toString();
    }

    private class SetEnvironmentVariableCommand
    extends ExecuteCommanding {
        private final String command;

        private SetEnvironmentVariableCommand(String command) {
            this.command = command;
        }

        @Override
        protected List<String> getCommands() {
            return Arrays.asList(this.getWholeCommand());
        }

        @Override
        protected String getWholeCommand() {
            return this.command;
        }

        @Override
        protected void informSomeone(List<String> text) {
            String joinedText = new JavaUtilities.StringJoiner(System.lineSeparator()).join(text);
            EnvironmentVariablesHandler.this.ui.writeOutput(joinedText);
        }
    }
}

