/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.graph.json.text.ide.contentassist;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.modelengineers.MoRe_elk.core.data.ILayoutMetaData;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.data.LayoutDataContentAssist;
import com.modelengineers.MoRe_elk.core.data.LayoutOptionData;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import com.modelengineers.MoRe_elk.graph.json.text.services.ElkGraphJsonGrammarAccess;
import com.modelengineers.MoRe_emf.ecore.EObject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ElkGraphJsonProposalProvider
extends IdeContentProposalProvider {
    private static final Set<String> DISABLED_KEYWORDS = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"}", "]"}));
    private ElkGraphJsonGrammarAccess grammar;
    private IDValueConverter idValueConverter;

    @Inject
    public void initialize(Provider<IDValueConverter> idValueConverterProvider, final ElkGraphJsonGrammarAccess grammarAccess) {
        IDValueConverter _doubleArrow;
        IDValueConverter _get = (IDValueConverter)idValueConverterProvider.get();
        Procedures.Procedure1<IDValueConverter> _function = new Procedures.Procedure1<IDValueConverter>(){

            public void apply(IDValueConverter it) {
                it.setRule((AbstractRule)grammarAccess.getIDRule());
            }
        };
        this.idValueConverter = _doubleArrow = (IDValueConverter)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        this.grammar = grammarAccess;
    }

    protected boolean filterKeyword(Keyword keyword, ContentAssistContext context) {
        return !DISABLED_KEYWORDS.contains(keyword.getValue()) && !Objects.equal((Object)keyword.getValue(), (Object)context.getPrefix());
    }

    protected void _createProposals(Keyword keyword, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        ContentAssistEntry entry;
        boolean _filterKeyword = this.filterKeyword(keyword, context);
        if (_filterKeyword && (entry = this.getProposalCreator().createProposal(keyword.getValue(), context, "KEYWORD", null)) != null) {
            entry.setKind("KEYWORD");
            entry.setSource((Object)keyword);
            acceptor.accept(entry, this.getProposalPriorities().getKeywordPriority(keyword.getValue(), entry));
        }
    }

    protected void _createProposals(RuleCall ruleCall, final ContentAssistContext context, final IIdeContentProposalAcceptor acceptor) {
        boolean _startsWith = ruleCall.getRule().getName().startsWith("Key");
        if (_startsWith) {
            AbstractElement _alternatives;
            AbstractElement alternatives = _alternatives = ruleCall.getRule().getAlternatives();
            boolean _matched = false;
            if (alternatives instanceof Alternatives) {
                _matched = true;
                Functions.Function1<Keyword, Boolean> _function = new Functions.Function1<Keyword, Boolean>(){

                    public Boolean apply(Keyword it) {
                        return !it.getValue().startsWith("\"") && !it.getValue().startsWith("'");
                    }
                };
                Consumer<Keyword> _function_1 = new Consumer<Keyword>(){

                    @Override
                    public void accept(Keyword it) {
                        ElkGraphJsonProposalProvider.this.createProposals((AbstractElement)it, context, acceptor);
                    }
                };
                IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Alternatives)alternatives).getElements(), Keyword.class), (Functions.Function1)_function).forEach(_function_1);
            }
        }
    }

    protected void _createProposals(Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        boolean _matched = false;
        Assignment _keyAssignment_0 = this.grammar.getPropertyAccess().getKeyAssignment_0();
        if (Objects.equal((Object)assignment, (Object)_keyAssignment_0)) {
            _matched = true;
            this.completePropertyKey(context, acceptor);
        }
        if (!_matched) {
            Assignment _valueAssignment_2_2;
            Assignment _valueAssignment_2_1;
            Assignment _valueAssignment_2_0 = this.grammar.getPropertyAccess().getValueAssignment_2_0();
            if (Objects.equal((Object)assignment, (Object)_valueAssignment_2_0)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)assignment, (Object)(_valueAssignment_2_1 = this.grammar.getPropertyAccess().getValueAssignment_2_1()))) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)assignment, (Object)(_valueAssignment_2_2 = this.grammar.getPropertyAccess().getValueAssignment_2_2()))) {
                _matched = true;
            }
            if (_matched) {
                this.completePropertyValue(context, acceptor);
            }
        }
        if (!_matched) {
            super._createProposals(assignment, context, acceptor);
        }
    }

    protected void completePropertyKey(final ContentAssistContext context, final IIdeContentProposalAcceptor acceptor) {
        EObject model = context.getCurrentModel();
        if (model instanceof ElkGraphElement) {
            Consumer<LayoutDataContentAssist.Proposal<LayoutOptionData>> _function = new Consumer<LayoutDataContentAssist.Proposal<LayoutOptionData>>(){

                @Override
                public void accept(final LayoutDataContentAssist.Proposal<LayoutOptionData> p) {
                    ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
                    Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

                        public void apply(ContentAssistEntry it) {
                            it.setProposal(ElkGraphJsonProposalProvider.this.convertPropertyId(p.proposal));
                            it.setPrefix(context.getPrefix());
                            it.setKind("PROPERTY");
                            String _elvis = null;
                            _elvis = p.label != null ? p.label : p.proposal;
                            it.setLabel(_elvis);
                            it.setDescription(ElkGraphJsonProposalProvider.this.getDescription((ILayoutMetaData)p.data));
                            it.setDocumentation(((LayoutOptionData)p.data).getDescription());
                            it.setSource(p.data);
                        }
                    };
                    ContentAssistEntry entry = (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function);
                    acceptor.accept(entry, ElkGraphJsonProposalProvider.this.getProposalPriorities().getDefaultPriority(entry));
                }
            };
            LayoutDataContentAssist.getLayoutOptionProposals((ElkGraphElement)model, this.unquoteIfNecessary(context.getPrefix())).forEach(_function);
        }
    }

    protected void completePropertyValue(ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        Object option;
        EObject model = context.getCurrentModel();
        if (model instanceof ElkPropertyToValueMapEntryImpl && (option = ((ElkPropertyToValueMapEntryImpl)model).getKey()) instanceof LayoutOptionData) {
            boolean _equals = Objects.equal(CoreOptions.ALGORITHM, (Object)option);
            if (_equals) {
                this.proposeAlgorithms(context, acceptor);
            } else {
                this.typeAwarePropertyValueProposal((LayoutOptionData)option, context, acceptor);
            }
        }
    }

    protected void proposeAlgorithms(final ContentAssistContext context, final IIdeContentProposalAcceptor acceptor) {
        Consumer<LayoutDataContentAssist.Proposal<LayoutAlgorithmData>> _function = new Consumer<LayoutDataContentAssist.Proposal<LayoutAlgorithmData>>(){

            @Override
            public void accept(final LayoutDataContentAssist.Proposal<LayoutAlgorithmData> p) {
                ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
                Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

                    public void apply(ContentAssistEntry it) {
                        it.setProposal(ElkGraphJsonProposalProvider.this.convertPropertyId(p.proposal));
                        it.setPrefix(context.getPrefix());
                        it.setKind("VALUE");
                        String _elvis = null;
                        _elvis = p.label != null ? p.label : p.proposal;
                        it.setLabel(_elvis);
                        it.setDescription(ElkGraphJsonProposalProvider.this.getDescription((ILayoutMetaData)p.data));
                        it.setDocumentation(((LayoutAlgorithmData)p.data).getDescription());
                        it.setSource(p.data);
                    }
                };
                ContentAssistEntry entry = (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function);
                acceptor.accept(entry, ElkGraphJsonProposalProvider.this.getProposalPriorities().getDefaultPriority(entry));
            }
        };
        LayoutDataContentAssist.getLayoutAlgorithmProposals(this.unquoteIfNecessary(context.getPrefix())).forEach(_function);
    }

    private void typeAwarePropertyValueProposal(final LayoutOptionData option, final ContentAssistContext context, final IIdeContentProposalAcceptor acceptor) {
        Consumer<LayoutDataContentAssist.Proposal<Object>> _function = new Consumer<LayoutDataContentAssist.Proposal<Object>>(){

            @Override
            public void accept(final LayoutDataContentAssist.Proposal<Object> p) {
                String _xifexpression = null;
                boolean _contains = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new LayoutOptionData.Type[]{LayoutOptionData.Type.ENUM, LayoutOptionData.Type.ENUMSET, LayoutOptionData.Type.STRING})).contains((Object)option.getType());
                _xifexpression = _contains ? "\"" + p.proposal + "\"" : p.proposal;
                String proposal = _xifexpression;
                Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

                    public void apply(ContentAssistEntry it) {
                        it.setLabel(p.label);
                        it.setSource((Object)option);
                    }
                };
                ContentAssistEntry entry = ElkGraphJsonProposalProvider.this.getProposalCreator().createProposal(proposal, context, "VALUE", (Procedures.Procedure1)_function);
                acceptor.accept(entry, ElkGraphJsonProposalProvider.this.getProposalPriorities().getDefaultPriority(entry));
            }
        };
        LayoutDataContentAssist.getLayoutOptionValueProposal(option, this.unquoteIfNecessary(context.getPrefix())).forEach(_function);
    }

    private String convertPropertyId(String proposal) {
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return ElkGraphJsonProposalProvider.this.idValueConverter.toString((Object)it);
            }
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)Strings.split((String)proposal, (String)"."), (Functions.Function1)_function), (CharSequence)".");
        String _plus = "\"" + _join;
        return String.valueOf(_plus) + "\"";
    }

    private String getDescription(ILayoutMetaData data) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = data.getName();
        _builder.append(_name);
        _builder.append(" (");
        String _id = data.getId();
        _builder.append(_id);
        _builder.append(")");
        return _builder.toString();
    }

    private String unquoteIfNecessary(String s) {
        String unquoted = s;
        while (unquoted.startsWith("\"") || unquoted.startsWith("'")) {
            unquoted = unquoted.substring(1, unquoted.length());
        }
        return unquoted;
    }
}

