/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.graph.json.text.formatting2;

import com.google.inject.Inject;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkLabel;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import com.modelengineers.MoRe_elk.graph.json.text.services.ElkGraphJsonGrammarAccess;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_emf.ecore.EObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ElkGraphJsonFormatter
extends AbstractFormatter2 {
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> no_space = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter it) {
            it.noSpace();
        }
    };
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> one_space = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter it) {
            it.oneSpace();
        }
    };
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> new_line = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter it) {
            it.newLine();
        }
    };
    @Inject
    @Extension
    private ElkGraphJsonGrammarAccess _elkGraphJsonGrammarAccess;

    protected void _format(ElkNode node, final @Extension IFormattableDocument document) {
        boolean compact = node.getChildren().isEmpty() && node.getPorts().isEmpty() && node.getLabels().isEmpty() && node.getProperties().isEmpty();
        Keyword _commaKeyword_2_1_0 = this._elkGraphJsonGrammarAccess.getElkNodeAccess().getCommaKeyword_2_1_0();
        Keyword _commaKeyword_3 = this._elkGraphJsonGrammarAccess.getElkNodeAccess().getCommaKeyword_3();
        this.formatWithCommonGraphElementStyle(node, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_2_1_0, _commaKeyword_3})), this._elkGraphJsonGrammarAccess.getElkNodeAccess().getLeftCurlyBracketKeyword_1(), this._elkGraphJsonGrammarAccess.getElkNodeAccess().getRightCurlyBracketKeyword_4(), compact, document);
        this.formatElkNodeChildren(node, document);
        this.formatElkNodePorts(node, document);
        this.formatElkGraphElementLabels(node, document);
        this.formatElkNodeEdges(node, document);
        this.formatLayoutOptions(node, document);
        this.formatJsonMember(node, document);
        Consumer<ElkNode> _function = new Consumer<ElkNode>(){

            @Override
            public void accept(ElkNode it) {
                document.format((Object)it);
            }
        };
        node.getChildren().forEach(_function);
        Consumer<ElkPort> _function_1 = new Consumer<ElkPort>(){

            @Override
            public void accept(ElkPort it) {
                document.format((Object)it);
            }
        };
        node.getPorts().forEach(_function_1);
        Consumer<ElkLabel> _function_2 = new Consumer<ElkLabel>(){

            @Override
            public void accept(ElkLabel it) {
                document.format((Object)it);
            }
        };
        node.getLabels().forEach(_function_2);
        Consumer<ElkEdge> _function_3 = new Consumer<ElkEdge>(){

            @Override
            public void accept(ElkEdge it) {
                document.format((Object)it);
            }
        };
        node.getContainedEdges().forEach(_function_3);
        Consumer _function_4 = new Consumer<Map.Entry<IProperty<?>, Object>>(){

            @Override
            public void accept(Map.Entry<IProperty<?>, Object> it) {
                document.format(it);
            }
        };
        node.getProperties().forEach(_function_4);
    }

    protected void _format(ElkPort port, final @Extension IFormattableDocument document) {
        boolean compact = port.getProperties().isEmpty() && port.getLabels().size() < 2;
        Keyword _commaKeyword_2_0 = this._elkGraphJsonGrammarAccess.getElkPortAccess().getCommaKeyword_2_0();
        Keyword _commaKeyword_3 = this._elkGraphJsonGrammarAccess.getElkPortAccess().getCommaKeyword_3();
        this.formatWithCommonGraphElementStyle(port, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_2_0, _commaKeyword_3})), this._elkGraphJsonGrammarAccess.getElkPortAccess().getLeftCurlyBracketKeyword_0(), this._elkGraphJsonGrammarAccess.getElkPortAccess().getRightCurlyBracketKeyword_4(), compact, document);
        this.formatElkGraphElementLabels(port, document);
        this.formatLayoutOptions(port, document);
        this.formatJsonMember(port, document);
        Consumer<ElkLabel> _function = new Consumer<ElkLabel>(){

            @Override
            public void accept(ElkLabel it) {
                document.format((Object)it);
            }
        };
        port.getLabels().forEach(_function);
        Consumer _function_1 = new Consumer<Map.Entry<IProperty<?>, Object>>(){

            @Override
            public void accept(Map.Entry<IProperty<?>, Object> it) {
                document.format(it);
            }
        };
        port.getProperties().forEach(_function_1);
    }

    protected void _format(ElkLabel label, final @Extension IFormattableDocument document) {
        boolean compact = label.getProperties().isEmpty() && label.getLabels().isEmpty();
        Keyword _commaKeyword_2_0 = this._elkGraphJsonGrammarAccess.getElkLabelAccess().getCommaKeyword_2_0();
        Keyword _commaKeyword_3 = this._elkGraphJsonGrammarAccess.getElkLabelAccess().getCommaKeyword_3();
        this.formatWithCommonGraphElementStyle(label, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_2_0, _commaKeyword_3})), this._elkGraphJsonGrammarAccess.getElkLabelAccess().getLeftCurlyBracketKeyword_0(), this._elkGraphJsonGrammarAccess.getElkLabelAccess().getRightCurlyBracketKeyword_4(), compact, document);
        this.formatElkGraphElementLabels(label, document);
        this.formatLayoutOptions(label, document);
        this.formatJsonMember(label, document);
        Consumer<ElkLabel> _function = new Consumer<ElkLabel>(){

            @Override
            public void accept(ElkLabel it) {
                document.format((Object)it);
            }
        };
        label.getLabels().forEach(_function);
        Consumer _function_1 = new Consumer<Map.Entry<IProperty<?>, Object>>(){

            @Override
            public void accept(Map.Entry<IProperty<?>, Object> it) {
                document.format(it);
            }
        };
        label.getProperties().forEach(_function_1);
    }

    protected void _format(ElkEdge edge, final @Extension IFormattableDocument document) {
        boolean compact = edge.getProperties().isEmpty() && edge.getSources().size() < 2 && edge.getTargets().size() < 2;
        Keyword _commaKeyword_2_0 = this._elkGraphJsonGrammarAccess.getElkEdgeAccess().getCommaKeyword_2_0();
        Keyword _commaKeyword_3 = this._elkGraphJsonGrammarAccess.getElkEdgeAccess().getCommaKeyword_3();
        this.formatWithCommonGraphElementStyle(edge, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_2_0, _commaKeyword_3})), this._elkGraphJsonGrammarAccess.getElkEdgeAccess().getLeftCurlyBracketKeyword_0(), this._elkGraphJsonGrammarAccess.getElkEdgeAccess().getRightCurlyBracketKeyword_4(), compact, document);
        this.formatElkEdgeSources(edge, document);
        this.formatElkEdgeTargets(edge, document);
        this.formatElkGraphElementLabels(edge, document);
        this.formatLayoutOptions(edge, document);
        this.formatJsonMember(edge, document);
        Consumer<ElkLabel> _function = new Consumer<ElkLabel>(){

            @Override
            public void accept(ElkLabel it) {
                document.format((Object)it);
            }
        };
        edge.getLabels().forEach(_function);
        Consumer _function_1 = new Consumer<Map.Entry<IProperty<?>, Object>>(){

            @Override
            public void accept(Map.Entry<IProperty<?>, Object> it) {
                document.format(it);
            }
        };
        edge.getProperties().forEach(_function_1);
    }

    protected void _format(ElkPropertyToValueMapEntryImpl entry, @Extension IFormattableDocument document) {
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)entry).keyword(this._elkGraphJsonGrammarAccess.getPropertyAccess().getColonKeyword_1()), no_space), one_space);
    }

    private void formatWithCommonGraphElementStyle(ElkGraphElement element, List<Keyword> commaKeywords, Keyword openingKeyword, Keyword closingKeyword, final boolean compact, final @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, no_space), one_space);
            }
        };
        this.textRegionExtensions.regionFor((EObject)element).keywords(new String[]{":"}).forEach(_function);
        Consumer<ISemanticRegion> _function_1 = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.prepend(it, no_space);
                if (compact) {
                    document.append(it, one_space);
                } else {
                    document.append(it, new_line);
                }
            }
        };
        this.textRegionExtensions.regionFor((EObject)element).keywords((Keyword[])Conversions.unwrapArray(commaKeywords, Keyword.class)).forEach(_function_1);
        ISemanticRegion _prepend = document.prepend(this.textRegionExtensions.regionFor((EObject)element).keyword(openingKeyword), no_space);
        Procedures.Procedure1<ISemanticRegion> _function_2 = new Procedures.Procedure1<ISemanticRegion>(){

            public void apply(ISemanticRegion it) {
                if (compact) {
                    document.append(it, one_space);
                } else {
                    document.append(it, new_line);
                }
            }
        };
        ISemanticRegion _doubleArrow = (ISemanticRegion)ObjectExtensions.operator_doubleArrow((Object)_prepend, (Procedures.Procedure1)_function_2);
        ISemanticRegion _keyword = this.textRegionExtensions.regionFor((EObject)element).keyword(closingKeyword);
        Procedures.Procedure1<ISemanticRegion> _function_3 = new Procedures.Procedure1<ISemanticRegion>(){

            public void apply(ISemanticRegion it) {
                if (compact) {
                    document.prepend(it, one_space);
                } else {
                    document.prepend(it, new_line);
                }
            }
        };
        ISemanticRegion _doubleArrow_1 = (ISemanticRegion)ObjectExtensions.operator_doubleArrow((Object)_keyword, (Procedures.Procedure1)_function_3);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.indent();
            }
        };
        document.interior(_doubleArrow, _doubleArrow_1, (Procedures.Procedure1)_function_4);
    }

    private void formatElkEdgeSources(ElkEdge edge, @Extension IFormattableDocument document) {
        Keyword _commaKeyword_1_1_0 = this._elkGraphJsonGrammarAccess.getElkEdgeSourcesAccess().getCommaKeyword_1_1_0();
        Keyword _commaKeyword_2 = this._elkGraphJsonGrammarAccess.getElkEdgeSourcesAccess().getCommaKeyword_2();
        this.formatWithCommonContainerStyle(edge, true, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_1_1_0, _commaKeyword_2})), this._elkGraphJsonGrammarAccess.getElkEdgeSourcesAccess().getLeftSquareBracketKeyword_0(), this._elkGraphJsonGrammarAccess.getElkEdgeSourcesAccess().getRightSquareBracketKeyword_3(), document);
    }

    private void formatElkEdgeTargets(ElkEdge edge, @Extension IFormattableDocument document) {
        Keyword _commaKeyword_1_1_0 = this._elkGraphJsonGrammarAccess.getElkEdgeTargetsAccess().getCommaKeyword_1_1_0();
        Keyword _commaKeyword_2 = this._elkGraphJsonGrammarAccess.getElkEdgeTargetsAccess().getCommaKeyword_2();
        this.formatWithCommonContainerStyle(edge, true, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_1_1_0, _commaKeyword_2})), this._elkGraphJsonGrammarAccess.getElkEdgeTargetsAccess().getLeftSquareBracketKeyword_0(), this._elkGraphJsonGrammarAccess.getElkEdgeTargetsAccess().getRightSquareBracketKeyword_3(), document);
    }

    private void formatElkNodeChildren(ElkNode node, @Extension IFormattableDocument document) {
        Keyword _commaKeyword_1_1_0 = this._elkGraphJsonGrammarAccess.getElkNodeChildrenAccess().getCommaKeyword_1_1_0();
        Keyword _commaKeyword_2 = this._elkGraphJsonGrammarAccess.getElkNodeChildrenAccess().getCommaKeyword_2();
        this.formatWithCommonContainerStyle(node, IterableExtensions.isNullOrEmpty(node.getChildren()), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_1_1_0, _commaKeyword_2})), this._elkGraphJsonGrammarAccess.getElkNodeChildrenAccess().getLeftSquareBracketKeyword_0(), this._elkGraphJsonGrammarAccess.getElkNodeChildrenAccess().getRightSquareBracketKeyword_3(), document);
    }

    private void formatElkNodePorts(ElkNode node, @Extension IFormattableDocument document) {
        Keyword _commaKeyword_1_1_0 = this._elkGraphJsonGrammarAccess.getElkNodePortsAccess().getCommaKeyword_1_1_0();
        Keyword _commaKeyword_2 = this._elkGraphJsonGrammarAccess.getElkNodePortsAccess().getCommaKeyword_2();
        this.formatWithCommonContainerStyle(node, IterableExtensions.isNullOrEmpty(node.getPorts()), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_1_1_0, _commaKeyword_2})), this._elkGraphJsonGrammarAccess.getElkNodePortsAccess().getLeftSquareBracketKeyword_0(), this._elkGraphJsonGrammarAccess.getElkNodePortsAccess().getRightSquareBracketKeyword_3(), document);
    }

    private void formatElkNodeEdges(ElkNode node, @Extension IFormattableDocument document) {
        Keyword _commaKeyword_1_1_0 = this._elkGraphJsonGrammarAccess.getElkNodeEdgesAccess().getCommaKeyword_1_1_0();
        Keyword _commaKeyword_2 = this._elkGraphJsonGrammarAccess.getElkNodeEdgesAccess().getCommaKeyword_2();
        this.formatWithCommonContainerStyle(node, IterableExtensions.isNullOrEmpty(node.getContainedEdges()), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_1_1_0, _commaKeyword_2})), this._elkGraphJsonGrammarAccess.getElkNodeEdgesAccess().getLeftSquareBracketKeyword_0(), this._elkGraphJsonGrammarAccess.getElkNodeEdgesAccess().getRightSquareBracketKeyword_3(), document);
    }

    private void formatElkGraphElementLabels(ElkGraphElement element, @Extension IFormattableDocument document) {
        Keyword _commaKeyword_1_1_0 = this._elkGraphJsonGrammarAccess.getElkGraphElementLabelsAccess().getCommaKeyword_1_1_0();
        Keyword _commaKeyword_2 = this._elkGraphJsonGrammarAccess.getElkGraphElementLabelsAccess().getCommaKeyword_2();
        this.formatWithCommonContainerStyle(element, IterableExtensions.isNullOrEmpty(element.getLabels()), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_1_1_0, _commaKeyword_2})), this._elkGraphJsonGrammarAccess.getElkGraphElementLabelsAccess().getLeftSquareBracketKeyword_0(), this._elkGraphJsonGrammarAccess.getElkGraphElementLabelsAccess().getRightSquareBracketKeyword_3(), document);
    }

    private void formatLayoutOptions(ElkGraphElement element, final @Extension IFormattableDocument document) {
        int _size = element.getProperties().size();
        final boolean compact = _size < 2;
        Keyword _commaKeyword_1_1_0 = this._elkGraphJsonGrammarAccess.getElkGraphElementPropertiesAccess().getCommaKeyword_1_1_0();
        Keyword _commaKeyword_2 = this._elkGraphJsonGrammarAccess.getElkGraphElementPropertiesAccess().getCommaKeyword_2();
        List<Keyword> commas = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_commaKeyword_1_1_0, _commaKeyword_2}));
        this.formatWithCommonContainerStyle(element, compact, commas, this._elkGraphJsonGrammarAccess.getElkGraphElementPropertiesAccess().getLeftCurlyBracketKeyword_0(), this._elkGraphJsonGrammarAccess.getElkGraphElementPropertiesAccess().getRightCurlyBracketKeyword_3(), document);
        if (!compact) {
            document.append(this.textRegionExtensions.regionFor((EObject)element).keyword(this._elkGraphJsonGrammarAccess.getElkGraphElementPropertiesAccess().getLeftCurlyBracketKeyword_0()), new_line);
        }
        Consumer<ISemanticRegion> _function = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                if (compact) {
                    document.append(document.prepend(it, no_space), one_space);
                } else {
                    document.append(it, new_line);
                }
            }
        };
        this.textRegionExtensions.regionFor((EObject)element).keywords((Keyword[])Conversions.unwrapArray(commas, Keyword.class)).forEach(_function);
    }

    private void formatWithCommonContainerStyle(ElkGraphElement element, boolean compact, List<Keyword> commaKeywords, Keyword openingKeyword, Keyword closingKeyword, final @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, no_space), new_line);
            }
        };
        this.textRegionExtensions.regionFor((EObject)element).keywords((Keyword[])Conversions.unwrapArray(commaKeywords, Keyword.class)).forEach(_function);
        if (compact) {
            document.append(this.textRegionExtensions.regionFor((EObject)element).keyword(openingKeyword), one_space);
            document.prepend(this.textRegionExtensions.regionFor((EObject)element).keyword(closingKeyword), one_space);
        } else {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.indent();
                }
            };
            document.interior(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)element).keyword(openingKeyword), one_space), new_line), document.prepend(this.textRegionExtensions.regionFor((EObject)element).keyword(closingKeyword), new_line), (Procedures.Procedure1)_function_1);
        }
    }

    private void formatJsonMember(ElkGraphElement element, final @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, no_space), one_space);
            }
        };
        this.textRegionExtensions.regionFor((EObject)element).keywords(new Keyword[]{this._elkGraphJsonGrammarAccess.getJsonMemberAccess().getColonKeyword_1()}).forEach(_function);
        Consumer<ISemanticRegion> _function_1 = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, one_space), new_line);
            }
        };
        this.textRegionExtensions.regionFor((EObject)element).keywords(new Keyword[]{this._elkGraphJsonGrammarAccess.getJsonArrayAccess().getLeftSquareBracketKeyword_0()}).forEach(_function_1);
        Consumer<ISemanticRegion> _function_2 = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, no_space), one_space);
            }
        };
        this.textRegionExtensions.regionFor((EObject)element).keywords(new Keyword[]{this._elkGraphJsonGrammarAccess.getJsonArrayAccess().getCommaKeyword_1_1_0(), this._elkGraphJsonGrammarAccess.getJsonArrayAccess().getCommaKeyword_2()}).forEach(_function_2);
        Consumer<ISemanticRegion> _function_3 = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, one_space), new_line);
            }
        };
        this.textRegionExtensions.regionFor((EObject)element).keywords(new Keyword[]{this._elkGraphJsonGrammarAccess.getJsonObjectAccess().getLeftCurlyBracketKeyword_0()}).forEach(_function_3);
        Consumer<ISemanticRegion> _function_4 = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, no_space), one_space);
            }
        };
        this.textRegionExtensions.regionFor((EObject)element).keywords(new Keyword[]{this._elkGraphJsonGrammarAccess.getJsonObjectAccess().getCommaKeyword_1_1_0(), this._elkGraphJsonGrammarAccess.getJsonObjectAccess().getCommaKeyword_2()}).forEach(_function_4);
    }

    public void format(Object node, IFormattableDocument document) {
        if (node instanceof ElkNode) {
            this._format((ElkNode)node, document);
            return;
        }
        if (node instanceof ElkPort) {
            this._format((ElkPort)node, document);
            return;
        }
        if (node instanceof ElkPropertyToValueMapEntryImpl) {
            this._format((ElkPropertyToValueMapEntryImpl)node, document);
            return;
        }
        if (node instanceof ElkLabel) {
            this._format((ElkLabel)node, document);
            return;
        }
        if (node instanceof ElkEdge) {
            this._format((ElkEdge)node, document);
            return;
        }
        if (node instanceof XtextResource) {
            this._format((XtextResource)node, document);
            return;
        }
        if (node instanceof EObject) {
            this._format((EObject)node, document);
            return;
        }
        if (node == null) {
            this._format(null, document);
            return;
        }
        if (node != null) {
            this._format(node, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, document).toString());
    }
}

