/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.validation;

import com.modelengineers.MoRe_elk.core.data.LayoutOptionData;
import com.modelengineers.MoRe_elk.core.validation.GraphIssue;
import com.modelengineers.MoRe_elk.core.validation.IValidatingGraphElementVisitor;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.IPropertyValueProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class LayoutOptionValidator
implements IValidatingGraphElementVisitor {
    private final List<GraphIssue> issues = new ArrayList<GraphIssue>();

    @Override
    public void visit(ElkGraphElement element) {
        for (Map.Entry entry : element.getProperties()) {
            IProperty property = (IProperty)entry.getKey();
            if (property == null) continue;
            Object value = entry.getValue();
            if (value instanceof IPropertyValueProxy && (value = ((IPropertyValueProxy)value).resolveValue(property)) != null) {
                entry.setValue(value);
            }
            this.issues.addAll(this.checkProperty(property, value, element));
        }
    }

    public List<GraphIssue> checkProperty(IProperty<Object> property, Object value, ElkGraphElement element) {
        String optionName = null;
        if (property instanceof LayoutOptionData) {
            LayoutOptionData optionData = (LayoutOptionData)property;
            optionName = optionData.getName();
            if (value != null && !this.isValidType(optionData, value)) {
                String message = "The assigned value " + value.toString() + " of the option '" + optionName + "' does not match the type " + optionData.getOptionClass().getSimpleName() + ".";
                return Collections.singletonList(new GraphIssue(element, message, GraphIssue.Severity.ERROR));
            }
        }
        if (value != null) {
            String message;
            if (property.getLowerBound().compareTo(value) > 0) {
                if (optionName == null) {
                    optionName = property.getId();
                }
                message = "The assigned value " + value.toString() + " of the option '" + optionName + "' is less than the lower bound " + property.getLowerBound().toString() + ".";
                return Collections.singletonList(new GraphIssue(element, message, GraphIssue.Severity.ERROR));
            }
            if (property.getUpperBound().compareTo(value) < 0) {
                if (optionName == null) {
                    optionName = property.getId();
                }
                message = "The assigned value " + value.toString() + " of the option '" + optionName + "' is greater than the upper bound " + property.getUpperBound().toString() + ".";
                return Collections.singletonList(new GraphIssue(element, message, GraphIssue.Severity.ERROR));
            }
        }
        return Collections.emptyList();
    }

    protected boolean isValidType(LayoutOptionData optionData, Object value) {
        switch (optionData.getType()) {
            case STRING: {
                return value instanceof String;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case INT: {
                return value instanceof Integer;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
            case ENUMSET: {
                return value instanceof EnumSet;
            }
        }
        return optionData.getOptionClass().isInstance(value);
    }

    public List<GraphIssue> getIssues() {
        return this.issues;
    }
}

