/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.util;

import com.modelengineers.MoRe_elk.core.util.IFactory;
import java.util.LinkedList;

public final class InstancePool<T> {
    public static final int INFINITE = -1;
    private final IFactory<T> factory;
    private final LinkedList<T> instances = new LinkedList();
    private int limit;
    private final Object lock = new Object();

    public InstancePool(IFactory<T> thefactory) {
        this(thefactory, -1);
    }

    public InstancePool(IFactory<T> thefactory, int thelimit) {
        assert (thefactory != null);
        this.factory = thefactory;
        this.limit = thelimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T fetch() {
        Object object = this.lock;
        synchronized (object) {
            if (this.instances.isEmpty()) {
                return this.factory.create();
            }
            return this.instances.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T obj) {
        Object object = this.lock;
        synchronized (object) {
            if (this.limit < 0 || this.instances.size() < this.limit) {
                this.instances.addLast(obj);
            } else {
                this.factory.destroy(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            for (Object obj : this.instances) {
                this.factory.destroy(obj);
            }
            this.instances.clear();
        }
    }
}

