/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.ui.views;

import com.modelengineers.MoRe_elk.core.data.LayoutOptionData;
import com.modelengineers.MoRe_elk.core.ui.ElkUiPlugin;
import com.modelengineers.MoRe_elk.core.ui.views.LayoutPropertyDescriptor;
import com.modelengineers.MoRe_elk.core.ui.views.LayoutPropertySource;
import com.modelengineers.MoRe_elk.core.validation.GraphIssue;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheetEntry;

public class ValidatingPropertySheetEntry
extends PropertySheetEntry {
    protected PropertySheetEntry createChildEntry() {
        return new ValidatingPropertySheetEntry();
    }

    protected LayoutPropertySource getSource() {
        ValidatingPropertySheetEntry e = this;
        do {
            IPropertySource source;
            Object[] values;
            if ((values = e.getValues()).length <= 0 || !((source = e.getPropertySource(values[0])) instanceof LayoutPropertySource)) continue;
            return (LayoutPropertySource)source;
        } while ((e = (ValidatingPropertySheetEntry)e.getParent()) != null);
        return null;
    }

    protected List<GraphIssue> validate() {
        Object optionValue;
        LayoutOptionData optionData;
        List<GraphIssue> result;
        LayoutPropertySource source = this.getSource();
        IPropertyDescriptor descriptor = this.getDescriptor();
        Object[] values = this.getValues();
        if (source != null && descriptor instanceof LayoutPropertyDescriptor && values.length > 0 && (result = source.validatePropertyValue(optionData = ((LayoutPropertyDescriptor)descriptor).getOptionData(), optionValue = source.translateFromUI(values[0], optionData))) != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public Image getImage() {
        Image image = super.getImage();
        List<GraphIssue> issues = this.validate();
        if (issues.isEmpty()) {
            return image;
        }
        if (image != null) {
            String overlayKey = "error_overlay/" + image.toString();
            Image result = ElkUiPlugin.getInstance().getImageRegistry().get(overlayKey);
            if (result == null) {
                DecorationOverlayIcon overlayIcon = new DecorationOverlayIcon(image, ElkUiPlugin.getImageDescriptor("icons/error_overlay.png"), 2);
                result = overlayIcon.createImage();
                ElkUiPlugin.getInstance().getImageRegistry().put(overlayKey, result);
            }
            return result;
        }
        return null;
    }

    public String getDescription() {
        String description = super.getDescription();
        List<GraphIssue> issues = this.validate();
        if (issues.isEmpty()) {
            return description;
        }
        StringBuilder builder = new StringBuilder();
        GraphIssue firstIssue = issues.get(0);
        builder.append(firstIssue.getSeverity().getUserString()).append(": ").append(firstIssue.getMessage());
        if (issues.size() > 1) {
            builder.append(" (").append(issues.size() - 1).append(" more issues)");
        }
        return builder.toString();
    }
}

