/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.service;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.modelengineers.MoRe_elk.core.LayoutConfigurator;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmResolver;
import com.modelengineers.MoRe_elk.core.data.LayoutMetaDataService;
import com.modelengineers.MoRe_elk.core.data.LayoutOptionData;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.HierarchyHandling;
import com.modelengineers.MoRe_elk.core.service.ILayoutConfigurationStore;
import com.modelengineers.MoRe_elk.core.service.LayoutMapping;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.properties.GraphFeature;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import java.util.LinkedHashSet;
import java.util.Set;

@Singleton
public class LayoutConfigurationManager {
    @Inject(optional=true)
    private ILayoutConfigurationStore.Provider configProvider;
    @Inject
    private LayoutAlgorithmResolver layoutAlgorithmResolver;

    public LayoutAlgorithmData getAlgorithm(ILayoutConfigurationStore config) {
        return LayoutMetaDataService.getInstance().getAlgorithmDataBySuffixOrDefault((String)this.getRawOptionValue(CoreOptions.ALGORITHM, config), this.layoutAlgorithmResolver.getDefaultLayoutAlgorithmID());
    }

    public Set<LayoutOptionData> getSupportedOptions(ILayoutConfigurationStore config) {
        LayoutAlgorithmData algoData;
        ILayoutConfigurationStore parentConfig;
        LayoutAlgorithmData algoData2;
        LayoutMetaDataService layoutDataService = LayoutMetaDataService.getInstance();
        LinkedHashSet<LayoutOptionData> optionData = new LinkedHashSet<LayoutOptionData>();
        Set<LayoutOptionData.Target> optionTargets = config.getOptionTargets();
        if (optionTargets.contains((Object)LayoutOptionData.Target.PARENTS) && (algoData2 = this.getAlgorithm(config)) != null) {
            optionData.addAll(layoutDataService.getOptionData(algoData2, LayoutOptionData.Target.PARENTS));
        }
        if ((parentConfig = config.getParent()) != null && (algoData = this.getAlgorithm(parentConfig)) != null) {
            for (LayoutOptionData.Target target : optionTargets) {
                if (target == LayoutOptionData.Target.PARENTS) continue;
                optionData.addAll(layoutDataService.getOptionData(algoData, target));
            }
        }
        return optionData;
    }

    public Object getOptionValue(LayoutOptionData optionData, ILayoutConfigurationStore config) {
        LayoutAlgorithmData algoData;
        ILayoutConfigurationStore parentConfig;
        LayoutAlgorithmData algoData2;
        Object result = this.getRawOptionValue(optionData, config);
        if (optionData.equals(CoreOptions.ALGORITHM)) {
            algoData2 = LayoutMetaDataService.getInstance().getAlgorithmDataBySuffixOrDefault((String)result, this.layoutAlgorithmResolver.getDefaultLayoutAlgorithmID());
            if (algoData2 != null) {
                return algoData2.getId();
            }
        } else if (result != null) {
            return result;
        }
        if (optionData.getTargets().contains((Object)LayoutOptionData.Target.PARENTS) ? (algoData2 = this.getAlgorithm(config)) != null && (result = algoData2.getDefaultValue(optionData)) != null : (parentConfig = config.getParent()) != null && (algoData = this.getAlgorithm(parentConfig)) != null && (result = algoData.getDefaultValue(optionData)) != null) {
            return result;
        }
        result = optionData.getDefault();
        if (result != null) {
            return result;
        }
        return optionData.getDefaultDefault();
    }

    protected Object getRawOptionValue(IProperty<?> option, ILayoutConfigurationStore config) {
        Object result = config.getOptionValue(option.getId());
        if (result instanceof String && option instanceof LayoutOptionData) {
            return ((LayoutOptionData)option).parseValue((String)result);
        }
        return result;
    }

    protected ILayoutConfigurationStore getResponsibleParent(ILayoutConfigurationStore config) {
        ILayoutConfigurationStore result;
        ILayoutConfigurationStore current = result = config.getParent();
        while (current != null) {
            ILayoutConfigurationStore parent = current.getParent();
            if (parent != null && this.isFullHierarchyLayout(parent)) {
                result = parent;
            }
            current = parent;
        }
        return result;
    }

    protected boolean isFullHierarchyLayout(ILayoutConfigurationStore config) {
        HierarchyHandling layoutHierarchy;
        Object layoutHierarchyVal = config.getOptionValue(CoreOptions.HIERARCHY_HANDLING.getId());
        HierarchyHandling hierarchyHandling = layoutHierarchy = layoutHierarchyVal instanceof HierarchyHandling ? (HierarchyHandling)((Object)layoutHierarchyVal) : HierarchyHandling.valueOf((String)layoutHierarchyVal);
        if (layoutHierarchy == HierarchyHandling.INCLUDE_CHILDREN) {
            LayoutAlgorithmData algoData = this.getAlgorithm(config);
            return algoData != null && (algoData.supportsFeature(GraphFeature.COMPOUND) || algoData.supportsFeature(GraphFeature.CLUSTERS));
        }
        return false;
    }

    protected ILayoutConfigurationStore getRoot(ILayoutConfigurationStore config) {
        ILayoutConfigurationStore parent;
        ILayoutConfigurationStore current = config;
        do {
            if ((parent = current.getParent()) != null) continue;
            return current;
        } while ((current = parent) != null);
        return null;
    }

    public void clearOptionValues(ILayoutConfigurationStore config) {
        for (String optionId : config.getAffectedOptions()) {
            config.setOptionValue(optionId, null);
        }
    }

    public <T> LayoutConfigurator createConfigurator(LayoutMapping layoutMapping) {
        LayoutConfigurator result = new LayoutConfigurator();
        if (this.configProvider != null) {
            this.configureElement((ElkGraphElement)layoutMapping.getLayoutGraph(), layoutMapping, result);
            UnmodifiableIterator allElements = Iterators.filter(layoutMapping.getLayoutGraph().eAllContents(), ElkGraphElement.class);
            while (allElements.hasNext()) {
                ElkGraphElement element = (ElkGraphElement)allElements.next();
                this.configureElement(element, layoutMapping, result);
            }
        }
        return result;
    }

    protected void configureElement(ElkGraphElement element, LayoutMapping layoutMapping, LayoutConfigurator configurator) {
        Object diagramPart = layoutMapping.getGraphMap().get((Object)element);
        ILayoutConfigurationStore configurationStore = this.configProvider.get(layoutMapping.getWorkbenchPart(), diagramPart);
        if (configurationStore != null) {
            this.configureElement(element, configurationStore, configurator);
        }
    }

    protected void configureElement(ElkGraphElement element, ILayoutConfigurationStore configStore, LayoutConfigurator configurator) {
        LayoutMetaDataService layoutDataService = LayoutMetaDataService.getInstance();
        for (String optionId : configStore.getAffectedOptions()) {
            Object value = configStore.getOptionValue(optionId);
            LayoutOptionData optionData = layoutDataService.getOptionData(optionId);
            if (optionData == null || value == null) continue;
            if (value instanceof String) {
                value = optionData.parseValue((String)value);
            }
            configurator.configure(element).setProperty(optionData, value);
        }
    }
}

