/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.meta.jvmmodel;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdAlgorithm;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdBundle;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdBundleMember;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdCategory;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdGraphFeature;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdGroup;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdModel;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdOption;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdOptionDependency;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdOptionSupport;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdOptionTargetType;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.Property;
import com.modelengineers.MoRe_emf.common.util.EList;
import com.modelengineers.MoRe_emf.common.util.URI;
import com.modelengineers.MoRe_emf.ecore.EObject;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class MetaDataJvmModelInferrer
extends AbstractModelInferrer {
    @Inject
    @Extension
    private JvmTypesBuilder _jvmTypesBuilder;
    @Inject
    @Extension
    private Primitives _primitives;

    protected void _infer(final MdModel model, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        if (model.getName() == null || model.getBundle() == null) {
            return;
        }
        final MdBundle bundle = model.getBundle();
        Procedures.Procedure1<JvmGenericType> _function = new Procedures.Procedure1<JvmGenericType>(){

            public void apply(JvmGenericType it) {
                EList _superTypes = it.getSuperTypes();
                JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.core.data.ILayoutMetaDataProvider", new JvmTypeReference[0]);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_superTypes, (Object)_typeRef);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setFileHeader((JvmDeclaredType)it, MetaDataJvmModelInferrer.this._jvmTypesBuilder.getDocumentation((EObject)model));
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, MetaDataJvmModelInferrer.this._jvmTypesBuilder.getDocumentation((EObject)bundle));
                Iterable _allOptionDefinitions = MetaDataJvmModelInferrer.this.getAllOptionDefinitions(bundle.getMembers());
                for (MdOption property : _allOptionDefinitions) {
                    XExpression _upperBound;
                    boolean _tripleNotEquals_2;
                    XExpression _lowerBound;
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    JvmField constant = MetaDataJvmModelInferrer.this.toOptionConstant(property);
                    XExpression _defaultValue = property.getDefaultValue();
                    boolean bl = _tripleNotEquals = _defaultValue != null;
                    if (_tripleNotEquals) {
                        EList _members = it.getMembers();
                        JvmField _optionDefault = MetaDataJvmModelInferrer.this.toOptionDefault(property);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_optionDefault);
                    }
                    boolean bl2 = _tripleNotEquals_1 = (_lowerBound = property.getLowerBound()) != null;
                    if (_tripleNotEquals_1) {
                        EList _members_1 = it.getMembers();
                        JvmField _optionLowerBound = MetaDataJvmModelInferrer.this.toOptionLowerBound(property);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_1, (Object)_optionLowerBound);
                    }
                    boolean bl3 = _tripleNotEquals_2 = (_upperBound = property.getUpperBound()) != null;
                    if (_tripleNotEquals_2) {
                        EList _members_2 = it.getMembers();
                        JvmField _optionUpperBound = MetaDataJvmModelInferrer.this.toOptionUpperBound(property);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_2, (Object)_optionUpperBound);
                    }
                    EList _members_3 = it.getMembers();
                    MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_3, (Object)constant);
                }
                Iterable _allOptionDefinitions_1 = MetaDataJvmModelInferrer.this.getAllOptionDefinitions(bundle.getMembers());
                for (MdOption property_1 : _allOptionDefinitions_1) {
                    EList<MdOptionDependency> _dependencies = property_1.getDependencies();
                    for (MdOptionDependency dependency : _dependencies) {
                        boolean _tripleNotEquals;
                        XExpression _value = dependency.getValue();
                        boolean bl = _tripleNotEquals = _value != null;
                        if (!_tripleNotEquals) continue;
                        EList _members = it.getMembers();
                        JvmField _dependencyValue = MetaDataJvmModelInferrer.this.toDependencyValue(dependency);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_dependencyValue);
                    }
                }
                EList _members_1 = it.getMembers();
                Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

                    public void apply(JvmOperation it) {
                        EList _parameters = it.getParameters();
                        JvmFormalParameter _parameter = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toParameter((EObject)bundle, "registry", MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.core.data.ILayoutMetaDataProvider.Registry", new JvmTypeReference[0]));
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_parameters, (Object)_parameter);
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                StringConcatenationClient _registerLayoutOptions = MetaDataJvmModelInferrer.this.registerLayoutOptions(bundle);
                                _builder.append((Object)_registerLayoutOptions);
                                _builder.newLineIfNotEmpty();
                                StringConcatenationClient _registerLayoutCategories = MetaDataJvmModelInferrer.this.registerLayoutCategories(bundle);
                                _builder.append((Object)_registerLayoutCategories);
                                _builder.newLineIfNotEmpty();
                                StringConcatenationClient _registerLayoutAlgorithms = MetaDataJvmModelInferrer.this.registerLayoutAlgorithms(bundle);
                                _builder.append((Object)_registerLayoutAlgorithms);
                                _builder.newLineIfNotEmpty();
                            }
                        };
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.setBody((JvmExecutable)it, _client);
                    }
                };
                JvmOperation _method = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toMethod((EObject)bundle, "apply", MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Void.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_1, (Object)_method);
            }
        };
        acceptor.accept((JvmDeclaredType)this._jvmTypesBuilder.toClass((EObject)bundle, this.getQualifiedTargetClass(bundle)), (Procedures.Procedure1)_function);
        Iterable _filter = Iterables.filter(bundle.getMembers(), MdAlgorithm.class);
        for (MdAlgorithm algorithm : _filter) {
            this.inferAlgorithm(model, algorithm, acceptor, isPreIndexingPhase);
        }
    }

    private JvmField toOptionConstant(final MdOption option) {
        JvmTypeReference _typeRef;
        JvmTypeReference _elvis = null;
        JvmTypeReference _type = option.getType();
        _elvis = _type != null ? _type : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PUBLIC);
                it.setStatic(true);
                it.setFinal(true);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        JvmTypeReference _typeRef;
                        _builder.append((Object)"new ");
                        _builder.append(Property.class);
                        _builder.append((Object)"<");
                        JvmTypeReference _elvis = null;
                        JvmTypeReference _asWrapperTypeIfPrimitive = MetaDataJvmModelInferrer.this._primitives.asWrapperTypeIfPrimitive(option.getType());
                        _elvis = _asWrapperTypeIfPrimitive != null ? _asWrapperTypeIfPrimitive : (_typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
                        _builder.append((Object)_elvis);
                        _builder.append((Object)">(");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"        ");
                        String _codeString = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(option));
                        _builder.append((Object)_codeString, "        ");
                        boolean _hasDefaultOrBounds = MetaDataJvmModelInferrer.this.hasDefaultOrBounds(option);
                        if (_hasDefaultOrBounds) {
                            boolean _tripleNotEquals_2;
                            boolean _tripleNotEquals_1;
                            boolean _tripleNotEquals;
                            _builder.append((Object)",");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"        ");
                            XExpression _defaultValue = option.getDefaultValue();
                            boolean bl = _tripleNotEquals = _defaultValue != null;
                            if (_tripleNotEquals) {
                                String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(option);
                                _builder.append((Object)_defaultConstantName, "        ");
                            } else {
                                _builder.append((Object)"null");
                            }
                            _builder.append((Object)",");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"        ");
                            XExpression _lowerBound = option.getLowerBound();
                            boolean bl2 = _tripleNotEquals_1 = _lowerBound != null;
                            if (_tripleNotEquals_1) {
                                String _lowerBoundConstantName = MetaDataJvmModelInferrer.this.getLowerBoundConstantName(option);
                                _builder.append((Object)_lowerBoundConstantName, "        ");
                            } else {
                                _builder.append((Object)"null");
                            }
                            _builder.append((Object)",");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"        ");
                            XExpression _upperBound = option.getUpperBound();
                            boolean bl3 = _tripleNotEquals_2 = _upperBound != null;
                            if (_tripleNotEquals_2) {
                                String _upperBoundConstantName = MetaDataJvmModelInferrer.this.getUpperBoundConstantName(option);
                                _builder.append((Object)_upperBoundConstantName, "        ");
                            } else {
                                _builder.append((Object)"null");
                            }
                        }
                        _builder.append((Object)")");
                    }
                };
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _client);
                boolean _isDeprecated = option.isDeprecated();
                if (_isDeprecated) {
                    EList _annotations = it.getAnnotations();
                    JvmAnnotationReference _annotationRef = MetaDataJvmModelInferrer.this._annotationTypesBuilder.annotationRef(Deprecated.class, new String[0]);
                    MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_annotations, (Object)_annotationRef);
                    it.setDeprecated(true);
                }
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, MetaDataJvmModelInferrer.this.trimLines(option.getDescription()));
            }
        };
        return this._jvmTypesBuilder.toField((EObject)option, this.getConstantName(option), this._typeReferenceBuilder.typeRef(IProperty.class, new JvmTypeReference[]{_elvis}), (Procedures.Procedure1)_function);
    }

    private boolean hasDefaultOrBounds(MdOption option) {
        return option.getDefaultValue() != null || option.getLowerBound() != null || option.getUpperBound() != null;
    }

    private JvmField toOptionDefault(final MdOption option) {
        JvmTypeReference _typeRef;
        JvmTypeReference _elvis = null;
        JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(option.getType());
        _elvis = _cloneWithProxies != null ? _cloneWithProxies : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference optionType = _elvis;
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, option.getDefaultValue());
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Default value for {@link #");
                String _constantName = MetaDataJvmModelInferrer.this.getConstantName(option);
                _builder.append(_constantName);
                _builder.append("}.");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)option, this.getDefaultConstantName(option), optionType, (Procedures.Procedure1)_function);
    }

    private JvmField toOptionLowerBound(final MdOption option) {
        JvmTypeReference _wildcard;
        JvmTypeReference _elvis = null;
        JvmTypeReference _asWrapperTypeIfPrimitive = this._primitives.asWrapperTypeIfPrimitive(option.getType());
        JvmTypeReference _wildcardSuper = null;
        if (_asWrapperTypeIfPrimitive != null) {
            _wildcardSuper = this._typeReferenceBuilder.wildcardSuper(_asWrapperTypeIfPrimitive);
        }
        _elvis = _wildcardSuper != null ? _wildcardSuper : (_wildcard = this._typeReferenceBuilder.wildcard());
        JvmTypeReference optionType = this._typeReferenceBuilder.typeRef(Comparable.class, new JvmTypeReference[]{_elvis});
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, option.getLowerBound());
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Lower bound value for {@link #");
                String _constantName = MetaDataJvmModelInferrer.this.getConstantName(option);
                _builder.append(_constantName);
                _builder.append("}.");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)option, this.getLowerBoundConstantName(option), optionType, (Procedures.Procedure1)_function);
    }

    private JvmField toOptionUpperBound(final MdOption option) {
        JvmTypeReference _wildcard;
        JvmTypeReference _elvis = null;
        JvmTypeReference _asWrapperTypeIfPrimitive = this._primitives.asWrapperTypeIfPrimitive(option.getType());
        JvmTypeReference _wildcardSuper = null;
        if (_asWrapperTypeIfPrimitive != null) {
            _wildcardSuper = this._typeReferenceBuilder.wildcardSuper(_asWrapperTypeIfPrimitive);
        }
        _elvis = _wildcardSuper != null ? _wildcardSuper : (_wildcard = this._typeReferenceBuilder.wildcard());
        JvmTypeReference optionType = this._typeReferenceBuilder.typeRef(Comparable.class, new JvmTypeReference[]{_elvis});
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, option.getUpperBound());
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Upper bound value for {@link #");
                String _constantName = MetaDataJvmModelInferrer.this.getConstantName(option);
                _builder.append(_constantName);
                _builder.append("}.");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)option, this.getUpperBoundConstantName(option), optionType, (Procedures.Procedure1)_function);
    }

    private JvmField toDependencyValue(final MdOptionDependency dependency) {
        JvmTypeReference _typeRef;
        EObject _eContainer = dependency.eContainer();
        final MdOption source = (MdOption)_eContainer;
        JvmTypeReference _elvis = null;
        JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(dependency.getTarget().getType());
        _elvis = _cloneWithProxies != null ? _cloneWithProxies : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference optionType = _elvis;
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, dependency.getValue());
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Required value for dependency between {@link #");
                String _constantName = MetaDataJvmModelInferrer.this.getConstantName(source);
                _builder.append(_constantName);
                _builder.append("} and {@link #");
                String _constantName_1 = MetaDataJvmModelInferrer.this.getConstantName(dependency.getTarget());
                _builder.append(_constantName_1);
                _builder.append("}.");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)dependency, this.getDependencyConstantName(dependency), optionType, (Procedures.Procedure1)_function);
    }

    private StringConcatenationClient registerLayoutOptions(final MdBundle bundle) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable _allOptionDefinitions = MetaDataJvmModelInferrer.this.getAllOptionDefinitions(bundle.getMembers());
                for (MdOption option : _allOptionDefinitions) {
                    boolean _not_1;
                    boolean _not;
                    XExpression _upperBound;
                    boolean _tripleNotEquals_2;
                    XExpression _lowerBound;
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    String _name;
                    _builder.append((Object)"registry.register(new ");
                    JvmTypeReference _LayoutOptionData = MetaDataJvmModelInferrer.this.LayoutOptionData();
                    _builder.append((Object)_LayoutOptionData);
                    _builder.append((Object)".Builder()");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".id(");
                    String _codeString = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(option));
                    _builder.append((Object)_codeString, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".group(");
                    Functions.Function1<MdGroup, String> _function = new Functions.Function1<MdGroup, String>(){

                        public String apply(MdGroup it) {
                            return it.getName();
                        }
                    };
                    String _codeString_1 = MetaDataJvmModelInferrer.this.toCodeString(IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)MetaDataJvmModelInferrer.this.getGroups(option), (Functions.Function1)_function), (CharSequence)"."));
                    _builder.append((Object)_codeString_1, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".name(");
                    String _elvis = null;
                    String _label = option.getLabel();
                    _elvis = _label != null ? _label : (_name = option.getName());
                    String _codeString_2 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_elvis));
                    _builder.append((Object)_codeString_2, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".description(");
                    String _codeString_3 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(option.getDescription()));
                    _builder.append((Object)_codeString_3, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    XExpression _defaultValue = option.getDefaultValue();
                    boolean bl = _tripleNotEquals = _defaultValue != null;
                    if (_tripleNotEquals) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".defaultValue(");
                        String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(option);
                        _builder.append((Object)_defaultConstantName, "    ");
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                    boolean bl2 = _tripleNotEquals_1 = (_lowerBound = option.getLowerBound()) != null;
                    if (_tripleNotEquals_1) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".lowerBound(");
                        String _lowerBoundConstantName = MetaDataJvmModelInferrer.this.getLowerBoundConstantName(option);
                        _builder.append((Object)_lowerBoundConstantName, "    ");
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                    boolean bl3 = _tripleNotEquals_2 = (_upperBound = option.getUpperBound()) != null;
                    if (_tripleNotEquals_2) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".upperBound(");
                        String _upperBoundConstantName = MetaDataJvmModelInferrer.this.getUpperBoundConstantName(option);
                        _builder.append((Object)_upperBoundConstantName, "    ");
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"    ");
                    _builder.append((Object)".type(");
                    JvmTypeReference _LayoutOptionData_1 = MetaDataJvmModelInferrer.this.LayoutOptionData();
                    _builder.append((Object)_LayoutOptionData_1, "    ");
                    _builder.append((Object)".Type.");
                    String _optionType = MetaDataJvmModelInferrer.this.getOptionType(option);
                    _builder.append((Object)_optionType, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".optionClass(");
                    JvmTypeReference _optionTypeClass = MetaDataJvmModelInferrer.this.getOptionTypeClass(option);
                    _builder.append((Object)_optionTypeClass, "    ");
                    _builder.append((Object)".class)");
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = option.getTargets().isEmpty();
                    boolean bl4 = _not = !_isEmpty;
                    if (_not) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".targets(");
                        _builder.append(EnumSet.class, "    ");
                        _builder.append((Object)".of(");
                        EList<MdOptionTargetType> _targets = option.getTargets();
                        boolean _hasElements = false;
                        for (MdOptionTargetType t : _targets) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "    ");
                            }
                            JvmTypeReference _LayoutOptionData_2 = MetaDataJvmModelInferrer.this.LayoutOptionData();
                            _builder.append((Object)_LayoutOptionData_2, "    ");
                            _builder.append((Object)".Target.");
                            String _upperCase = t.toString().toUpperCase();
                            _builder.append((Object)_upperCase, "    ");
                        }
                        _builder.append((Object)"))");
                        _builder.newLineIfNotEmpty();
                    }
                    if (option.isProgrammatic() || option.isOutput() || option.isGlobal()) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".visibility(");
                        JvmTypeReference _LayoutOptionData_3 = MetaDataJvmModelInferrer.this.LayoutOptionData();
                        _builder.append((Object)_LayoutOptionData_3, "    ");
                        _builder.append((Object)".Visibility.HIDDEN)");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _isAdvanced = option.isAdvanced();
                        if (_isAdvanced) {
                            _builder.append((Object)"    ");
                            _builder.append((Object)".visibility(");
                            JvmTypeReference _LayoutOptionData_4 = MetaDataJvmModelInferrer.this.LayoutOptionData();
                            _builder.append((Object)_LayoutOptionData_4, "    ");
                            _builder.append((Object)".Visibility.ADVANCED)");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append((Object)"    ");
                            _builder.append((Object)".visibility(");
                            JvmTypeReference _LayoutOptionData_5 = MetaDataJvmModelInferrer.this.LayoutOptionData();
                            _builder.append((Object)_LayoutOptionData_5, "    ");
                            _builder.append((Object)".Visibility.VISIBLE)");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    boolean _isEmpty_1 = option.getLegacyIds().isEmpty();
                    boolean bl5 = _not_1 = !_isEmpty_1;
                    if (_not_1) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)".legacyIds(");
                        Functions.Function1<String, String> _function_1 = new Functions.Function1<String, String>(){

                            public String apply(String it) {
                                return "\"" + it + "\"";
                            }
                        };
                        String _join = IterableExtensions.join((Iterable)ListExtensions.map(option.getLegacyIds(), (Functions.Function1)_function_1), (CharSequence)", ");
                        _builder.append((Object)_join, "    ");
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"    ");
                    _builder.append((Object)".create()");
                    _builder.newLine();
                    _builder.append((Object)");");
                    _builder.newLine();
                    EList<MdOptionDependency> _dependencies = option.getDependencies();
                    for (MdOptionDependency dependency : _dependencies) {
                        boolean _tripleEquals;
                        _builder.append((Object)"registry.addDependency(");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        String _codeString_4 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(option));
                        _builder.append((Object)_codeString_4, "    ");
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"    ");
                        String _codeString_5 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(dependency.getTarget()));
                        _builder.append((Object)_codeString_5, "    ");
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        XExpression _value = dependency.getValue();
                        boolean bl6 = _tripleEquals = _value == null;
                        if (_tripleEquals) {
                            _builder.append((Object)"    ");
                            _builder.append((Object)"null");
                            _builder.newLine();
                        } else {
                            _builder.append((Object)"    ");
                            String _dependencyConstantName = MetaDataJvmModelInferrer.this.getDependencyConstantName(dependency);
                            _builder.append((Object)_dependencyConstantName, "    ");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)");");
                        _builder.newLine();
                    }
                }
            }
        };
        return _client;
    }

    private JvmTypeReference LayoutOptionData() {
        return this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.core.data.LayoutOptionData", new JvmTypeReference[0]);
    }

    private StringConcatenationClient registerLayoutCategories(final MdBundle bundle) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable _filter = Iterables.filter(bundle.getMembers(), MdCategory.class);
                for (MdCategory category : _filter) {
                    String _name;
                    _builder.append((Object)"registry.register(new ");
                    JvmTypeReference _LayoutCategoryData = MetaDataJvmModelInferrer.this.LayoutCategoryData();
                    _builder.append((Object)_LayoutCategoryData);
                    _builder.append((Object)".Builder()");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".id(");
                    String _codeString = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(category));
                    _builder.append((Object)_codeString, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".name(");
                    String _elvis = null;
                    String _label = category.getLabel();
                    _elvis = _label != null ? _label : (_name = category.getName());
                    String _codeString_1 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_elvis));
                    _builder.append((Object)_codeString_1, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".description(");
                    String _codeString_2 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(category.getDescription()));
                    _builder.append((Object)_codeString_2, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)".create()");
                    _builder.newLine();
                    _builder.append((Object)");");
                    _builder.newLine();
                }
            }
        };
        return _client;
    }

    private JvmTypeReference LayoutCategoryData() {
        return this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.core.data.LayoutCategoryData", new JvmTypeReference[0]);
    }

    private StringConcatenationClient registerLayoutAlgorithms(final MdBundle bundle) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable _filter = Iterables.filter(bundle.getMembers(), MdAlgorithm.class);
                for (MdAlgorithm algorithm : _filter) {
                    _builder.append((Object)"new ");
                    String _qualifiedTargetClass = MetaDataJvmModelInferrer.this.getQualifiedTargetClass(algorithm);
                    _builder.append((Object)_qualifiedTargetClass);
                    _builder.append((Object)"().apply(registry);");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return _client;
    }

    private void inferAlgorithm(final MdModel model, final MdAlgorithm algorithm, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        boolean _tripleEquals;
        String _name = algorithm.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        Procedures.Procedure1<JvmGenericType> _function = new Procedures.Procedure1<JvmGenericType>(){

            public void apply(JvmGenericType it) {
                EList _superTypes = it.getSuperTypes();
                JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.core.data.ILayoutMetaDataProvider", new JvmTypeReference[0]);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_superTypes, (Object)_typeRef);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setFileHeader((JvmDeclaredType)it, MetaDataJvmModelInferrer.this._jvmTypesBuilder.getDocumentation((EObject)model));
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, algorithm.getDocumentation());
                EList _members = it.getMembers();
                JvmField _algorithmId = MetaDataJvmModelInferrer.this.toAlgorithmId(algorithm);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_algorithmId);
                EList<MdOptionSupport> _supportedOptions = algorithm.getSupportedOptions();
                for (MdOptionSupport support : _supportedOptions) {
                    boolean _tripleNotEquals;
                    XExpression _value = support.getValue();
                    boolean bl = _tripleNotEquals = _value != null;
                    if (_tripleNotEquals) {
                        EList _members_1 = it.getMembers();
                        JvmField _supportedOptionDefault = MetaDataJvmModelInferrer.this.toSupportedOptionDefault(support);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_1, (Object)_supportedOptionDefault);
                    }
                    EList _members_2 = it.getMembers();
                    JvmField _supportedOptionConstant = MetaDataJvmModelInferrer.this.toSupportedOptionConstant(support);
                    MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_2, (Object)_supportedOptionConstant);
                }
                EList _members_1 = it.getMembers();
                Procedures.Procedure1<JvmGenericType> _function = new Procedures.Procedure1<JvmGenericType>(){

                    public void apply(JvmGenericType it) {
                        EList _superTypes = it.getSuperTypes();
                        JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.core.util.IFactory<AbstractLayoutProvider>", new JvmTypeReference[0]);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_superTypes, (Object)_typeRef);
                        it.setStatic(true);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Layouter-specific algorithm factory.");
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
                        EList _members = it.getMembers();
                        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

                            public void apply(JvmOperation it) {
                                it.setVisibility(JvmVisibility.PUBLIC);
                                StringConcatenationClient _client = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"AbstractLayoutProvider provider = new ");
                                        JvmTypeReference _provider = algorithm.getProvider();
                                        _builder.append((Object)_provider);
                                        _builder.append((Object)"();");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append((Object)"provider.initialize(\"");
                                        String _parameter = algorithm.getParameter();
                                        _builder.append((Object)_parameter);
                                        _builder.append((Object)"\");");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append((Object)"return provider;");
                                        _builder.newLine();
                                    }
                                };
                                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setBody((JvmExecutable)it, _client);
                            }
                        };
                        JvmOperation _method = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toMethod((EObject)algorithm, "create", MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.core.AbstractLayoutProvider", new JvmTypeReference[0]), (Procedures.Procedure1)_function);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_method);
                        EList _members_1 = it.getMembers();
                        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

                            public void apply(JvmOperation it) {
                                EList _parameters = it.getParameters();
                                JvmFormalParameter _parameter = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toParameter((EObject)algorithm, "obj", MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.core.AbstractLayoutProvider", new JvmTypeReference[0]));
                                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_parameters, (Object)_parameter);
                                StringConcatenationClient _client = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"obj.dispose();");
                                        _builder.newLine();
                                    }
                                };
                                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setBody((JvmExecutable)it, _client);
                            }
                        };
                        JvmOperation _method_1 = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toMethod((EObject)algorithm, "destroy", MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Void.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_1, (Object)_method_1);
                    }
                };
                JvmGenericType _class = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toClass((EObject)algorithm, MetaDataJvmModelInferrer.this.toFactoryClass(algorithm), (Procedures.Procedure1)_function);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_1, (Object)_class);
                EList _members_2 = it.getMembers();
                Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

                    public void apply(JvmOperation it) {
                        EList _parameters = it.getParameters();
                        JvmFormalParameter _parameter = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toParameter((EObject)algorithm, "registry", MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.core.data.ILayoutMetaDataProvider.Registry", new JvmTypeReference[0]));
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_parameters, (Object)_parameter);
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                StringConcatenationClient _registerLayoutAlgorithm = MetaDataJvmModelInferrer.this.registerLayoutAlgorithm(algorithm);
                                _builder.append((Object)_registerLayoutAlgorithm);
                                _builder.newLineIfNotEmpty();
                            }
                        };
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.setBody((JvmExecutable)it, _client);
                    }
                };
                JvmOperation _method = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toMethod((EObject)algorithm, "apply", MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Void.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_2, (Object)_method);
            }
        };
        acceptor.accept((JvmDeclaredType)this._jvmTypesBuilder.toClass((EObject)algorithm, this.getQualifiedTargetClass(algorithm)), (Procedures.Procedure1)_function);
    }

    private String toFactoryClass(MdAlgorithm algorithm) {
        String _firstUpper = StringExtensions.toFirstUpper((String)algorithm.getName());
        return String.valueOf(_firstUpper) + "Factory";
    }

    private JvmField toAlgorithmId(final MdAlgorithm algorithm) {
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PUBLIC);
                it.setStatic(true);
                it.setFinal(true);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        String _codeString = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(algorithm));
                        _builder.append((Object)_codeString);
                    }
                };
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _client);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The id of the ");
                String _label = algorithm.getLabel();
                _builder.append(_label);
                _builder.append(" algorithm.");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)algorithm, "ALGORITHM_ID", this._typeReferenceBuilder.typeRef(String.class, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
    }

    private JvmField toSupportedOptionDefault(final MdOptionSupport support) {
        JvmTypeReference _typeRef;
        EObject _eContainer = support.eContainer();
        final MdAlgorithm algorithm = (MdAlgorithm)_eContainer;
        JvmTypeReference _elvis = null;
        JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(support.getOption().getType());
        _elvis = _cloneWithProxies != null ? _cloneWithProxies : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference optionType = _elvis;
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                String _name;
                it.setVisibility(JvmVisibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, support.getValue());
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Default value for {@link #");
                String _constantName = MetaDataJvmModelInferrer.this.getConstantName(support.getOption());
                _builder.append(_constantName);
                _builder.append("} with algorithm \"");
                String _elvis = null;
                String _label = algorithm.getLabel();
                _elvis = _label != null ? _label : (_name = algorithm.getName());
                _builder.append(_elvis);
                _builder.append("\".");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)support, this.getDefaultConstantName(support.getOption()), optionType, (Procedures.Procedure1)_function);
    }

    private JvmField toSupportedOptionConstant(final MdOptionSupport support) {
        JvmTypeReference _typeRef;
        JvmTypeReference _elvis = null;
        JvmTypeReference _type = support.getOption().getType();
        _elvis = _type != null ? _type : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                boolean _not;
                StringConcatenationClient _client_1;
                StringConcatenationClient _client;
                it.setVisibility(JvmVisibility.PUBLIC);
                it.setStatic(true);
                it.setFinal(true);
                StringConcatenationClient _xifexpression = null;
                XExpression _value = support.getValue();
                boolean _tripleEquals = _value == null;
                _xifexpression = _tripleEquals ? (_client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(MetaDataJvmModelInferrer.this.getQualifiedTargetClass(MetaDataJvmModelInferrer.this.getBundle(support.getOption())), new JvmTypeReference[0]);
                        _builder.append((Object)_typeRef);
                        _builder.append((Object)".");
                        String _constantName = MetaDataJvmModelInferrer.this.getConstantName(support.getOption());
                        _builder.append((Object)_constantName);
                    }
                }) : (_client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        JvmTypeReference _typeRef;
                        _builder.append((Object)"new ");
                        _builder.append(Property.class);
                        _builder.append((Object)"<");
                        JvmTypeReference _elvis = null;
                        JvmTypeReference _asWrapperTypeIfPrimitive = MetaDataJvmModelInferrer.this._primitives.asWrapperTypeIfPrimitive(support.getOption().getType());
                        _elvis = _asWrapperTypeIfPrimitive != null ? _asWrapperTypeIfPrimitive : (_typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
                        _builder.append((Object)_elvis);
                        _builder.append((Object)">(");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"                            ");
                        JvmTypeReference _typeRef_1 = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(MetaDataJvmModelInferrer.this.getQualifiedTargetClass(MetaDataJvmModelInferrer.this.getBundle(support.getOption())), new JvmTypeReference[0]);
                        _builder.append((Object)_typeRef_1, "                            ");
                        _builder.append((Object)".");
                        String _constantName = MetaDataJvmModelInferrer.this.getConstantName(support.getOption());
                        _builder.append((Object)_constantName, "                            ");
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"                            ");
                        String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(support.getOption());
                        _builder.append((Object)_defaultConstantName, "                            ");
                        _builder.append((Object)")");
                    }
                });
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _xifexpression);
                boolean _isDeprecated = support.getOption().isDeprecated();
                if (_isDeprecated) {
                    EList _annotations = it.getAnnotations();
                    JvmAnnotationReference _annotationRef = MetaDataJvmModelInferrer.this._annotationTypesBuilder.annotationRef(Deprecated.class, new String[0]);
                    MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_annotations, (Object)_annotationRef);
                    it.setDeprecated(true);
                }
                String _trimLines = MetaDataJvmModelInferrer.this.trimLines(support.getOption().getDescription());
                String _xifexpression_1 = null;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)support.getDocumentation());
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    String _trimLines_1 = MetaDataJvmModelInferrer.this.trimLines(support.getDocumentation());
                    _xifexpression_1 = "\n<h3>Algorithm Specific Details</h3>\n" + _trimLines_1;
                } else {
                    _xifexpression_1 = "";
                }
                String _plus = String.valueOf(_trimLines) + _xifexpression_1;
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _plus);
            }
        };
        return this._jvmTypesBuilder.toField((EObject)support, this.getConstantName(support.getOption()), this._typeReferenceBuilder.typeRef(IProperty.class, new JvmTypeReference[]{_elvis}), (Procedures.Procedure1)_function);
    }

    private StringConcatenationClient registerLayoutAlgorithm(final MdAlgorithm algorithm) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                JvmTypeReference _validator;
                boolean _tripleNotEquals_4;
                boolean _isEmpty;
                boolean _not;
                String _previewImage;
                boolean _tripleNotEquals_3;
                boolean _tripleNotEquals_2;
                MdBundle _bundle;
                boolean _tripleNotEquals_1;
                boolean _tripleNotEquals;
                String _name;
                _builder.append((Object)"registry.register(new ");
                JvmTypeReference _LayoutAlgorithmData = MetaDataJvmModelInferrer.this.LayoutAlgorithmData();
                _builder.append((Object)_LayoutAlgorithmData);
                _builder.append((Object)".Builder()");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)".id(");
                String _codeString = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(algorithm));
                _builder.append((Object)_codeString, "    ");
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)".name(");
                String _elvis = null;
                String _label = algorithm.getLabel();
                _elvis = _label != null ? _label : (_name = algorithm.getName());
                String _codeString_1 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_elvis));
                _builder.append((Object)_codeString_1, "    ");
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)".description(");
                String _codeString_2 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.shrinkWhiteSpace(algorithm.getDescription()));
                _builder.append((Object)_codeString_2, "    ");
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)".providerFactory(new ");
                String _factoryClass = MetaDataJvmModelInferrer.this.toFactoryClass(algorithm);
                _builder.append((Object)_factoryClass, "    ");
                _builder.append((Object)"())");
                _builder.newLineIfNotEmpty();
                MdCategory _category = algorithm.getCategory();
                boolean bl = _tripleNotEquals = _category != null;
                if (_tripleNotEquals) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".category(");
                    String _codeString_3 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(algorithm.getCategory()));
                    _builder.append((Object)_codeString_3, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl2 = _tripleNotEquals_1 = (_bundle = MetaDataJvmModelInferrer.this.getBundle(algorithm)) != null;
                if (_tripleNotEquals_1) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".melkBundleName(");
                    String _codeString_4 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getBundle(algorithm).getLabel());
                    _builder.append((Object)_codeString_4, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                MdModel _model = MetaDataJvmModelInferrer.this.getModel(algorithm);
                String _definingBundleId = null;
                if (_model != null) {
                    _definingBundleId = MetaDataJvmModelInferrer.this.getDefiningBundleId(_model);
                }
                boolean bl3 = _tripleNotEquals_2 = _definingBundleId != null;
                if (_tripleNotEquals_2) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".definingBundleId(");
                    String _codeString_5 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getDefiningBundleId(MetaDataJvmModelInferrer.this.getModel(algorithm)));
                    _builder.append((Object)_codeString_5, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl4 = _tripleNotEquals_3 = (_previewImage = algorithm.getPreviewImage()) != null;
                if (_tripleNotEquals_3) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".imagePath(");
                    String _codeString_6 = MetaDataJvmModelInferrer.this.toCodeString(algorithm.getPreviewImage());
                    _builder.append((Object)_codeString_6, "    ");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl5 = _not = !(_isEmpty = algorithm.getSupportedFeatures().isEmpty());
                if (_not) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".supportedFeatures(");
                    _builder.append(EnumSet.class, "    ");
                    _builder.append((Object)".of(");
                    EList<MdGraphFeature> _supportedFeatures = algorithm.getSupportedFeatures();
                    boolean _hasElements = false;
                    for (MdGraphFeature f : _supportedFeatures) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "    ");
                        }
                        JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.graph.properties.GraphFeature", new JvmTypeReference[0]);
                        _builder.append((Object)_typeRef, "    ");
                        _builder.append((Object)".");
                        String _upperCase = f.toString().toUpperCase();
                        _builder.append((Object)_upperCase, "    ");
                    }
                    _builder.append((Object)"))");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl6 = _tripleNotEquals_4 = (_validator = algorithm.getValidator()) != null;
                if (_tripleNotEquals_4) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)".validatorClass(");
                    JvmTypeReference _validator_1 = algorithm.getValidator();
                    _builder.append((Object)_validator_1, "    ");
                    _builder.append((Object)".class)");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"    ");
                _builder.append((Object)".create()");
                _builder.newLine();
                _builder.append((Object)");");
                _builder.newLine();
                EList<MdOptionSupport> _supportedOptions = algorithm.getSupportedOptions();
                for (MdOptionSupport support : _supportedOptions) {
                    boolean _tripleEquals;
                    _builder.append((Object)"registry.addOptionSupport(");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    String _codeString_7 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(algorithm));
                    _builder.append((Object)_codeString_7, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    String _codeString_8 = MetaDataJvmModelInferrer.this.toCodeString(MetaDataJvmModelInferrer.this.getQualifiedName(support.getOption()));
                    _builder.append((Object)_codeString_8, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    XExpression _value = support.getValue();
                    boolean bl7 = _tripleEquals = _value == null;
                    if (_tripleEquals) {
                        _builder.append((Object)"    ");
                        String _constantName = MetaDataJvmModelInferrer.this.getConstantName(support.getOption());
                        _builder.append((Object)_constantName, "    ");
                        _builder.append((Object)".getDefault()");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"    ");
                        String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(support.getOption());
                        _builder.append((Object)_defaultConstantName, "    ");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)");");
                    _builder.newLine();
                }
            }
        };
        return _client;
    }

    private JvmTypeReference LayoutAlgorithmData() {
        return this._typeReferenceBuilder.typeRef("com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData", new JvmTypeReference[0]);
    }

    private Iterable<MdOption> getAllOptionDefinitions(Iterable<? extends MdBundleMember> elements) {
        Functions.Function1<MdGroup, Iterable<MdOption>> _function = new Functions.Function1<MdGroup, Iterable<MdOption>>(){

            public Iterable<MdOption> apply(MdGroup it) {
                return MetaDataJvmModelInferrer.this.getAllOptionDefinitions(it.getChildren());
            }
        };
        return Iterables.concat((Iterable)Iterables.filter(elements, MdOption.class), (Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(elements, MdGroup.class), (Functions.Function1)_function)));
    }

    private String getQualifiedTargetClass(MdBundle bundle) {
        EObject _eContainer = bundle.eContainer();
        MdModel model = (MdModel)_eContainer;
        String _elvis = null;
        String _targetClass = bundle.getTargetClass();
        _elvis = _targetClass != null ? _targetClass : "Metadata";
        String bundleClass = _elvis;
        String _name = model.getName();
        String _plus = String.valueOf(_name) + ".";
        return String.valueOf(_plus) + bundleClass;
    }

    private String getQualifiedTargetClass(MdAlgorithm algorithm) {
        EObject _eContainer = this.getBundle(algorithm).eContainer();
        MdModel model = (MdModel)_eContainer;
        String _elvis = null;
        String _targetClass = algorithm.getTargetClass();
        if (_targetClass != null) {
            _elvis = _targetClass;
        } else {
            String _plus;
            String _firstUpper = StringExtensions.toFirstUpper((String)algorithm.getName());
            _elvis = _plus = String.valueOf(_firstUpper) + "Metadata";
        }
        String algorithmClass = _elvis;
        String _name = model.getName();
        String _plus_1 = String.valueOf(_name) + ".";
        return String.valueOf(_plus_1) + algorithmClass;
    }

    private Iterable<MdGroup> getGroups(MdBundleMember member) {
        LinkedList<MdGroup> _xblockexpression = null;
        LinkedList<MdGroup> groups = new LinkedList<MdGroup>();
        EObject group = member.eContainer();
        while (group instanceof MdGroup) {
            groups.addFirst((MdGroup)group);
            group = ((MdGroup)group).eContainer();
        }
        _xblockexpression = groups;
        return _xblockexpression;
    }

    private String getOptionType(MdOption option) {
        boolean _matched_1;
        String _identifier;
        JvmTypeReference _type = option.getType();
        JvmType _type_1 = null;
        if (_type != null) {
            _type_1 = _type.getType();
        }
        JvmType jvmType = _type_1;
        boolean _matched = false;
        if (jvmType instanceof JvmPrimitiveType) {
            String _name_3;
            String _name_2;
            String _name_1;
            _matched = true;
            _identifier = ((JvmPrimitiveType)jvmType).getIdentifier();
            _matched_1 = false;
            String _name = Boolean.TYPE.getName();
            if (Objects.equal((Object)_identifier, (Object)_name)) {
                _matched_1 = true;
                return "BOOLEAN";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_name_1 = Integer.TYPE.getName()))) {
                _matched_1 = true;
                return "INT";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_name_2 = Double.TYPE.getName()))) {
                _matched_1 = true;
                return "DOUBLE";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_name_3 = Float.TYPE.getName()))) {
                _matched_1 = true;
                return "DOUBLE";
            }
        }
        if (!_matched && jvmType instanceof JvmGenericType) {
            String _canonicalName_5;
            String _canonicalName_4;
            String _canonicalName_3;
            String _canonicalName_2;
            String _canonicalName_1;
            _matched = true;
            _identifier = ((JvmGenericType)jvmType).getIdentifier();
            _matched_1 = false;
            String _canonicalName = Boolean.class.getCanonicalName();
            if (Objects.equal((Object)_identifier, (Object)_canonicalName)) {
                _matched_1 = true;
                return "BOOLEAN";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName_1 = Integer.class.getCanonicalName()))) {
                _matched_1 = true;
                return "INT";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName_2 = Double.class.getCanonicalName()))) {
                _matched_1 = true;
                return "DOUBLE";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName_3 = Float.class.getCanonicalName()))) {
                _matched_1 = true;
                return "DOUBLE";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName_4 = String.class.getCanonicalName()))) {
                _matched_1 = true;
                return "STRING";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName_5 = EnumSet.class.getCanonicalName()))) {
                _matched_1 = true;
                return "ENUMSET";
            }
            return "OBJECT";
        }
        if (!_matched && jvmType instanceof JvmEnumerationType) {
            _matched = true;
            return "ENUM";
        }
        return "UNDEFINED";
    }

    private JvmTypeReference getOptionTypeClass(MdOption property) {
        JvmTypeReference _xblockexpression;
        boolean _tripleNotEquals;
        JvmTypeReference _xifexpression = null;
        JvmTypeReference _type = property.getType();
        boolean bl = _tripleNotEquals = _type != null;
        if (_tripleNotEquals) {
            _xblockexpression = null;
            JvmType _type_1 = property.getType().getType();
            if (_type_1 instanceof JvmPrimitiveType) {
                JvmType _type_2 = property.getType().getType();
                JvmPrimitiveType primitiveType = (JvmPrimitiveType)_type_2;
                String _simpleName = primitiveType.getSimpleName();
                boolean _equals = Objects.equal((Object)_simpleName, (Object)"float");
                if (_equals) {
                    return this._typeReferenceBuilder.typeRef(Double.class, new JvmTypeReference[0]);
                }
                String _simpleName_1 = primitiveType.getSimpleName();
                boolean _equals_1 = Objects.equal((Object)_simpleName_1, (Object)"long");
                if (_equals_1) {
                    return this._typeReferenceBuilder.typeRef(Integer.class, new JvmTypeReference[0]);
                }
            } else {
                JvmType _type_3 = property.getType().getType();
                if (_type_3 instanceof JvmGenericType) {
                    JvmType _type_4 = property.getType().getType();
                    JvmGenericType genericType = (JvmGenericType)_type_4;
                    String _identifier = genericType.getIdentifier();
                    boolean _equals_2 = Objects.equal((Object)_identifier, (Object)"java.lang.Float");
                    if (_equals_2) {
                        return this._typeReferenceBuilder.typeRef(Double.class, new JvmTypeReference[0]);
                    }
                    String _identifier_1 = genericType.getIdentifier();
                    boolean _equals_3 = Objects.equal((Object)_identifier_1, (Object)"java.lang.Long");
                    if (_equals_3) {
                        return this._typeReferenceBuilder.typeRef(Integer.class, new JvmTypeReference[0]);
                    }
                    String _identifier_2 = genericType.getIdentifier();
                    boolean _equals_4 = Objects.equal((Object)_identifier_2, (Object)"java.util.EnumSet");
                    if (_equals_4) {
                        JvmTypeReference _type_5 = property.getType();
                        JvmParameterizedTypeReference outer = (JvmParameterizedTypeReference)_type_5;
                        return this._jvmTypesBuilder.cloneWithProxies((JvmTypeReference)IterableExtensions.head((Iterable)outer.getArguments()));
                    }
                    String _identifier_3 = genericType.getIdentifier();
                    boolean _equals_5 = Objects.equal((Object)_identifier_3, (Object)"java.util.List");
                    if (_equals_5) {
                        return this._typeReferenceBuilder.typeRef(List.class, new JvmTypeReference[0]);
                    }
                }
            }
        } else {
            return this._typeReferenceBuilder.typeRef(Void.class, new JvmTypeReference[0]);
        }
        _xifexpression = _xblockexpression = this._primitives.asWrapperTypeIfPrimitive(this._jvmTypesBuilder.cloneWithProxies(property.getType()));
        return _xifexpression;
    }

    private MdBundle getBundle(MdBundleMember member) {
        EObject parent = member.eContainer();
        while (!(parent instanceof MdBundle)) {
            parent = parent.eContainer();
        }
        return (MdBundle)parent;
    }

    private MdModel getModel(MdBundleMember member) {
        EObject parent = member.eContainer();
        while (!(parent instanceof MdModel)) {
            parent = parent.eContainer();
        }
        return (MdModel)parent;
    }

    private String getDefiningBundleId(MdModel model) {
        URI uri = model.eResource().getURI();
        int srcIndex = ((List)Conversions.doWrapArray((Object)uri.segments())).indexOf("src");
        if (srcIndex >= 1) {
            return uri.segments()[srcIndex - 1];
        }
        return null;
    }

    private String getQualifiedName(MdBundleMember member) {
        int _lastIndexOf;
        int _plus;
        String _substring;
        String _name;
        MdBundle bundle = this.getBundle(member);
        EObject _eContainer = bundle.eContainer();
        MdModel model = (MdModel)_eContainer;
        String _elvis = null;
        String _idPrefix = bundle.getIdPrefix();
        _elvis = _idPrefix != null ? _idPrefix : (_name = model.getName());
        String prefix = _elvis;
        String _name_1 = member.getName();
        boolean _equals = Objects.equal((Object)_name_1, (Object)(_substring = prefix.substring(_plus = (_lastIndexOf = prefix.lastIndexOf(".")) + 1, prefix.length())));
        if (_equals) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        String _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty(this.getGroups(member));
        _xifexpression = _isEmpty ? "" : ".";
        String _plus_1 = String.valueOf(prefix) + _xifexpression;
        Functions.Function1<MdGroup, String> _function = new Functions.Function1<MdGroup, String>(){

            public String apply(MdGroup it) {
                return it.getName();
            }
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.getGroups(member), (Functions.Function1)_function), (CharSequence)".");
        String _plus_2 = String.valueOf(_plus_1) + _join;
        String _plus_3 = String.valueOf(_plus_2) + ".";
        String _name_2 = member.getName();
        return String.valueOf(_plus_3) + _name_2;
    }

    private String getConstantName(MdBundleMember member) {
        String name = member.getName();
        if (name != null) {
            boolean _greaterThan;
            StringBuilder result = new StringBuilder();
            Functions.Function1<MdGroup, String> _function = new Functions.Function1<MdGroup, String>(){

                public String apply(MdGroup it) {
                    return MetaDataJvmModelInferrer.this.toUpperCaseWithUnderscores(it.getName());
                }
            };
            result.append(IterableExtensions.join((Iterable)IterableExtensions.map(this.getGroups(member), (Functions.Function1)_function), (CharSequence)"_"));
            int _length = result.length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                result.append("_");
            }
            result.append(this.toUpperCaseWithUnderscores(name));
            return result.toString();
        }
        return null;
    }

    private String toUpperCaseWithUnderscores(String str) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                result.append("_");
            }
            result.append(Character.toUpperCase(c));
            ++i;
        }
        return result.toString();
    }

    private String getDefaultConstantName(MdOption option) {
        String _constantName = this.getConstantName(option);
        return String.valueOf(_constantName) + "_DEFAULT";
    }

    private String getLowerBoundConstantName(MdOption option) {
        String _constantName = this.getConstantName(option);
        return String.valueOf(_constantName) + "_LOWER_BOUND";
    }

    private String getUpperBoundConstantName(MdOption option) {
        String _constantName = this.getConstantName(option);
        return String.valueOf(_constantName) + "_UPPER_BOUND";
    }

    private String getDependencyConstantName(MdOptionDependency dependency) {
        String _xblockexpression = null;
        EObject _eContainer = dependency.eContainer();
        MdOption option = (MdOption)_eContainer;
        String _constantName = this.getConstantName(option);
        String _plus = String.valueOf(_constantName) + "_DEP_";
        String _constantName_1 = this.getConstantName(dependency.getTarget());
        String _plus_1 = String.valueOf(_plus) + _constantName_1;
        String _plus_2 = String.valueOf(_plus_1) + "_";
        int _indexOf = option.getDependencies().indexOf(dependency);
        _xblockexpression = String.valueOf(_plus_2) + Integer.valueOf(_indexOf);
        return _xblockexpression;
    }

    private String toCodeString(String s) {
        if (s == null) {
            return "null";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _convertToJavaString = Strings.convertToJavaString((String)s);
        _builder.append(_convertToJavaString);
        _builder.append("\"");
        return _builder.toString();
    }

    private String shrinkWhiteSpace(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean shrink = true;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            boolean _isWhitespace = Character.isWhitespace(c);
            if (_isWhitespace) {
                if (!shrink) {
                    result.append(" ");
                }
                shrink = true;
            } else {
                result.append(c);
                shrink = false;
            }
            ++i;
        }
        if (result.length() > 0 && Character.isWhitespace(result.charAt(result.length() - 1))) {
            int _length = result.length();
            int _minus = _length - 1;
            result.deleteCharAt(_minus);
        }
        return result.toString();
    }

    private String trimLines(String s) {
        String _xifexpression = null;
        if (s == null) {
            _xifexpression = null;
        } else {
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return it.trim();
                }
            };
            _xifexpression = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)s.split("\r?\n"))), (Functions.Function1)_function), (CharSequence)"\n");
        }
        return _xifexpression;
    }

    public void infer(EObject model, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        if (model instanceof MdModel) {
            this._infer((MdModel)model, acceptor, isPreIndexingPhase);
            return;
        }
        if (model != null) {
            this._infer(model, acceptor, isPreIndexingPhase);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model, acceptor, isPreIndexingPhase).toString());
    }
}

