/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.wizard.templates;

import org.eclipse.xtend2.lib.StringConcatenation;

public class LayoutProviderTemplate {
    public static String buildFileContent(String projectPackage, String algorithmName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(projectPackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.Collections;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.elk.core.AbstractLayoutProvider;");
        _builder.newLine();
        _builder.append("import org.eclipse.elk.core.math.ElkPadding;");
        _builder.newLine();
        _builder.append("import org.eclipse.elk.core.util.IElkProgressMonitor;");
        _builder.newLine();
        _builder.append("import org.eclipse.elk.graph.ElkEdge;");
        _builder.newLine();
        _builder.append("import org.eclipse.elk.graph.ElkEdgeSection;");
        _builder.newLine();
        _builder.append("import org.eclipse.elk.graph.ElkNode;");
        _builder.newLine();
        _builder.append("import org.eclipse.elk.graph.util.ElkGraphUtil;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import ");
        _builder.append(projectPackage);
        _builder.append(".options.");
        _builder.append(algorithmName);
        _builder.append("Options;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* A simple layout algorithm class. This algorithm already supports a number of layout options, places nodes, and");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* routes edges.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(algorithmName);
        _builder.append("LayoutProvider extends AbstractLayoutProvider {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Start progress monitor");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("progressMonitor.begin(\"");
        _builder.append(algorithmName, "        ");
        _builder.append("\", 2);");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("progressMonitor.log(\"Algorithm began\");");
        _builder.newLine();
        _builder.append("                ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Retrieve several properties");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("ElkPadding padding = layoutGraph.getProperty(");
        _builder.append(algorithmName, "        ");
        _builder.append("Options.PADDING);");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("double edgeEdgeSpacing = layoutGraph.getProperty(");
        _builder.append(algorithmName, "        ");
        _builder.append("Options.SPACING_EDGE_EDGE);");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("double edgeNodeSpacing = layoutGraph.getProperty(");
        _builder.append(algorithmName, "        ");
        _builder.append("Options.SPACING_EDGE_NODE);");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("double nodeNodeSpacing = layoutGraph.getProperty(");
        _builder.append(algorithmName, "        ");
        _builder.append("Options.SPACING_NODE_NODE);");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Get and possibly reverse the list of nodes to lay out");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("List<ElkNode> nodes = new ArrayList<>(layoutGraph.getChildren());");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (layoutGraph.getProperty(");
        _builder.append(algorithmName, "        ");
        _builder.append("Options.REVERSE_INPUT)) {");
        _builder.newLineIfNotEmpty();
        _builder.append("            ");
        _builder.append("Collections.reverse(nodes);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Create a sub monitor for node placement");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("IElkProgressMonitor nodePlacingMonitor = progressMonitor.subTask(1);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("nodePlacingMonitor.begin(\"Node Spacing\", nodes.size());");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Place the nodes");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("double currX = padding.left;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("double currY = padding.top;");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Make an output to the debug log");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("nodePlacingMonitor.log(\"currX: \" + currX);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("nodePlacingMonitor.logGraph(layoutGraph, \"No node placed yet\");");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("for (ElkNode node : nodes) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("// Set the node's coordinates");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("node.setX(currX);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("node.setY(padding.top);");
        _builder.newLine();
        _builder.append("            ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("// Advance the coordinates");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("currX += node.getWidth() + nodeNodeSpacing;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("currY = Math.max(currY, padding.top + node.getHeight());");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("nodePlacingMonitor.log(\"currX: \" + currX);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("nodePlacingMonitor.logGraph(layoutGraph, node.getIdentifier() + \" placed\");");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (!nodes.isEmpty()) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("currX -= nodeNodeSpacing;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Close the sub monitor");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("nodePlacingMonitor.done();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("progressMonitor.log(\"Node Placing done!\");");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Create sub monitor for edge routing");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("IElkProgressMonitor edgeRoutingMonitor = progressMonitor.subTask(1);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("edgeRoutingMonitor.begin(\"Edge Routing\", layoutGraph.getContainedEdges().size());");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("edgeRoutingMonitor.logGraph(layoutGraph, \"No edge routed yet\");");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Route the edges");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (!layoutGraph.getContainedEdges().isEmpty()) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("currY += edgeNodeSpacing;");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("edgeRoutingMonitor.log(\"currY: \" + currY);");
        _builder.newLine();
        _builder.append("            ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("for (ElkEdge edge : layoutGraph.getContainedEdges()) {");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("ElkNode source = ElkGraphUtil.connectableShapeToNode(edge.getSources().get(0));");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("ElkNode target = ElkGraphUtil.connectableShapeToNode(edge.getTargets().get(0));");
        _builder.newLine();
        _builder.append("                ");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("ElkEdgeSection section = ElkGraphUtil.firstEdgeSection(edge, true, true);");
        _builder.newLine();
        _builder.append("                ");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("section.setStartLocation(");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("source.getX() + source.getWidth() / 2,");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("source.getY() + source.getHeight());");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("section.setEndLocation(");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("target.getX() + target.getWidth() / 2,");
        _builder.newLine();
        _builder.append("                        ");
        _builder.append("target.getY() + target.getHeight());");
        _builder.newLine();
        _builder.append("                ");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("ElkGraphUtil.createBendPoint(section, section.getStartX(), currY);");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("ElkGraphUtil.createBendPoint(section, section.getEndX(), currY);");
        _builder.newLine();
        _builder.append("                                ");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("currY += edgeEdgeSpacing;");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("edgeRoutingMonitor.log(\"currY: \" + currY);");
        _builder.newLine();
        _builder.append("                ");
        _builder.append("edgeRoutingMonitor.logGraph(layoutGraph, source.getIdentifier() + \" -> \" + target.getIdentifier());");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("            ");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("currY -= edgeEdgeSpacing;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Close the sub monitor");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("edgeRoutingMonitor.done();");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("progressMonitor.log(\"Edge Routing done!\");");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// Set the size of the final diagram");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("layoutGraph.setWidth(currX + padding.right);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("layoutGraph.setHeight(currY + padding.bottom);");
        _builder.newLine();
        _builder.append("        ");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("// End the progress monitor");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("progressMonitor.log(\"Algorithm executed\");");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("progressMonitor.logGraph(layoutGraph, \"Final graph\");");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("progressMonitor.done();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

