/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.views.graph;

import com.modelengineers.MoRe_elk.core.debug.model.ExecutionInfo;
import com.modelengineers.MoRe_elk.core.debug.views.AbstractLayoutDebugView;
import com.modelengineers.MoRe_elk.core.debug.views.graph.GraphListLabelProvider;
import com.modelengineers.MoRe_elk.core.debug.views.graph.GraphTreeLabelProvider;
import com.modelengineers.MoRe_elk.core.debug.views.graph.ImageExportAction;
import com.modelengineers.MoRe_elk.core.debug.views.graph.LayoutGraphViewDropAdapter;
import com.modelengineers.MoRe_elk.core.debug.views.graph.LayoutUponLoadSettingAction;
import com.modelengineers.MoRe_elk.core.debug.views.graph.LoadGraphAction;
import com.modelengineers.MoRe_elk.core.debug.views.graph.ReloadFromFileAction;
import com.modelengineers.MoRe_elk.core.ui.rendering.GraphRenderingCanvas;
import com.modelengineers.MoRe_elk.core.util.LoggedGraph;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LayoutGraphView
extends AbstractLayoutDebugView {
    public static final String VIEW_ID = "com.modelengineers.MoRe_elk.debug.graphView";
    private final LayoutUponLoadSettingAction layoutUponLoadSettingAction = new LayoutUponLoadSettingAction();
    private final LoadGraphAction loadGraphAction = new LoadGraphAction(this);
    private final ReloadFromFileAction reloadFromFileAction = new ReloadFromFileAction(this);
    private final ImageExportAction saveImageAction = new ImageExportAction(this);
    private GraphListLabelProvider graphListLabelProvider = new GraphListLabelProvider();
    private TableViewer graphListViewer;
    private Composite canvasStackComposite;
    private StackLayout canvasStackLayout;
    private ScrolledComposite visualGraphCanvasComposite;
    private GraphRenderingCanvas visualGraphCanvas;
    private Text textualGraphCanvas;

    public LayoutGraphView() {
        super(VIEW_ID, "elk.debug.logs");
    }

    @Override
    public void dispose() {
        super.dispose();
        this.graphListLabelProvider.dispose();
    }

    public GraphRenderingCanvas getCanvas() {
        if (this.visualGraphCanvas.getLayoutGraph() != null && this.canvasStackLayout.topControl == this.visualGraphCanvasComposite) {
            return this.visualGraphCanvas;
        }
        return null;
    }

    @Override
    protected void treeSelectionChanged() {
        super.treeSelectionChanged();
        List loggedGraphs = this.getSelectedExecutionInfos().stream().flatMap(info -> info.getLoggedGraphs().stream()).collect(Collectors.toList());
        this.graphListViewer.setInput(loggedGraphs);
        if (!loggedGraphs.isEmpty()) {
            this.graphListViewer.setSelection((ISelection)new StructuredSelection(loggedGraphs.get(0)), true);
        }
        this.updateActionEnablement();
    }

    @Override
    protected Predicate<ExecutionInfo> getTreeFilter() {
        return info -> info.hasLoggedGraphs() || info.hasDescendantsWithLoggedGraphs();
    }

    private void listSelectionChanged() {
        IStructuredSelection selection = this.graphListViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            this.visualGraphCanvas.setLayoutGraph(null);
            this.textualGraphCanvas.setText("");
        } else {
            this.showLoggedGraph((LoggedGraph)selection.getFirstElement());
        }
        this.updateActionEnablement();
    }

    private void showLoggedGraph(LoggedGraph graphInfo) {
        switch (graphInfo.getGraphType()) {
            case ELK: {
                this.showGraphOnCanvas((ElkNode)graphInfo.getGraph());
                break;
            }
            default: {
                this.showTextOnCanvas(graphInfo.getGraph().toString());
            }
        }
    }

    private void showGraphOnCanvas(ElkNode graph) {
        this.canvasStackLayout.topControl = this.visualGraphCanvasComposite;
        this.canvasStackComposite.layout();
        this.visualGraphCanvas.setLayoutGraph(graph);
        this.textualGraphCanvas.setText("");
    }

    private void showTextOnCanvas(String text) {
        this.canvasStackLayout.topControl = this.textualGraphCanvas;
        this.canvasStackComposite.layout();
        this.textualGraphCanvas.setText(text);
        this.visualGraphCanvas.setLayoutGraph(null);
    }

    @Override
    protected void customizeMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.layoutUponLoadSettingAction);
    }

    @Override
    protected void customizeToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.loadGraphAction);
        toolBarManager.add((IAction)this.reloadFromFileAction);
        toolBarManager.add((IAction)this.saveImageAction);
        toolBarManager.add((IContributionItem)new Separator());
    }

    @Override
    protected void customizeTreeViewer(TreeViewer treeViewer) {
        treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new GraphTreeLabelProvider()));
        int ops = 3;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        treeViewer.addDropSupport(ops, transfers, (DropTargetListener)new LayoutGraphViewDropAdapter(this, (Viewer)treeViewer));
    }

    @Override
    protected void setupRemainingControls(Composite parent) {
        this.setupGraphListViewer(parent);
        this.setupCanvasStack(parent);
        this.updateActionEnablement();
    }

    private void setupGraphListViewer(Composite parent) {
        this.graphListViewer = new TableViewer(parent);
        this.graphListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.graphListViewer.setLabelProvider((IBaseLabelProvider)this.graphListLabelProvider);
        this.graphListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LayoutGraphView.this.listSelectionChanged();
            }
        });
    }

    private void setupCanvasStack(Composite parent) {
        this.canvasStackComposite = new Composite(parent, 0);
        this.textualGraphCanvas = new Text(this.canvasStackComposite, 768);
        this.textualGraphCanvas.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.visualGraphCanvasComposite = new ScrolledComposite(this.canvasStackComposite, 768);
        this.visualGraphCanvasComposite.setBackground(parent.getDisplay().getSystemColor(25));
        this.visualGraphCanvas = new GraphRenderingCanvas((Composite)this.visualGraphCanvasComposite);
        this.visualGraphCanvasComposite.setContent((Control)this.visualGraphCanvas);
        this.canvasStackLayout = new StackLayout();
        this.canvasStackComposite.setLayout((Layout)this.canvasStackLayout);
        this.canvasStackLayout.topControl = null;
    }

    private void updateActionEnablement() {
        this.reloadFromFileAction.updateEnablement();
        this.saveImageAction.updateEnablement();
    }
}

