/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.actions;

import com.modelengineers.MoRe_elk.core.debug.model.ExecutionInfo;
import com.modelengineers.MoRe_elk.core.debug.views.AbstractLayoutDebugView;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.program.Program;

public class RevealLogFolderAction
extends Action {
    private static final String ACTION_ID = "com.modelengineers.MoRe_elk.debug.actions.revealLogFolder";
    private AbstractLayoutDebugView view;

    public RevealLogFolderAction(AbstractLayoutDebugView theview) {
        this.setId(ACTION_ID);
        this.setText("&Reveal Log Folder");
        this.setToolTipText("Shows the monitor's debug output folder in the system explorer.");
        this.view = theview;
    }

    public void updateEnablement() {
        ExecutionInfo selectedInfo = this.getSingleSelectedExecutionInfoOrNull();
        if (selectedInfo == null) {
            this.setEnabled(false);
        } else {
            Path debugFolder = selectedInfo.getDebugFolder();
            this.setEnabled(debugFolder != null && Files.isDirectory(debugFolder, new LinkOption[0]));
        }
    }

    public void run() {
        ExecutionInfo selectedInfo = this.getSingleSelectedExecutionInfoOrNull();
        if (selectedInfo != null && Files.isDirectory(selectedInfo.getDebugFolder(), new LinkOption[0])) {
            Program.launch((String)selectedInfo.getDebugFolder().toString());
        }
    }

    private ExecutionInfo getSingleSelectedExecutionInfoOrNull() {
        List<ExecutionInfo> selectedInfos = this.view.getSelectedExecutionInfos();
        if (selectedInfos.size() == 1) {
            return selectedInfos.get(0);
        }
        return null;
    }
}

