/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.data;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.modelengineers.MoRe_elk.core.data.ILayoutMetaData;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.data.LayoutMetaDataService;
import com.modelengineers.MoRe_elk.core.data.LayoutOptionData;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkLabel;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class LayoutDataContentAssist {
    private LayoutDataContentAssist() {
    }

    public static List<Proposal<LayoutOptionData>> getLayoutOptionProposals(ElkGraphElement element, String prefix) {
        LayoutAlgorithmData responsibleAlgorithm = LayoutDataContentAssist.getAlgorithm(element);
        if (element instanceof ElkNode) {
            ImmutableSet targets = ((ElkNode)element).getChildren().isEmpty() ? ImmutableSet.of((Object)((Object)LayoutOptionData.Target.NODES)) : ImmutableSet.of((Object)((Object)LayoutOptionData.Target.NODES), (Object)((Object)LayoutOptionData.Target.PARENTS));
            return LayoutDataContentAssist.getLayoutOptionProposals(element, responsibleAlgorithm, (Set<LayoutOptionData.Target>)targets, prefix);
        }
        if (element instanceof ElkEdge) {
            return LayoutDataContentAssist.getLayoutOptionProposals(element, responsibleAlgorithm, LayoutOptionData.Target.EDGES, prefix);
        }
        if (element instanceof ElkPort) {
            return LayoutDataContentAssist.getLayoutOptionProposals(element, responsibleAlgorithm, LayoutOptionData.Target.PORTS, prefix);
        }
        if (element instanceof ElkLabel) {
            return LayoutDataContentAssist.getLayoutOptionProposals(element, responsibleAlgorithm, LayoutOptionData.Target.LABELS, prefix);
        }
        return Collections.emptyList();
    }

    public static List<Proposal<LayoutAlgorithmData>> getLayoutAlgorithmProposals(String prefix) {
        return LayoutMetaDataService.getInstance().getAlgorithmData().stream().map(o -> LayoutDataContentAssist.matchesPrefix(o, LayoutMetaDataService.getInstance()::getAlgorithmDataBySuffix, prefix)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static List<Proposal<Object>> getLayoutOptionValueProposal(LayoutOptionData option, String prefix) {
        ArrayList proposals = Lists.newArrayList();
        switch (option.getType()) {
            case BOOLEAN: 
            case ENUM: 
            case ENUMSET: {
                String[] choices = option.getChoices();
                int i = 0;
                while (i < choices.length) {
                    String proposal;
                    String label = proposal = choices[i];
                    Enum<?> enumVal = option.getEnumValue(i);
                    if (ElkGraphUtil.isExperimentalPropertyValue(enumVal)) {
                        label = String.valueOf(label) + " - Experimental";
                    } else if (ElkGraphUtil.isAdvancedPropertyValue(enumVal)) {
                        label = String.valueOf(label) + " - Advanced";
                    }
                    proposals.add(Proposal.of(proposal, label));
                    ++i;
                }
                break;
            }
            case INT: 
            case DOUBLE: {
                proposals.add(Proposal.of(option.getDefaultDefault().toString(), option.getType().toString()));
                break;
            }
            case OBJECT: {
                String proposal = "";
                try {
                    proposal = "\"" + option.getOptionClass().newInstance().toString() + "\"";
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                proposals.add(Proposal.of(proposal, option.getType().toString()));
            }
        }
        return proposals;
    }

    private static List<Proposal<LayoutOptionData>> getLayoutOptionProposals(ElkGraphElement element, LayoutAlgorithmData algorithmData, LayoutOptionData.Target targetType, String prefix) {
        return LayoutDataContentAssist.getLayoutOptionProposals(element, algorithmData, targetType != null ? Sets.newHashSet((Object[])new LayoutOptionData.Target[]{targetType}) : Collections.emptySet(), prefix);
    }

    private static List<Proposal<LayoutOptionData>> getLayoutOptionProposals(ElkGraphElement element, LayoutAlgorithmData algorithmData, Set<LayoutOptionData.Target> targetTypes, String prefix) {
        return LayoutMetaDataService.getInstance().getOptionData().stream().filter(o -> o.getTargets() == null || o.getTargets().isEmpty() || !Collections.disjoint(targetTypes, o.getTargets())).filter(o -> algorithmData == null || algorithmData.knowsOption((IProperty<?>)o) || o.equals(CoreOptions.ALGORITHM)).filter(o -> element == null || !element.getProperties().containsKey(o)).filter(o -> o.getVisibility() != LayoutOptionData.Visibility.HIDDEN).map(o -> LayoutDataContentAssist.matchesPrefix(o, LayoutMetaDataService.getInstance()::getOptionDataBySuffix, prefix)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static <T extends ILayoutMetaData> Optional<Proposal<T>> matchesPrefix(T data, Function<String, T> checker, String prefix) {
        boolean matchesName = !Strings.isNullOrEmpty((String)prefix) && data.getName().toLowerCase().contains(prefix.toLowerCase());
        List<String> idSplit = Arrays.asList(data.getId().split("\\."));
        List<String> prefixSplit = matchesName ? null : Arrays.asList(prefix.split("\\."));
        int start = idSplit.size() - 1;
        if (data instanceof LayoutOptionData) {
            LayoutOptionData layoutOption = (LayoutOptionData)data;
            if (!Strings.isNullOrEmpty((String)layoutOption.getGroup())) {
                --start;
            }
            long numberOfGroups = layoutOption.getGroup().chars().filter(c -> c == 46).count();
            start = (int)((long)start - numberOfGroups);
        }
        int i = start;
        while (i >= 0) {
            List<String> suffixElements = idSplit.subList(i, idSplit.size());
            String suffix = Joiner.on((char)'.').join(suffixElements);
            if (checker.apply(suffix) != null && (matchesName || LayoutDataContentAssist.startsWith(suffixElements, prefixSplit))) {
                return Optional.of(Proposal.of(suffix, data));
            }
            --i;
        }
        return Optional.empty();
    }

    private static boolean startsWith(List<String> strings, List<String> prefix) {
        if (prefix.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < strings.size() - prefix.size() + 1) {
            int j = 0;
            boolean matches = true;
            while (j < prefix.size() && matches) {
                matches = strings.get(i + j).startsWith(prefix.get(j));
                ++j;
            }
            if (matches) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static LayoutAlgorithmData getAlgorithm(ElkGraphElement element) {
        String algorithmId;
        ElkNode relevantNode = LayoutDataContentAssist.getRelevantNode(element);
        if (relevantNode != null && !Strings.isNullOrEmpty((String)(algorithmId = relevantNode.getProperty(CoreOptions.ALGORITHM)))) {
            return LayoutMetaDataService.getInstance().getAlgorithmDataBySuffix(algorithmId);
        }
        return null;
    }

    private static ElkNode getRelevantNode(ElkGraphElement element) {
        if (element instanceof ElkNode) {
            ElkNode node = (ElkNode)element;
            if (node.getParent() != null) {
                return node.getParent();
            }
            return node;
        }
        if (element instanceof ElkEdge) {
            ElkEdge edge = (ElkEdge)element;
            return edge.getContainingNode();
        }
        if (element instanceof ElkPort) {
            ElkPort port = (ElkPort)element;
            if (port.getParent() != null && port.getParent().getParent() != null) {
                return port.getParent().getParent();
            }
            if (port.getParent() != null) {
                return port.getParent();
            }
        } else if (element instanceof ElkLabel) {
            ElkLabel label = (ElkLabel)element;
            ElkGraphElement parent = label.getParent();
            while (parent instanceof ElkLabel) {
                ElkLabel parentLabel = (ElkLabel)parent;
                parent = parentLabel.getParent();
            }
            return LayoutDataContentAssist.getRelevantNode(parent);
        }
        return null;
    }

    public static final class Proposal<T> {
        public final String proposal;
        public final String label;
        public final T data;

        private Proposal(String proposal, String label, T data) {
            this.proposal = proposal;
            this.label = label;
            this.data = data;
        }

        public static <T> Proposal<T> of(String proposal, String label, T data) {
            return new Proposal<T>(proposal, label, data);
        }

        public static <T> Proposal<T> of(String proposal, String label) {
            return new Proposal<Object>(proposal, label, null);
        }

        public static <T> Proposal<T> of(String proposal, T data) {
            return new Proposal<T>(proposal, null, data);
        }
    }
}

