/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.data;

import com.modelengineers.MoRe_elk.core.UnsupportedConfigurationException;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.data.LayoutMetaDataService;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.core.util.IGraphElementVisitor;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkNode;

public class LayoutAlgorithmResolver
implements IGraphElementVisitor {
    @Override
    public void visit(ElkGraphElement element) {
        if (element instanceof ElkNode && !element.getProperty(CoreOptions.NO_LAYOUT).booleanValue()) {
            this.resolveAlgorithm((ElkNode)element);
        }
    }

    protected void resolveAlgorithm(ElkNode node) {
        String algorithmId = node.getProperty(CoreOptions.ALGORITHM);
        if (this.resolveAndSetAlgorithm(algorithmId, node)) {
            return;
        }
        if (this.mustResolve(node)) {
            if (algorithmId == null || algorithmId.trim().isEmpty()) {
                String defaultAlgorithmId = this.getDefaultLayoutAlgorithmID();
                if (!this.resolveAndSetAlgorithm(this.getDefaultLayoutAlgorithmID(), node)) {
                    StringBuilder message = new StringBuilder("Unable to load default layout algorithm ").append(defaultAlgorithmId).append(" for unconfigured node ");
                    ElkUtil.printElementPath(node, message);
                    throw new UnsupportedConfigurationException(message.toString());
                }
            } else {
                StringBuilder message = new StringBuilder("Layout algorithm '").append(algorithmId).append("' not found for ");
                ElkUtil.printElementPath(node, message);
                throw new UnsupportedConfigurationException(message.toString());
            }
        }
    }

    protected boolean resolveAndSetAlgorithm(String algorithmId, ElkNode node) {
        LayoutAlgorithmData algorithmData = LayoutMetaDataService.getInstance().getAlgorithmDataBySuffix(algorithmId);
        if (algorithmData != null) {
            node.setProperty(CoreOptions.RESOLVED_ALGORITHM, algorithmData);
            return true;
        }
        return false;
    }

    protected boolean mustResolve(ElkNode node) {
        return !node.hasProperty(CoreOptions.RESOLVED_ALGORITHM) && (!node.getChildren().isEmpty() || node.getProperty(CoreOptions.INSIDE_SELF_LOOPS_ACTIVATE) != false);
    }

    public String getDefaultLayoutAlgorithmID() {
        return "com.modelengineers.MoRe_elk.layered";
    }
}

