/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.comments;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.modelengineers.MoRe_elk.core.comments.DistanceMatcher;
import com.modelengineers.MoRe_elk.core.comments.IBoundsProvider;
import com.modelengineers.MoRe_elk.core.comments.IDataProvider;
import com.modelengineers.MoRe_elk.core.comments.IMatcher;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NodeReferenceMatcher<C, T>
implements IMatcher<C, T> {
    private Function<C, String> commentTextFunction = null;
    private Function<T, String> targetNameFunction = null;
    private IBoundsProvider<C, T> boundsProvider = null;
    private double maxDistance = -1.0;
    private boolean fuzzy = false;
    private Map<C, T> foundAttachments = Maps.newHashMap();

    public NodeReferenceMatcher<C, T> withCommentTextProvider(Function<C, String> f) {
        Objects.requireNonNull(f, "Comment text function cannot be null.");
        this.commentTextFunction = f;
        return this;
    }

    public NodeReferenceMatcher<C, T> withTargetNameProvider(Function<T, String> f) {
        Objects.requireNonNull(f, "Node name function cannot be null.");
        this.targetNameFunction = f;
        return this;
    }

    public NodeReferenceMatcher<C, T> withFuzzyMatching() {
        this.fuzzy = true;
        return this;
    }

    public NodeReferenceMatcher<C, T> withMaximumAttachmentDistance(double distance) {
        this.maxDistance = distance;
        return this;
    }

    public NodeReferenceMatcher<C, T> withBoundsProvider(IBoundsProvider<C, T> provider) {
        Objects.requireNonNull(provider, "Bounds provider must not be null.");
        this.boundsProvider = provider;
        return this;
    }

    private void checkConfiguration() {
        if (this.commentTextFunction == null) {
            throw new IllegalStateException("A comment text function is required.");
        }
        if (this.targetNameFunction == null) {
            throw new IllegalStateException("A node name function is required.");
        }
        if (this.maxDistance >= 0.0 && this.boundsProvider == null) {
            throw new IllegalStateException("A bounds provider must be installed if a maximum attachment distance is set.");
        }
    }

    @Override
    public void preprocess(IDataProvider<C, T> dataProvider, boolean includeHierarchy) {
        this.checkConfiguration();
        ArrayList commentTexts = Lists.newArrayList();
        for (C comment : dataProvider.provideComments()) {
            String commentText = this.commentTextFunction.apply(comment);
            if (Strings.isNullOrEmpty((String)commentText)) continue;
            commentTexts.add(Pair.of(comment, commentText));
        }
        ArrayList targetNames = Lists.newArrayList();
        for (T t : dataProvider.provideTargets()) {
            String targetName = this.targetNameFunction.apply(t);
            if (Strings.isNullOrEmpty((String)targetName)) continue;
            targetNames.add(Pair.of(t, targetName));
        }
        this.goFindMatches(commentTexts, targetNames);
        if (includeHierarchy) {
            for (IDataProvider iDataProvider : dataProvider.provideSubHierarchies()) {
                this.preprocess(iDataProvider, true);
            }
        }
    }

    @Override
    public void cleanup() {
        this.foundAttachments.clear();
    }

    @Override
    public double raw(C comment, T target) {
        return this.foundAttachments.get(comment) == target ? 1 : 0;
    }

    @Override
    public double normalized(C comment, T target) {
        return this.raw(comment, target);
    }

    private void goFindMatches(List<Pair<C, String>> commentTexts, List<Pair<T, String>> targetNames) {
        ArrayList targetRegexps = Lists.newArrayListWithCapacity((int)targetNames.size());
        for (Pair<T, String> pair : targetNames) {
            Pattern regexp = this.fuzzy ? NodeReferenceMatcher.fuzzyRegexpFor(pair.getSecond()) : NodeReferenceMatcher.strictRegexpFor(pair.getSecond());
            targetRegexps.add(Pair.of(pair.getFirst(), regexp));
        }
        for (Pair<Object, String> pair : commentTexts) {
            Rectangle2D.Double nodeBounds;
            Object foundTarget = null;
            for (Pair targetRegexpPair : targetRegexps) {
                Matcher matcher = ((Pattern)targetRegexpPair.getSecond()).matcher(pair.getSecond());
                if (!matcher.find()) continue;
                if (foundTarget == null) {
                    foundTarget = targetRegexpPair.getFirst();
                    continue;
                }
                foundTarget = null;
                break;
            }
            if (foundTarget == null) continue;
            if (this.maxDistance < 0.0) {
                this.foundAttachments.put(pair.getFirst(), foundTarget);
                continue;
            }
            Rectangle2D.Double commentBounds = this.boundsProvider.boundsForComment(pair.getFirst());
            if (!(DistanceMatcher.distance(commentBounds, nodeBounds = this.boundsProvider.boundsForTarget(foundTarget)) <= this.maxDistance)) continue;
            this.foundAttachments.put(pair.getFirst(), foundTarget);
        }
    }

    private static Pattern fuzzyRegexpFor(String targetName) {
        String trimmedTargetName = targetName.trim();
        StringBuffer regexp = new StringBuffer(targetName.length() * 2);
        StringBuffer currentSegment = new StringBuffer(targetName.length());
        int i = 0;
        while (i < trimmedTargetName.length()) {
            char currC = trimmedTargetName.charAt(i);
            if (Character.isUpperCase(currC)) {
                if (i > 0 && Character.isLowerCase(trimmedTargetName.charAt(i - 1))) {
                    regexp.append(Pattern.quote(currentSegment.toString()));
                    currentSegment = new StringBuffer(targetName.length());
                    regexp.append("[\\h\\v]*");
                }
                currentSegment.append(currC);
            } else if (Character.isWhitespace(currC)) {
                if (i > 0 && !Character.isWhitespace(trimmedTargetName.charAt(i - 1))) {
                    regexp.append(Pattern.quote(currentSegment.toString()));
                    currentSegment = new StringBuffer(targetName.length());
                    regexp.append("[\\h\\v]*");
                }
            } else {
                currentSegment.append(currC);
            }
            ++i;
        }
        regexp.append(Pattern.quote(currentSegment.toString()));
        return Pattern.compile("\\b" + regexp.toString() + "\\b", 34);
    }

    private static Pattern strictRegexpFor(String targetName) {
        return Pattern.compile("\\b" + Pattern.quote(targetName) + "\\b", 32);
    }

    public Map<C, T> getAttachments() {
        return this.foundAttachments;
    }
}

