/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.comments;

import com.modelengineers.MoRe_elk.core.comments.AbstractNormalizedMatcher;
import com.modelengineers.MoRe_elk.core.comments.IBoundsProvider;
import com.modelengineers.MoRe_elk.core.comments.IDataProvider;
import java.awt.geom.Rectangle2D;
import java.util.Objects;

public final class AlignmentMatcher<C, T>
extends AbstractNormalizedMatcher<C, T> {
    private IBoundsProvider<C, T> boundsProvider = null;
    private static final int TOP = 2;
    private static final int LEFT = 1;
    private static final int RIGHT = 4;
    private static final int BOTTOM = 8;
    private static final int TOP_LEFT = 3;
    private static final int BOTTOM_LEFT = 9;
    private static final int TOP_RIGHT = 6;
    private static final int BOTTOM_RIGHT = 12;

    public AlignmentMatcher<C, T> withMaximumAlignmentOffset(double offset) {
        if (offset <= 0.0) {
            throw new IllegalArgumentException("Maximum alignment offset must be > 0.");
        }
        super.withBounds(offset, 0.0);
        return this;
    }

    public AlignmentMatcher<C, T> withBoundsProvider(IBoundsProvider<C, T> provider) {
        Objects.requireNonNull(provider, "Bounds provider must not be null.");
        this.boundsProvider = provider;
        return this;
    }

    @Override
    public AlignmentMatcher<C, T> withNormalizationFunction(AbstractNormalizedMatcher.NormalizationFunction normalizationFunction) {
        super.withNormalizationFunction(normalizationFunction);
        return this;
    }

    private void checkConfiguration() {
        if (this.boundsProvider == null) {
            throw new IllegalStateException("A bounds provider is required.");
        }
    }

    @Override
    public void preprocess(IDataProvider<C, T> dataProvider, boolean includeHierarchy) {
        super.preprocess(dataProvider, includeHierarchy);
        this.checkConfiguration();
    }

    @Override
    public double raw(C comment, T target) {
        Rectangle2D.Double nodeBounds;
        Rectangle2D.Double commentBounds = this.boundsProvider.boundsForComment(comment);
        double alignment = AlignmentMatcher.alignment(commentBounds, nodeBounds = this.boundsProvider.boundsForTarget(target));
        return alignment == -1.0 ? this.getWorstRawValue() : alignment;
    }

    public static double alignment(Rectangle2D.Double bounds1, Rectangle2D.Double bounds2) {
        int topLeftOutcode = bounds2.outcode(bounds1.x, bounds1.y);
        int bottomRightOutcode = bounds2.outcode(bounds1.x + bounds1.width, bounds1.y + bounds1.height);
        if ((bottomRightOutcode & topLeftOutcode & 3) == 3 || (bottomRightOutcode & topLeftOutcode & 6) == 6 || (bottomRightOutcode & topLeftOutcode & 9) == 9 || (bottomRightOutcode & topLeftOutcode & 0xC) == 12) {
            return -1.0;
        }
        double horizontalAlignmentOffset = Math.min(Math.abs(bounds2.x - bounds1.x), Math.abs(bounds2.x + bounds2.width - bounds1.x - bounds1.width));
        double verticalAlignmentOffset = Math.min(Math.abs(bounds2.y - bounds1.y), Math.abs(bounds2.y + bounds2.height - bounds1.y - bounds1.height));
        if (bounds2.intersects(bounds1)) {
            return Math.min(horizontalAlignmentOffset, verticalAlignmentOffset);
        }
        if ((bottomRightOutcode & 2) != 0 || (topLeftOutcode & 8) != 0) {
            return horizontalAlignmentOffset;
        }
        if ((bottomRightOutcode & 1) != 0 || (topLeftOutcode & 4) != 0) {
            return verticalAlignmentOffset;
        }
        if (bounds1.y == bounds2.y + bounds2.height || bounds1.y + bounds1.height == bounds2.y) {
            return horizontalAlignmentOffset;
        }
        if (bounds1.x == bounds2.x + bounds2.width || bounds1.x + bounds1.width == bounds2.x) {
            return verticalAlignmentOffset;
        }
        return -1.0;
    }
}

