/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.alg;

import com.google.common.collect.Sets;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessorFactory;
import com.modelengineers.MoRe_elk.core.util.AbstractRandomListAccessor;
import java.util.Collection;
import java.util.Set;

public final class LayoutProcessorConfiguration<P extends Enum<P>, G>
extends AbstractRandomListAccessor<Set<ILayoutProcessorFactory<G>>> {
    private int currentIndex;

    public static <P extends Enum<P>, G> LayoutProcessorConfiguration<P, G> create() {
        return new LayoutProcessorConfiguration<P, G>();
    }

    public static <P extends Enum<P>, G> LayoutProcessorConfiguration<P, G> createFrom(LayoutProcessorConfiguration<P, G> source) {
        return new LayoutProcessorConfiguration<P, G>().addAll(source);
    }

    private LayoutProcessorConfiguration() {
        this.clear();
    }

    LayoutProcessorConfiguration<P, G> clear() {
        this.clearList();
        this.currentIndex = -1;
        return this;
    }

    public LayoutProcessorConfiguration<P, G> before(P phase) {
        this.currentIndex = ((Enum)phase).ordinal();
        return this;
    }

    public LayoutProcessorConfiguration<P, G> after(P phase) {
        this.currentIndex = ((Enum)phase).ordinal() + 1;
        return this;
    }

    public LayoutProcessorConfiguration<P, G> add(ILayoutProcessorFactory<G> processor) {
        if (this.currentIndex < 0) {
            throw new IllegalStateException("Did not call before(...) or after(...) before calling add(...).");
        }
        this.doAdd(this.currentIndex, processor);
        return this;
    }

    public LayoutProcessorConfiguration<P, G> addBefore(P phase, ILayoutProcessorFactory<G> processor) {
        this.currentIndex = -1;
        this.doAdd(((Enum)phase).ordinal(), processor);
        return this;
    }

    public LayoutProcessorConfiguration<P, G> addAfter(P phase, ILayoutProcessorFactory<G> processor) {
        this.currentIndex = -1;
        this.doAdd(((Enum)phase).ordinal() + 1, processor);
        return this;
    }

    private void doAdd(int index, ILayoutProcessorFactory<G> processor) {
        ((Set)this.getListItem(index)).add(processor);
    }

    public LayoutProcessorConfiguration<P, G> addAll(LayoutProcessorConfiguration<P, G> configuration) {
        int i = 0;
        while (i < configuration.getListSize()) {
            ((Set)this.getListItem(i)).addAll((Collection)configuration.getListItem(i));
            ++i;
        }
        return this;
    }

    public Set<ILayoutProcessorFactory<G>> processorsBefore(P phase) {
        return this.processors(((Enum)phase).ordinal());
    }

    public Set<ILayoutProcessorFactory<G>> processorsAfter(P phase) {
        return this.processors(((Enum)phase).ordinal() + 1);
    }

    private Set<ILayoutProcessorFactory<G>> processors(int index) {
        return Sets.newHashSet((Iterable)((Iterable)this.getListItem(index)));
    }

    @Override
    protected Set<ILayoutProcessorFactory<G>> provideDefault() {
        return Sets.newHashSet();
    }
}

