/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p5edges.orthogonal.direction;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import com.modelengineers.MoRe_elk.alg.layered.p5edges.orthogonal.direction.BaseRoutingDirectionStrategy;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.PortSide;

class SouthToNorthRoutingStrategy
extends BaseRoutingDirectionStrategy {
    SouthToNorthRoutingStrategy() {
    }

    @Override
    public double getPortPositionOnNode(LPort port) {
        return port.getNode().getPosition().x + port.getPosition().x + port.getAnchor().x;
    }

    @Override
    public PortSide getSourcePortSide() {
        return PortSide.NORTH;
    }

    @Override
    public PortSide getTargetPortSide() {
        return PortSide.SOUTH;
    }

    @Override
    public void calculateBendPoints(HyperEdgeSegment segment, double startPos, double edgeSpacing) {
        if (segment.isDummy()) {
            return;
        }
        double segmentY = startPos - (double)segment.getRoutingSlot() * edgeSpacing;
        for (LPort port : segment.getPorts()) {
            double sourceX = port.getAbsoluteAnchor().x;
            for (LEdge edge : port.getOutgoingEdges()) {
                if (edge.isSelfLoop()) continue;
                LPort target = edge.getTarget();
                double targetX = target.getAbsoluteAnchor().x;
                if (!(Math.abs(sourceX - targetX) > 0.001)) continue;
                double currentY = segmentY;
                HyperEdgeSegment currentSegment = segment;
                KVector bend = new KVector(sourceX, currentY);
                edge.getBendPoints().add(bend);
                this.addJunctionPointIfNecessary(edge, currentSegment, bend, false);
                HyperEdgeSegment splitPartner = segment.getSplitPartner();
                if (splitPartner != null) {
                    double splitX = splitPartner.getIncomingConnectionCoordinates().get(0);
                    bend = new KVector(splitX, currentY);
                    edge.getBendPoints().add(bend);
                    this.addJunctionPointIfNecessary(edge, currentSegment, bend, false);
                    currentY = startPos - (double)splitPartner.getRoutingSlot() * edgeSpacing;
                    currentSegment = splitPartner;
                    bend = new KVector(splitX, currentY);
                    edge.getBendPoints().add(bend);
                    this.addJunctionPointIfNecessary(edge, currentSegment, bend, false);
                }
                bend = new KVector(targetX, currentY);
                edge.getBendPoints().add(bend);
                this.addJunctionPointIfNecessary(edge, currentSegment, bend, false);
            }
        }
    }
}

