/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes;

import com.google.ortools.sat.CpSolverStatus;
import com.google.ortools.sat.IntVar;
import com.google.ortools.sat.LinearArgument;
import com.google.ortools.sat.LinearExpr;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.ortools.CpSolverWrapper;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.EdgePair;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.IProblem;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.MesNodePlacer;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.PEdge;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ProblemWrapper {
    private static final boolean PRINT_SOLVER_VARIABLES_FOR_DEBUGGING = false;
    public static final int SIMULINK_GRID_SIZE = 5;
    public static final int NODE_NODE_DISTANCE_FOR_MAX_HEIGHT = 10;
    public static final int NUM_SOLVER_SEARCH_WORKERS = 4;
    public static final int NUM_NODES_BELOW_WHICH_TO_USE_ONE_SOLVER_SEARCH_WORKER = 20;
    public static final int SOLVER_SEED = 42;
    private IProblem problem;
    private LGraph graph;
    private List<LNode> nodesFromAllLayers;
    private Map<LNode, IntVar> nodeTopPositions = new HashMap<LNode, IntVar>();
    private Map<LPort, IntVar> portPositions = new HashMap<LPort, IntVar>();
    private long minNodePos;
    private long maxNodePos;
    private List<EdgePair> edgePairsToBeSymmetricalInYDirection = new ArrayList<EdgePair>();
    private CpSolverWrapper solverWrapper = new CpSolverWrapper();

    public ProblemWrapper(IProblem problem, LGraph graph) {
        this.problem = problem;
        this.graph = graph;
    }

    public void placeNodes() throws InterruptedException {
        MesUtilMethods.measureRuntime(() -> this.placeNodesCore(), String.valueOf(this.getPrintPrefix()) + " on system \"" + this.graph.getFullSimulinkPath() + "\"", this.graph.loggingEnabled());
    }

    private void placeNodesCore() throws InterruptedException {
        this.setUp();
        this.solve();
        this.transferPositions();
    }

    private void setUp() {
        this.setUpProblemIndependent();
        this.setUpProblemDependent();
    }

    private void setUpProblemIndependent() {
        this.createNodeTopPositionVars();
        this.wideNodeDummiesMustHaveSameYPosition();
        this.ensureEastWestPortsOnSimulinkGrid();
        this.determineEdgePairsToBeSymmetricalInYDirection();
    }

    private void createNodeTopPositionVars() {
        this.nodesFromAllLayers = this.graph.getNodesFromAllLayers();
        long maxHeightOfGraph = (long)this.nodesFromAllLayers.stream().mapToDouble(n -> n.getSize().y + 10.0).sum();
        this.minNodePos = 0L;
        this.maxNodePos = maxHeightOfGraph;
        this.nodesFromAllLayers.forEach(n -> this.createNodeTopPositionVar((LNode)n));
    }

    private void createNodeTopPositionVar(LNode node) {
        IntVar nodeTopPosVar = this.solverWrapper.newIntVar(this.minNodePos, this.maxNodePos, "topPos(" + node + ")");
        this.nodeTopPositions.put(node, nodeTopPosVar);
    }

    private void wideNodeDummiesMustHaveSameYPosition() {
        this.nodesFromAllLayers.stream().filter(n -> n.isFirstWideNodeDummy()).forEach(d -> this.wideNodeDummiesMustHaveSameYPosition((LNode)d));
    }

    private void wideNodeDummiesMustHaveSameYPosition(LNode firstWideNodeDummy) {
        IntVar topPosOfFirstDummy = this.nodeTopPositions.get(firstWideNodeDummy);
        List<LNode> dummies = firstWideNodeDummy.getWideNodeDummies();
        List<LNode> otherDummies = dummies.subList(1, dummies.size());
        otherDummies.forEach(d -> this.solverWrapper.addEquality(this.nodeTopPositions.get(d), topPosOfFirstDummy));
    }

    private void ensureEastWestPortsOnSimulinkGrid() {
        Stream<LNode> nodesToTreat = this.nodesFromAllLayers.stream().filter(n -> ProblemWrapper.isNodeForWhichToEnsureEastWestPortsOnGrid(n));
        nodesToTreat.forEach(n -> this.ensureEastWestPortsOnSimulinkGrid((LNode)n));
    }

    private static boolean isNodeForWhichToEnsureEastWestPortsOnGrid(LNode node) {
        return (!node.isWideNode() || node.isFirstWideNodeDummy()) && node.hasTrueEastWestPorts();
    }

    private void ensureEastWestPortsOnSimulinkGrid(LNode nodeWithEastWestPorts) {
        IntVar n = this.solverWrapper.newIntVar(this.minNodePos / 5L, this.maxNodePos / 5L, "N(" + nodeWithEastWestPorts + ")");
        LinearExpr left = LinearExpr.term(n, 5L);
        IntVar nodeTopY = this.nodeTopPositions.get(nodeWithEastWestPorts);
        long highestEastWestPortRelY = (long)nodeWithEastWestPorts.getHighestTrueEastWestPort().getPosition().y;
        LinearExpr right = LinearExpr.sum(new LinearArgument[]{nodeTopY, LinearExpr.constant(highestEastWestPortRelY)});
        this.solverWrapper.addEquality(left, right);
    }

    public List<EdgePair> getEdgePairsToBeSymmetricalInYDirection() {
        return this.edgePairsToBeSymmetricalInYDirection;
    }

    private void determineEdgePairsToBeSymmetricalInYDirection() {
        this.getNodesFromAllLayers().forEach(n -> this.addEdgePairToBeSymmetricalInYDirection((LNode)n));
    }

    private void addEdgePairToBeSymmetricalInYDirection(LNode node) {
        if (node.isWideNode() && !node.isFirstWideNodeDummy()) {
            return;
        }
        List<LPort> targets = node.getPortsSortedTopToBottom(PortSide.WEST);
        if (targets.size() <= 2 || targets.size() % 2 != 0 || targets.stream().anyMatch(p -> p.getIncomingEdges().isEmpty())) {
            return;
        }
        List sources = targets.stream().map(LPort::getSourceSkippingLongEdgeDummies).collect(Collectors.toList());
        if (sources.stream().anyMatch(p -> p.getOutgoingEdges().size() > 1)) {
            return;
        }
        List<LNode> sourceNodes = sources.stream().map(p -> p.getNode()).collect(Collectors.toList());
        if (sourceNodes.stream().anyMatch(s -> s.getTargetNodes().size() != 1)) {
            return;
        }
        if (!this.allNeighborsOrIdenticalInCommonLayer(sourceNodes)) {
            return;
        }
        int ixUpperMiddleEdge = targets.size() / 2 - 1;
        int ixLowerMiddleEdge = ixUpperMiddleEdge + 1;
        PEdge upperMiddleEdge = new PEdge((LPort)sources.get(ixUpperMiddleEdge), targets.get(ixUpperMiddleEdge));
        PEdge lowerMiddleEdge = new PEdge((LPort)sources.get(ixLowerMiddleEdge), targets.get(ixLowerMiddleEdge));
        this.edgePairsToBeSymmetricalInYDirection.add(new EdgePair(upperMiddleEdge, lowerMiddleEdge));
    }

    private boolean allNeighborsOrIdenticalInCommonLayer(List<LNode> nodes) {
        return this.getGraph().getLayers().stream().anyMatch(l -> ProblemWrapper.allNeighborsOrIdenticalInLayer(nodes, l));
    }

    private static boolean allNeighborsOrIdenticalInLayer(List<LNode> nodes, Layer layer) {
        return IntStream.range(0, nodes.size() - 1).allMatch(ix -> ProblemWrapper.areNeighborsOrIdenticalInLayer((LNode)nodes.get(ix), (LNode)nodes.get(ix + 1), layer));
    }

    private static boolean areNeighborsOrIdenticalInLayer(LNode upperNode, LNode lowerNode, Layer layer) {
        LNode upperDummy = upperNode.getWideNodeDummyOrNodeItselfInLayer(layer);
        LNode lowerDummy = lowerNode.getWideNodeDummyOrNodeItselfInLayer(layer);
        return upperDummy != null && lowerDummy != null && (upperDummy == lowerDummy || layer.getNodes().indexOf(upperDummy) + 1 == layer.getNodes().indexOf(lowerDummy));
    }

    private void setUpProblemDependent() {
        this.problem.setUp(this.solverWrapper, this);
    }

    private void solve() throws InterruptedException {
        this.setUpSolver();
        MesUtilMethods.measureRuntime(() -> this.solverWrapper.minimize(), String.valueOf(this.getPrintPrefix()) + " solver", this.graph.loggingEnabled());
        assert (this.solverWrapper.getResponseStatus() == CpSolverStatus.OPTIMAL);
        this.printSolverVariables();
    }

    private void setUpSolver() {
        if (this.useOnlyOneWorker()) {
            this.solverWrapper.getParameters().setNumSearchWorkers(1);
        } else {
            this.solverWrapper.getParameters().setNumSearchWorkers(4);
            this.solverWrapper.getParameters().clearSubsolvers();
            this.solverWrapper.getParameters().addSubsolvers("default_lp");
            this.solverWrapper.getParameters().addSubsolvers("core");
        }
        this.solverWrapper.getParameters().setCpModelProbingLevel(0);
    }

    private boolean useOnlyOneWorker() {
        return this.graph.getNumTrueNodes() < 20L;
    }

    private void printSolverVariables() {
    }

    private String getPrintPrefix() {
        return String.valueOf(MesNodePlacer.PRINT_PREFIX) + " - " + this.problem.getClass().getSimpleName();
    }

    private void transferPositions() {
        this.nodesFromAllLayers.forEach(n -> this.transferPosition((LNode)n));
    }

    private void transferPosition(LNode node) {
        node.getPosition().y = this.solverWrapper.getValue(this.nodeTopPositions.get(node));
    }

    public IntVar getLongEdgeSourcePos(LEdge edge) {
        return this.getPortPos(edge.getSourceSkippingLongEdges());
    }

    public IntVar getSourcePos(LEdge edge) {
        return this.getPortPos(edge.getSource());
    }

    public IntVar getTargetPos(LEdge edge) {
        return this.getPortPos(edge.getTarget());
    }

    public LinearExpr getPosDiff(LPort p1, LPort p2) {
        return CpSolverWrapper.minusFast(this.getPortPos(p1), this.getPortPos(p2));
    }

    private IntVar getPortPos(LPort port) {
        return this.portPositions.computeIfAbsent(port, p -> this.makePortPosVar((LPort)p));
    }

    private IntVar makePortPosVar(LPort port) {
        IntVar nodeTopPosVar = this.nodeTopPositions.get(port.getNode());
        if (port.getPosition().y == 0.0) {
            return nodeTopPosVar;
        }
        IntVar portPosVar = this.solverWrapper.newIntVar(this.minNodePos, this.maxNodePos, ProblemWrapper.getPortPosVarName(port));
        LinearExpr portRelY = CpSolverWrapper.minusFast(portPosVar, nodeTopPosVar);
        this.solverWrapper.addEquality(portRelY, LinearExpr.constant((long)port.getPosition().y));
        return portPosVar;
    }

    private static String getPortPosVarName(LPort port) {
        return "pos(" + port.getNode() + ".p" + port.getIndex() + "_" + (Object)((Object)port.getSide()) + ")";
    }

    public LGraph getGraph() {
        return this.graph;
    }

    public List<LNode> getNodesFromAllLayers() {
        return this.nodesFromAllLayers;
    }

    public LinearArgument getTopTopDistanceToLowerNeighbor(LNode upperNode) {
        return CpSolverWrapper.minusFast(this.getNodeTopPos(upperNode.getLowerNeighbor()), this.getNodeTopPos(upperNode));
    }

    public IntVar getNodeTopPos(LNode node) {
        return this.nodeTopPositions.get(node);
    }

    public long getMaxNodePos() {
        return this.maxNodePos;
    }

    public long getMinNodePos() {
        return this.minNodePos;
    }

    public List<LEdge> getHorizontalEdgesToTreat() {
        return this.getEdges(e -> ProblemWrapper.isHorizontalEdgeToTreat(e));
    }

    public List<LEdge> getEdges(Function<LEdge, Boolean> filterFunc) {
        return this.nodesFromAllLayers.stream().flatMap(n -> n.getOutgoingEdgesAsList().stream()).filter(e -> (Boolean)filterFunc.apply((LEdge)e)).collect(Collectors.toList());
    }

    private static boolean isHorizontalEdgeToTreat(LEdge edge) {
        return edge.isHorizontal() && !edge.isInnerWideNodeEdge() && !edge.isDoubleEdgeToLongEdgeDummy();
    }

    public List<LNode> getNodesToKeepDistanceToLowerNeighbor() {
        return this.nodesFromAllLayers.stream().filter(node -> ProblemWrapper.nodeShouldKeepDistanceToLowerNeighbor(node)).collect(Collectors.toList());
    }

    private static boolean nodeShouldKeepDistanceToLowerNeighbor(LNode node) {
        LNode lowerNeighbor = node.getLowerNeighbor();
        return lowerNeighbor != null && (!node.isWideNode() || node.isFirstWideNodeDummy() || !lowerNeighbor.isWideNode() || lowerNeighbor.isFirstWideNodeDummy());
    }
}

