/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes;

import com.google.ortools.sat.BoolVar;
import com.google.ortools.sat.IntVar;
import com.google.ortools.sat.LinearArgument;
import com.google.ortools.sat.LinearExpr;
import com.google.ortools.sat.Literal;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.UpDown;
import com.modelengineers.MoRe_elk.alg.layered.ortools.CpSolverWrapper;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.EdgePair;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.IProblem;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.PEdge;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.ProblemWrapper;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MinimizeBendsProblem
implements IProblem {
    public static final int THRESHOLD_FOR_SYMMETRY_TREATMENT = 800;
    private static final List<Integer> EDGE_Y_LENGTH_THRESHOLDS = Arrays.asList(0, 15, 30, 60, 110, 180, 250, 400, 550);
    private CpSolverWrapper solverWrapper;
    private ProblemWrapper problemWrapper;
    private Map<LEdge, UpDown<Literal>> bendMap = new HashMap<LEdge, UpDown<Literal>>();
    private List<List<LEdge>> normalAndLongEdges;
    private Map<LEdge, Boolean> isEdgeToEndNode = new HashMap<LEdge, Boolean>();
    private Map<LEdge, Boolean> isEdgeFromEndNode = new HashMap<LEdge, Boolean>();

    @Override
    public void setUp(CpSolverWrapper solvWrapper, ProblemWrapper probWrapper) {
        this.solverWrapper = solvWrapper;
        this.problemWrapper = probWrapper;
        this.setUp();
    }

    private void setUp() {
        this.treatEdges();
        this.nodesMustHaveCorrectYOrderAndDistance();
    }

    private void treatEdges() {
        this.treatHorizontalEdges();
        this.preferLongEdgeDummiesToBeMerged();
        this.collectNormalAndLongEdges();
        this.yLengthOfEdgesShouldBeShort();
        this.longEdgesShouldNotHaveMultipleBends();
        this.treatEdgePairsToBeSymmetricalInYDirection();
        this.avoidTripleBranches();
    }

    private void treatHorizontalEdges() {
        this.problemWrapper.getHorizontalEdgesToTreat().forEach(e -> this.treatHorizontalEdge((LEdge)e));
    }

    private void treatHorizontalEdge(LEdge edge) {
        this.edgeShouldBeStraight(edge);
        this.nonTopTargetOfSplitEdgeShouldNotBeAboveSource(edge);
        this.topPortTargetMustNotBeAboveLongEdgeSource(edge);
    }

    private void edgeShouldBeStraight(LEdge edge) {
        long coeffForBend = this.getCoeffForBend(edge);
        assert (coeffForBend >= 0L);
        UpDown<Literal> bend = coeffForBend == 0L ? this.getBend(edge) : this.edgeShouldBeStraight(edge, coeffForBend);
        this.bendMap.put(edge, bend);
    }

    private UpDown<Literal> getBend(LEdge edge) {
        IntVar sourcePortPos = this.problemWrapper.getSourcePos(edge);
        IntVar targetPortPos = this.problemWrapper.getTargetPos(edge);
        BoolVar bendUp = this.solverWrapper.isGreater(sourcePortPos, targetPortPos);
        BoolVar bendDown = this.solverWrapper.isGreater(targetPortPos, sourcePortPos);
        return new UpDown<Literal>(bendUp, bendDown);
    }

    private long getCoeffForBend(LEdge edge) {
        long baseCoeff = this.getBaseCoeffForBend(edge);
        return baseCoeff == 0L ? baseCoeff : baseCoeff + this.getCoeffDeltaForBend(edge);
    }

    private long getBaseCoeffForBend(LEdge edge) {
        long numTargetsOrSourceInNextLayer = edge.getSource().getNumberOfDistinctConnectedPortsInOtherLayer();
        if (numTargetsOrSourceInNextLayer == 1L) {
            return 4000000000000L;
        }
        return this.getBaseCoeffForSplitEdge(edge, numTargetsOrSourceInNextLayer);
    }

    private long getBaseCoeffForSplitEdge(LEdge edge, long numTargetsOrSourceInNextLayer) {
        if (edge.isSplitEdgeToHighestPort()) {
            return this.getBaseCoeffForSplitEdgeToHighestPort(edge);
        }
        if (edge.isSplitEdgeToLowestPort()) {
            return this.getBaseCoeffForSplitEdgeToLowestPort(edge, numTargetsOrSourceInNextLayer);
        }
        return 0L;
    }

    private long getBaseCoeffForSplitEdgeToHighestPort(LEdge edge) {
        return this.isEdgeToEndNode(edge) ? 3999999000000L : 3999999970000L;
    }

    private long getBaseCoeffForSplitEdgeToLowestPort(LEdge edge, long numTargetsOrSourceInNextLayer) {
        if (numTargetsOrSourceInNextLayer == 2L) {
            return this.isEdgeToEndNode(edge) ? 3999998500000L : 3999999500000L;
        }
        return 0L;
    }

    private boolean isEdgeToEndNode(LEdge edge) {
        return this.isEdgeToOrFromEndNode(edge, true);
    }

    private long getCoeffDeltaForBend(LEdge edge) {
        return this.getCoeffDeltaForEdgeInNonSplitEdgeFromHighestOutport(edge) + this.getCoeffDeltaForEdgeFromEndNode(edge) + MinimizeBendsProblem.getCoeffDeltaForLengthOfEdge(edge) + MinimizeBendsProblem.getCoeffDeltaForDistanceFromSourcePort(edge) + this.getCoeffDeltaForInLayerIndex(edge);
    }

    private long getCoeffDeltaForEdgeInNonSplitEdgeFromHighestOutport(LEdge edge) {
        return MinimizeBendsProblem.isEdgeInNonSplitEdgeFromHighestOutport(edge) ? 1000L : 0L;
    }

    private static boolean isEdgeInNonSplitEdgeFromHighestOutport(LEdge edge) {
        return edge.getSource().getDistinctConnectedPortsInOtherLayer().size() == 1 && edge.getSource().isOnSide(PortSide.EAST) && edge.getSourceNode().getPortsSortedTopToBottom(PortSide.EAST).indexOf(edge.getSource()) == 0;
    }

    private long getCoeffDeltaForEdgeFromEndNode(LEdge edge) {
        return this.isEdgeFromEndNode(edge) ? -70000L : 0L;
    }

    private boolean isEdgeFromEndNode(LEdge edge) {
        return this.isEdgeToOrFromEndNode(edge, false);
    }

    private boolean isEdgeToOrFromEndNode(LEdge edge, boolean forward) {
        Map<LEdge, Boolean> map;
        Map<LEdge, Boolean> map2 = map = forward ? this.isEdgeToEndNode : this.isEdgeFromEndNode;
        if (!map.containsKey(edge)) {
            map.put(edge, this.computeIsEdgeToOrFromEndNode(edge, forward));
        }
        return map.get(edge);
    }

    private boolean computeIsEdgeToOrFromEndNode(LEdge edge, boolean forward) {
        LNode nextNode = edge.getNode(forward);
        List<LNode> previousNodesOfNextNode = nextNode.getConnectedNodes(!forward);
        return previousNodesOfNextNode.size() == 1 && !nextNode.isSeparate() && nextNode.getTruePorts().stream().allMatch(p -> p.hasEdges()) && nextNode.getTrueEdges(forward).stream().allMatch(e -> this.isEdgeToOrFromEndNode((LEdge)e, forward));
    }

    private static long getCoeffDeltaForLengthOfEdge(LEdge edge) {
        return (long)MinimizeBendsProblem.numLayersOfLongEdge(edge) * 20L;
    }

    private static int numLayersOfLongEdge(LEdge edge) {
        int layerIxTarget = MinimizeBendsProblem.getLayerIxOfLongTargetOrSplitEdge(edge);
        int layerIxSource = MinimizeBendsProblem.getLayerIxOfLongSource(edge);
        return layerIxTarget - layerIxSource;
    }

    private static int getLayerIxOfLongTargetOrSplitEdge(LEdge edge) {
        return MinimizeBendsProblem.getLongTargetOrSplitOrSourceNode(edge.getTargetNode(), true).getLayer().getIndex();
    }

    private static long getCoeffDeltaForDistanceFromSourcePort(LEdge edge) {
        return (long)MinimizeBendsProblem.getLayerDistanceFromSourcePort(edge) * 2L;
    }

    private static int getLayerDistanceFromSourcePort(LEdge edge) {
        return edge.getSourceNode().getLayer().getIndex() - MinimizeBendsProblem.getLayerIxOfLongSource(edge);
    }

    private static int getLayerIxOfLongSource(LEdge edge) {
        return MinimizeBendsProblem.getLongTargetOrSplitOrSourceNode(edge.getSourceNode(), false).getLastNonLabelWideNodeDummy().getLayer().getIndex();
    }

    private static LNode getLongTargetOrSplitOrSourceNode(LNode currentNode, boolean forward) {
        if (!currentNode.isLongEdge()) {
            return currentNode;
        }
        List<LNode> nextNodes = currentNode.getConnectedNodes(forward);
        if (nextNodes.size() > 1) {
            return currentNode;
        }
        LNode nextNode = nextNodes.get(0);
        if (nextNode.getLayer() == currentNode.getLayer()) {
            return currentNode;
        }
        return MinimizeBendsProblem.getLongTargetOrSplitOrSourceNode(nextNode, forward);
    }

    private long getCoeffDeltaForInLayerIndex(LEdge edge) {
        long maxSourceTargetIndex = Math.max(edge.getSourceNode().getIndex(), edge.getTargetNode().getIndex());
        return maxSourceTargetIndex * -1L;
    }

    private UpDown<Literal> edgeShouldBeStraight(LEdge edge, long coeffForBend) {
        IntVar sourcePos = this.problemWrapper.getSourcePos(edge);
        IntVar targetPos = this.problemWrapper.getTargetPos(edge);
        BoolVar bendUp = this.solverWrapper.isGreater(sourcePos, targetPos);
        BoolVar bendDown = this.solverWrapper.isGreater(targetPos, sourcePos);
        this.solverWrapper.addObjectiveFactor(bendUp, coeffForBend);
        this.solverWrapper.addObjectiveFactor(bendDown, coeffForBend);
        return new UpDown<Literal>(bendUp, bendDown);
    }

    private void nonTopTargetOfSplitEdgeShouldNotBeAboveSource(LEdge edge) {
        if (edge.isSplitEdgeToNonHighestPort()) {
            this.solverWrapper.shouldBeLessOrEqualFast((LinearArgument)this.problemWrapper.getSourcePos(edge), this.problemWrapper.getTargetPos(edge), 80000L);
        }
    }

    private void topPortTargetMustNotBeAboveLongEdgeSource(LEdge edge) {
        if (edge.getTargetNode().isNorthSouthDummyForNorthPort()) {
            this.solverWrapper.addGreaterOrEqual((LinearArgument)this.problemWrapper.getTargetPos(edge), this.problemWrapper.getLongEdgeSourcePos(edge));
        }
    }

    private void preferLongEdgeDummiesToBeMerged() {
        this.problemWrapper.getGraph().getNodesFromAllLayers().stream().filter(n -> n.canHaveZeroDistanceToLowerNeighbor()).forEach(n -> this.preferLongEdgeDummiesToBeMerged((LNode)n, n.getLowerNeighbor()));
    }

    private void preferLongEdgeDummiesToBeMerged(LNode upper, LNode lower) {
        IntVar upperPos = this.problemWrapper.getNodeTopPos(upper);
        IntVar lowerPos = this.problemWrapper.getNodeTopPos(lower);
        BoolVar samePos = this.solverWrapper.isEqual(upperPos, lowerPos);
        this.solverWrapper.addObjectiveFactor(samePos, -1000L);
    }

    private void collectNormalAndLongEdges() {
        this.normalAndLongEdges = this.problemWrapper.getHorizontalEdgesToTreat().stream().filter(e -> MinimizeBendsProblem.isStartOfNormalOrLongEdge(e)).map(e -> MinimizeBendsProblem.getEdgesOfLongEdge(e)).collect(Collectors.toList());
    }

    private static boolean isStartOfNormalOrLongEdge(LEdge edge) {
        LNode sourceNode = edge.getSourceNode();
        return (!sourceNode.isLongEdge() || sourceNode.isLongEdge() && sourceNode.getTargetNodes().size() > 1) && !edge.isDoubleEdgeToLongEdgeDummy();
    }

    private static List<LEdge> getEdgesOfLongEdge(LEdge startEdge) {
        ArrayList<LEdge> edgesOfLongEdge = new ArrayList<LEdge>();
        edgesOfLongEdge.add(startEdge);
        LNode currentNode = startEdge.getTargetNode();
        while (currentNode.isLongEdge() && currentNode.getTargetNodes().size() == 1) {
            LEdge currentEdge = currentNode.getOutgoingEdgesAsList().stream().filter(e -> !e.isDoubleEdgeToLongEdgeDummy()).findFirst().get();
            if (!currentEdge.isHorizontal()) break;
            edgesOfLongEdge.add(currentEdge);
            currentNode = currentEdge.getTargetNode();
        }
        return edgesOfLongEdge;
    }

    private void yLengthOfEdgesShouldBeShort() {
        this.normalAndLongEdges.forEach(e -> this.yLengthOfNormalOrLongEdgeShouldBeShort((List<LEdge>)e));
    }

    private void yLengthOfNormalOrLongEdgeShouldBeShort(List<LEdge> partEdges) {
        LEdge firstEdge = partEdges.get(0);
        LEdge lastEdge = partEdges.get(partEdges.size() - 1);
        LinearExpr diffUp = this.problemWrapper.getPosDiff(firstEdge.getSource(), lastEdge.getTarget());
        LinearExpr diffDown = CpSolverWrapper.neg(diffUp);
        this.yLengthOfNormalOrLongEdgeShouldBeShort(diffUp, diffDown, firstEdge);
    }

    private void yLengthOfNormalOrLongEdgeShouldBeShort(LinearExpr diffUp, LinearExpr diffDown, LEdge firstEdge) {
        List<LPort> targetPortsInNextLayer = firstEdge.getSource().getDistinctConnectedPortsInOtherLayer();
        if (targetPortsInNextLayer.size() == 1) {
            Literal edgeGoesUp = this.edgeYDiffShouldBeShort(diffUp, 20000L);
            Literal edgeGoesDown = this.edgeYDiffShouldBeShort(diffDown, 20010L);
            this.solverWrapper.addImplication(edgeGoesUp, edgeGoesDown.not());
            this.solverWrapper.addImplication(edgeGoesDown, edgeGoesUp.not());
        } else if (firstEdge.isSplitEdgeToHighestPort()) {
            this.edgeYDiffShouldBeShort(diffUp, 20000L);
        } else if (firstEdge.isSplitEdgeToLowestPort()) {
            this.edgeYDiffShouldBeShort(diffDown, 20010L);
        }
    }

    private Literal edgeYDiffShouldBeShort(LinearExpr yDiff, long coeff) {
        List isLonger = EDGE_Y_LENGTH_THRESHOLDS.stream().map(t -> this.solverWrapper.shouldBeLessOrEqualFast((LinearArgument)yDiff, t.intValue(), coeff)).collect(Collectors.toList());
        int ixLonger = 1;
        while (ixLonger < isLonger.size()) {
            Literal prev = (Literal)isLonger.get(ixLonger - 1);
            Literal curr = (Literal)isLonger.get(ixLonger);
            this.solverWrapper.addImplication(prev.not(), curr.not());
            this.solverWrapper.addImplication(curr, prev);
            ++ixLonger;
        }
        return (Literal)isLonger.get(0);
    }

    private void longEdgesShouldNotHaveMultipleBends() {
        this.normalAndLongEdges.stream().forEach(e -> this.longEdgeShouldNotHaveMultipleBends((List<LEdge>)e));
    }

    private void longEdgeShouldNotHaveMultipleBends(List<LEdge> partEdges) {
        if (partEdges.size() > 1) {
            LinearArgument numBends = this.getNumBends(partEdges);
            this.solverWrapper.shouldBeLessOrEqualFast(numBends, 1L, 200000L);
        }
    }

    private LinearArgument getNumBends(List<LEdge> edges) {
        return LinearExpr.sum(this.getBendsOfEdges(edges));
    }

    private LinearArgument[] getBendsOfEdges(List<LEdge> edges) {
        ArrayList bends = new ArrayList();
        edges.forEach(e -> {
            bends.add((LinearArgument)this.bendMap.get(e).getUp());
            bends.add((LinearArgument)this.bendMap.get(e).getDown());
        });
        return (LinearArgument[])bends.stream().toArray(LinearArgument[]::new);
    }

    private void nodesMustHaveCorrectYOrderAndDistance() {
        this.problemWrapper.getNodesToKeepDistanceToLowerNeighbor().forEach(n -> this.nodeMustKeepYDistanceToLowerNeighbor((LNode)n));
    }

    private void nodeMustKeepYDistanceToLowerNeighbor(LNode node) {
        LinearArgument topTopDistance = this.problemWrapper.getTopTopDistanceToLowerNeighbor(node);
        this.ensureMinYDistanceToLowerNeighbor(topTopDistance, node);
        this.nodeShouldHavePreferredYDistanceToLowerNeighbor(topTopDistance, node);
    }

    private void ensureMinYDistanceToLowerNeighbor(LinearArgument topTopDistance, LNode node) {
        double minTopTopDistance = node.getMinTopTopDistanceToLowerNeighbor();
        this.solverWrapper.addGreaterOrEqual(topTopDistance, (long)minTopTopDistance);
    }

    private void nodeShouldHavePreferredYDistanceToLowerNeighbor(LinearArgument topTopDistance, LNode node) {
        long preferredTopTopDistance = (long)node.getPreferredTopTopDistanceToLowerNeighbor();
        this.solverWrapper.shouldBeGreaterOrEqualFast(topTopDistance, preferredTopTopDistance, 200000000L);
        this.someNodesCanAlsoHaveNoTopTopDistanceToLowerNeighbor(topTopDistance, node);
    }

    private void someNodesCanAlsoHaveNoTopTopDistanceToLowerNeighbor(LinearArgument topTopDistance, LNode node) {
        if (node.canHaveZeroDistanceToLowerNeighbor()) {
            BoolVar noTopTopDistance = this.solverWrapper.isEqual(topTopDistance, LinearExpr.constant(0L));
            this.solverWrapper.addObjectiveFactor(noTopTopDistance, -200000000L);
        }
    }

    private void treatEdgePairsToBeSymmetricalInYDirection() {
        List<EdgePair> edgePairs = this.problemWrapper.getEdgePairsToBeSymmetricalInYDirection();
        if (!this.symmetricalEdgeTreatmentCausesRuntimeProblems(edgePairs)) {
            edgePairs.forEach(p -> this.edgesShouldBeSymmetricalInYDirection(p.getFirst(), p.getSecond()));
        }
    }

    private boolean symmetricalEdgeTreatmentCausesRuntimeProblems(List<EdgePair> edgePairsToBeSymmetrical) {
        double numNodes = this.problemWrapper.getNodesFromAllLayers().size();
        return (double)edgePairsToBeSymmetrical.size() * numNodes > 800.0;
    }

    private void edgesShouldBeSymmetricalInYDirection(PEdge upperEdge, PEdge lowerEdge) {
        LinearExpr diffDownUpperEdge = this.problemWrapper.getPosDiff(upperEdge.getTarget(), upperEdge.getSource());
        LinearExpr diffUpLowerEdge = this.problemWrapper.getPosDiff(lowerEdge.getSource(), lowerEdge.getTarget());
        LinearExpr diff = CpSolverWrapper.minusFast(diffDownUpperEdge, diffUpLowerEdge);
        int tolerance = 5;
        BoolVar diffWithinTolerance = this.solverWrapper.newBoolVar("diffWithinTolerance");
        this.solverWrapper.addLessOrEqual(diff, tolerance).onlyEnforceIf(diffWithinTolerance);
        this.solverWrapper.addGreaterOrEqual((LinearArgument)diff, -tolerance).onlyEnforceIf(diffWithinTolerance);
        this.solverWrapper.addObjectiveFactor(diffWithinTolerance.not(), 6000000000000L);
    }

    private void avoidTripleBranches() {
        Map<LPort, List<LEdge>> edgesOfSourcePorts = this.problemWrapper.getHorizontalEdgesToTreat().stream().collect(Collectors.groupingBy(e -> e.getSource()));
        edgesOfSourcePorts.keySet().forEach(s -> this.avoidTripleBranches((LPort)s, (List)edgesOfSourcePorts.get(s)));
    }

    private void avoidTripleBranches(LPort sourcePort, List<LEdge> edges) {
        if (edges.size() > 2 && edges.stream().map(e -> e.getTarget()).distinct().count() > 2L) {
            LEdge lowestEdge = edges.stream().filter(e -> e.isSplitEdgeToLowestPort()).findFirst().get();
            LEdge highestEdge = edges.stream().filter(e -> e.isSplitEdgeToHighestPort()).findFirst().get();
            Stream<LEdge> middleEdges = edges.stream().filter(e -> e != lowestEdge && e != highestEdge);
            middleEdges.forEach(e -> this.avoidTripleBranch((LEdge)e, lowestEdge, highestEdge));
        }
    }

    private void avoidTripleBranch(LEdge middleEdge, LEdge lowestEdge, LEdge highestEdge) {
        ArrayList<Literal> waysToAvoidTripleBranch = new ArrayList<Literal>();
        waysToAvoidTripleBranch.add(this.bendMap.get(lowestEdge).getDown().not());
        waysToAvoidTripleBranch.add(this.bendMap.get(highestEdge).getUp().not());
        waysToAvoidTripleBranch.add(this.bendMap.get(middleEdge).getUp());
        waysToAvoidTripleBranch.add(this.bendMap.get(middleEdge).getDown());
        this.solverWrapper.addOr(waysToAvoidTripleBranch);
    }

    private static class ObjectiveCoeffs {
        public static final long BEND_IN_NON_SPLIT_EDGE = 4000000000000L;
        public static final long BEND_IN_SPLIT_EDGE_TO_HIGHEST_PORT = 3999999970000L;
        public static final long BEND_IN_SPLIT_EDGE_TO_HIGHEST_PORT_TO_END_NODE = 3999999000000L;
        public static final long BEND_IN_SPLIT_EDGE_TO_LOWEST_OF_TWO_PORTS = 3999999500000L;
        public static final long BEND_IN_SPLIT_EDGE_TO_LOWEST_OF_TWO_PORTS_TO_END_NODE = 3999998500000L;
        public static final long BEND_IN_SPLIT_EDGE_TO_MIDDLE_PORT = 0L;
        public static final long BEND_IN_SPLIT_EDGE_TO_LOWEST_OF_MORE_THAN_TWO_PORTS = 0L;
        public static final long DELTA_FOR_BEND_IN_NON_SPLIT_EDGE_FROM_HIGHEST_OUTPORT = 1000L;
        public static final long DELTA_FOR_BEND_FROM_END_NODE = -70000L;
        public static final long DELTA_FOR_BEND_DEPENDING_ON_DISTANCE_FROM_SOURCE = 2L;
        public static final long DELTA_FOR_BEND_DEPENDING_ON_LENGTH_OF_LONG_EDGE = 20L;
        public static final long DELTA_FOR_BEND_DEPENDENT_ON_IN_LAYER_INDEX = -1L;
        public static final long MORE_THAN_ONE_BEND_IN_LONG_EDGE = 200000L;
        public static final long TARGETS_OF_SPLIT_EDGE_ABOVE_SOURCE = 80000L;
        public static final long NODE_NODE_DISTANCE_IS_BELOW_PREFERRED_DISTANCE = 200000000L;
        public static final long EDGE_LENGTH_UP = 20000L;
        public static final long EDGE_LENGTH_DOWN = 20010L;
        public static final long LONG_EDGE_DUMMIES_ARE_MERGED = -1000L;
        public static final long EDGE_PAIR_SYMMETRICAL_IN_Y_DIRECTION = 6000000000000L;

        private ObjectiveCoeffs() {
        }
    }
}

