/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes;

import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk.BKNodePlacer;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.FinalPositioningProblem;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.IProblem;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.MinimizeBendsProblem;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.ProblemWrapper;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.graph.ElkNode;

public final class MesNodePlacer
implements ILayoutPhase<LayeredPhases, LGraph> {
    public static final String PRINT_PREFIX = MesNodePlacer.class.getSimpleName();
    private static final int NUM_NODES_FROM_WHICH_TO_USE_OLD_P4 = 1100;
    private LGraph graph;
    private IElkProgressMonitor progressMonitor;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph lGraph) {
        return LayoutProcessorConfiguration.create();
    }

    @Override
    public void process(LGraph lGraph, IElkProgressMonitor monitor) throws InterruptedException {
        monitor.begin("MES MoRe node placement", 1.0f);
        this.graph = lGraph;
        this.progressMonitor = monitor;
        this.process();
        monitor.done();
    }

    private void process() throws InterruptedException {
        if (this.useOldVariant()) {
            this.oldP4();
        } else {
            this.newP4();
        }
    }

    private boolean useOldVariant() {
        double numNodes = this.graph.getLayers().stream().mapToDouble(l -> l.getNodes().size()).sum();
        return numNodes >= 1100.0;
    }

    private void oldP4() {
        this.markOldP4UsageForTests();
        if (this.graph.loggingEnabled()) {
            System.out.println(String.valueOf(PRINT_PREFIX) + " - Using old P4 because subsystem has too many elements");
        }
        new BKNodePlacer().process(this.graph, this.progressMonitor);
    }

    private void markOldP4UsageForTests() {
        ElkNode origin = (ElkNode)this.graph.getProperty(InternalProperties.ORIGIN);
        origin.setProperty(InternalProperties.OLD_P4_USED, true);
    }

    private void newP4() throws InterruptedException {
        MesUtilMethods.measureRuntime(() -> this.placeNodes(), PRINT_PREFIX, this.graph.loggingEnabled());
    }

    private void placeNodes() throws InterruptedException {
        this.placeNodes(new MinimizeBendsProblem());
        this.placeNodes(new FinalPositioningProblem());
    }

    private void placeNodes(IProblem problem) throws InterruptedException {
        new ProblemWrapper(problem, this.graph).placeNodes();
    }
}

