/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes;

import com.google.ortools.sat.BoolVar;
import com.google.ortools.sat.IntVar;
import com.google.ortools.sat.LinearArgument;
import com.google.ortools.sat.LinearExpr;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.UpDown;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.ortools.CpSolverWrapper;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.IProblem;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.PEdge;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.ProblemWrapper;
import java.util.List;
import java.util.stream.Stream;

public class FinalPositioningProblem
implements IProblem {
    private CpSolverWrapper solverWrapper;
    private ProblemWrapper problemWrapper;

    @Override
    public void setUp(CpSolverWrapper solvWrapper, ProblemWrapper probWrapper) {
        this.solverWrapper = solvWrapper;
        this.problemWrapper = probWrapper;
        this.setUp();
    }

    private void setUp() {
        this.treatEdges();
        this.noVerticalGapsBetweenSeparateComponents();
        this.nodesMustHaveCorrectYOrderAndDistance();
    }

    private void treatEdges() {
        this.treatHorizontalEdges();
        this.treatInLayerEdges();
        this.treatEdgesToTopPorts();
        this.treatEdgePairsToBeSymmetricalInYDirection();
    }

    private void treatHorizontalEdges() {
        this.problemWrapper.getHorizontalEdgesToTreat().forEach(e -> this.treatHorizontalEdge((LEdge)e));
    }

    private void treatHorizontalEdge(LEdge edge) {
        if (FinalPositioningProblem.wasMadeStraightInPreviousProblem(edge)) {
            this.ensureEdgeIsStraight(edge);
        } else {
            this.treatHorizontalNonStraightEdge(edge);
        }
    }

    private static boolean wasMadeStraightInPreviousProblem(LEdge edge) {
        return edge.getSource().getAbsoluteAnchor().y == edge.getTarget().getAbsoluteAnchor().y;
    }

    private void ensureEdgeIsStraight(LEdge edge) {
        this.solverWrapper.addEquality(this.problemWrapper.getSourcePos(edge), this.problemWrapper.getTargetPos(edge));
    }

    private void treatHorizontalNonStraightEdge(LEdge edge) {
        this.yLengthOfEdgeShouldBeShort(edge);
        this.splitEdgeToMiddlePortShouldNotBeStraight(edge);
    }

    private void yLengthOfEdgeShouldBeShort(LEdge edge) {
        UpDown<IntVar> diff = this.getEdgeYDiffUpDown(edge);
        UpDown<Long> coeff = this.getYLengthCoeff(edge);
        this.solverWrapper.addObjectiveFactor(diff.getDown(), coeff.getDown());
        this.solverWrapper.addObjectiveFactor(diff.getUp(), coeff.getUp());
    }

    private UpDown<IntVar> getEdgeYDiffUpDown(LEdge edge) {
        IntVar diffUp = this.solverWrapper.minus(this.problemWrapper.getSourcePos(edge), this.problemWrapper.getTargetPos(edge));
        IntVar[] diffUpPosNeg = this.solverWrapper.splitIntoPositiveAndNegative(diffUp);
        return new UpDown<IntVar>(diffUpPosNeg[0], diffUpPosNeg[1]);
    }

    private UpDown<Long> getYLengthCoeff(LEdge edge) {
        long coeffUp = 11000L;
        long coeffDown = 10000L;
        if (edge.isSplitEdgeToNonHighestPort()) {
            coeffUp = 600L;
        }
        if (edge.isSplitEdgeToNonLowestPort()) {
            coeffDown = 500L;
        } else if (edge.isSplitEdgeToLowestPort()) {
            coeffDown = 9500L;
        }
        return new UpDown<Long>(coeffUp, coeffDown);
    }

    private void splitEdgeToMiddlePortShouldNotBeStraight(LEdge edge) {
        if (edge.isSplitEdgeToMiddlePort()) {
            BoolVar edgeIsStraight = this.solverWrapper.isEqual(this.problemWrapper.getSourcePos(edge), this.problemWrapper.getTargetPos(edge));
            this.solverWrapper.addObjectiveFactor(edgeIsStraight, 1000000000L);
        }
    }

    private void treatInLayerEdges() {
        this.getInLayerEdges().forEach(e -> this.treatInLayerEdge((LEdge)e));
    }

    private List<LEdge> getInLayerEdges() {
        return this.problemWrapper.getEdges(e -> e.isInLayerEdge());
    }

    private void treatInLayerEdge(LEdge edge) {
        this.solverWrapper.absDiffShouldBeSmall(this.problemWrapper.getSourcePos(edge), this.problemWrapper.getTargetPos(edge), 10000L);
    }

    private void treatEdgesToTopPorts() {
        Stream<LNode> northSouthPortDummies = this.problemWrapper.getNodesFromAllLayers().stream().filter(n -> n.getType().equals((Object)LNode.NodeType.NORTH_SOUTH_PORT));
        northSouthPortDummies.forEach(n -> this.treatNorthSouthPortDummy((LNode)n));
    }

    private void treatNorthSouthPortDummy(LNode dummy) {
        IntVar dummyTopPos = this.problemWrapper.getNodeTopPos(dummy);
        LNode blockWithTopPort = (LNode)dummy.getProperty(InternalProperties.ORIGIN);
        IntVar topPosOfBlockWithTopPort = this.problemWrapper.getNodeTopPos(blockWithTopPort);
        this.solverWrapper.absDiffShouldBeSmall(dummyTopPos, topPosOfBlockWithTopPort, 10000L);
    }

    private void noVerticalGapsBetweenSeparateComponents() {
        this.problemWrapper.getNodesFromAllLayers().forEach(n -> this.solverWrapper.addObjectiveFactor(this.problemWrapper.getNodeTopPos((LNode)n), 1L));
    }

    private void nodesMustHaveCorrectYOrderAndDistance() {
        this.problemWrapper.getNodesToKeepDistanceToLowerNeighbor().forEach(n -> this.nodeMustKeepYDistanceToLowerNeighbor((LNode)n));
    }

    private void nodeMustKeepYDistanceToLowerNeighbor(LNode node) {
        LinearArgument topTopDistance = this.problemWrapper.getTopTopDistanceToLowerNeighbor(node);
        long topTopDistanceToKeep = this.getTopTopDistanceToKeepToLowerNeighbor(node);
        this.solverWrapper.addGreaterOrEqual(topTopDistance, topTopDistanceToKeep);
    }

    private long getTopTopDistanceToKeepToLowerNeighbor(LNode node) {
        double currentTopTopDistance = node.getTopTopDistanceToLowerNeighbor();
        double preferredTopTopDistance = node.getPreferredTopTopDistanceToLowerNeighbor();
        double minTopTopDistance = node.getMinTopTopDistanceToLowerNeighbor();
        double topTopDistanceToKeep = currentTopTopDistance >= preferredTopTopDistance ? preferredTopTopDistance : minTopTopDistance;
        return (long)topTopDistanceToKeep;
    }

    private void treatEdgePairsToBeSymmetricalInYDirection() {
        this.problemWrapper.getEdgePairsToBeSymmetricalInYDirection().forEach(p -> this.edgesShouldBeSymmetricalInYDirection(p.getFirst(), p.getSecond()));
    }

    private void edgesShouldBeSymmetricalInYDirection(PEdge upperEdge, PEdge lowerEdge) {
        double diffDownUpperEdge = this.getCurrentPositionDiff(upperEdge.getTarget(), upperEdge.getSource());
        double diffUpLowerEdge = this.getCurrentPositionDiff(lowerEdge.getSource(), lowerEdge.getTarget());
        double absDiff = Math.abs(diffDownUpperEdge - diffUpLowerEdge);
        int tolerance = 5;
        if (diffDownUpperEdge != 0.0 && diffUpLowerEdge != 0.0 && absDiff <= (double)tolerance) {
            this.fixPositionDiff(upperEdge.getTarget(), upperEdge.getSource(), diffDownUpperEdge);
            this.fixPositionDiff(lowerEdge.getSource(), lowerEdge.getTarget(), diffUpLowerEdge);
        }
    }

    private double getCurrentPositionDiff(LPort p1, LPort p2) {
        return p1.getAbsoluteAnchor().y - p2.getAbsoluteAnchor().y;
    }

    private void fixPositionDiff(LPort p1, LPort p2, double d) {
        LinearExpr posDiff = this.problemWrapper.getPosDiff(p1, p2);
        this.solverWrapper.addEquality(posDiff, LinearExpr.constant((int)d));
    }

    private static class ObjectiveCoeffs {
        public static final long EDGE_LENGTH_UP = 11000L;
        public static final long EDGE_LENGTH_DOWN = 10000L;
        public static final long EDGE_LENGTH_DOWN_TO_LOWEST_SPLIT_PORT = 9500L;
        public static final long EDGE_LENGTH_UP_TO_NON_HIGHEST_SPLIT_PORT = 600L;
        public static final long EDGE_LENGTH_DOWN_TO_NON_LOWEST_SPLIT_PORT = 500L;
        public static final long EDGE_LENGTH_IN_LAYER = 10000L;
        public static final long EDGE_LENGTH_NORTH_SOUTH = 10000L;
        public static final long SPLIT_EDGE_TO_MIDDLE_PORT_IS_STRAIGHT = 1000000000L;
        public static final long NO_VERTICAL_GAPS_BETWEEN_SEPARATE_COMPONENTS = 1L;

        private ObjectiveCoeffs() {
        }
    }
}

