/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.CEdge;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.Pair;

public class OptimumOrderEnforcer {
    private CEdge edgeA;
    private CEdge edgeB;
    private BinaryOrderProblem orderProblem;

    public OptimumOrderEnforcer(CEdge edgeA, CEdge edgeB, BinaryOrderProblem orderProblem) {
        this.edgeA = edgeA;
        this.edgeB = edgeB;
        this.orderProblem = orderProblem;
    }

    public boolean enforced() {
        Pair<LPort, CEdge> indicatorA = this.getPortThatIndicatesOptimalOrder(this.edgeA);
        Pair<LPort, CEdge> indicatorB = this.getPortThatIndicatesOptimalOrder(this.edgeB);
        return this.obviousOrderEnforced(indicatorA, indicatorB);
    }

    private Pair<LPort, CEdge> getPortThatIndicatesOptimalOrder(CEdge edge) {
        return new Pair<LPort, CEdge>(edge.getIndicatorPort(), edge);
    }

    private boolean obviousOrderEnforced(Pair<LPort, CEdge> indicatorA, Pair<LPort, CEdge> indicatorB) {
        return this.validIndicatorsFound(indicatorA, indicatorB) && this.obviousOrderEnforcedUsingIndicators(indicatorA, indicatorB);
    }

    private boolean validIndicatorsFound(Pair<LPort, CEdge> indicatorA, Pair<LPort, CEdge> indicatorB) {
        if (this.isInvalid(indicatorA)) {
            return this.foundValidIndicatorUsingOtherIndicator(indicatorA, indicatorB);
        }
        if (this.isInvalid(indicatorB)) {
            return this.foundValidIndicatorUsingOtherIndicator(indicatorB, indicatorA);
        }
        return this.indicatorPortsAreAtSameSideOfSameNode(indicatorA, indicatorB);
    }

    public boolean foundValidIndicatorUsingOtherIndicator(Pair<LPort, CEdge> invalidIndicator, Pair<LPort, CEdge> otherIndicator) {
        return !this.isInvalid(otherIndicator) && this.madeIndicatorValidUsingValidIndicator(invalidIndicator, otherIndicator);
    }

    private boolean isInvalid(Pair<LPort, CEdge> indicator) {
        return !this.isValidIndicatorPort(indicator.getFirst());
    }

    private boolean madeIndicatorValidUsingValidIndicator(Pair<LPort, CEdge> invalidIndicator, Pair<LPort, CEdge> validIndicator) {
        LPort validIndicatorPort = validIndicator.getFirst();
        LNode indicatorNode = validIndicatorPort.getNode();
        boolean searchForward = this.nodeLiesInTargetDirection(indicatorNode, invalidIndicator.getSecond());
        return this.foundValidIndicatorInDirection(invalidIndicator, validIndicatorPort, searchForward);
    }

    private boolean nodeLiesInTargetDirection(LNode indicatorNode, CEdge edgeOfInvalidIndicator) {
        return indicatorNode.getLayer().getIndex() > edgeOfInvalidIndicator.getSourceNode().getLayer().getIndex();
    }

    private boolean foundValidIndicatorInDirection(Pair<LPort, CEdge> invalidIndicator, LPort validIndicatorPort, boolean forward) {
        CEdge edgeOfInvalidIndicator = invalidIndicator.getSecond();
        LPort possibleIndicatorPort = this.getPossibleIndicatorPortInDirection(edgeOfInvalidIndicator, forward);
        if (this.isValidCombinationOfIndicatorPorts(possibleIndicatorPort, edgeOfInvalidIndicator, validIndicatorPort)) {
            invalidIndicator.setFirst(possibleIndicatorPort);
            return true;
        }
        return false;
    }

    private LPort getPossibleIndicatorPortInDirection(CEdge edgeOfInvalidIndicator, boolean forward) {
        return this.comesFromNonSplitLongEdge(edgeOfInvalidIndicator, forward) ? edgeOfInvalidIndicator.getPortSkippingLongEdges(forward) : null;
    }

    private boolean comesFromNonSplitLongEdge(CEdge edge, boolean forward) {
        return edge.getNode(!forward).isLongEdge() && (!forward || edge.getPortSkippingLongEdges(!forward).getNumberOfConnectedPorts() == 1);
    }

    private boolean isValidCombinationOfIndicatorPorts(LPort possibleIndicatorPort, CEdge edgeOfInvalidIndicator, LPort validIndicatorPort) {
        return this.isValidIndicatorPort(possibleIndicatorPort) && this.indicatorPortsAreAtSameSideOfSameNode(possibleIndicatorPort, validIndicatorPort);
    }

    private boolean isValidIndicatorPort(LPort indicatorPort) {
        return indicatorPort != null;
    }

    private boolean indicatorPortsAreAtSameSideOfSameNode(Pair<LPort, CEdge> indicatorA, Pair<LPort, CEdge> indicatorB) {
        return indicatorA.getFirst().isOnSameNodeAs(indicatorB.getFirst()) && indicatorA.getFirst().isOnSameSideAs(indicatorB.getFirst());
    }

    private boolean indicatorPortsAreAtSameSideOfSameNode(LPort indicatorPortA, LPort indicatorPortB) {
        return indicatorPortA.isOnSameNodeAs(indicatorPortB) && indicatorPortA.isOnSameSideAs(indicatorPortB);
    }

    private boolean obviousOrderEnforcedUsingIndicators(Pair<LPort, CEdge> indicatorA, Pair<LPort, CEdge> indicatorB) {
        return this.sameIndicatorPort(indicatorA, indicatorB) ? this.containsTwigThatsEnforcedBelowSplitEdge(indicatorA, indicatorB) : this.enforcedSameOrderAsIndicatorPorts(indicatorA, indicatorB);
    }

    private boolean sameIndicatorPort(Pair<LPort, CEdge> indicatorA, Pair<LPort, CEdge> indicatorB) {
        return indicatorA.getFirst() == indicatorB.getFirst();
    }

    private boolean containsTwigThatsEnforcedBelowSplitEdge(Pair<LPort, CEdge> indicatorA, Pair<LPort, CEdge> indicatorB) {
        return this.isTwigThatsEnforcedBelowSplitEdge(indicatorA, indicatorB) || this.isTwigThatsEnforcedBelowSplitEdge(indicatorB, indicatorA);
    }

    private boolean isTwigThatsEnforcedBelowSplitEdge(Pair<LPort, CEdge> indicatorOfTwig, Pair<LPort, CEdge> indicatorOfUpperEdge) {
        return this.isIndicatorOfTargetTwig(indicatorOfTwig) && this.enforcedTwigBelowSplitEdge(indicatorOfTwig, indicatorOfUpperEdge);
    }

    private boolean isIndicatorOfTargetTwig(Pair<LPort, CEdge> indicator) {
        CEdge edgeOfIndicator = indicator.getSecond();
        return edgeOfIndicator.isTargetTwig();
    }

    private boolean enforcedTwigBelowSplitEdge(Pair<LPort, CEdge> indicatorOfTwig, Pair<LPort, CEdge> indicatorOfUpperEdge) {
        if (this.upperEdgeIsLongEnoughForTwig(indicatorOfTwig, indicatorOfUpperEdge)) {
            this.setTwigBelowEdge(indicatorOfTwig, indicatorOfUpperEdge);
            return true;
        }
        return false;
    }

    private boolean upperEdgeIsLongEnoughForTwig(Pair<LPort, CEdge> indicatorOfTwig, Pair<LPort, CEdge> indicatorOfUpperEdge) {
        return this.upperLongEdgeStartPortIsIndicatorPort(indicatorOfUpperEdge) && this.upperLongEdgeEndIsBehindTwigEnd(indicatorOfTwig, indicatorOfUpperEdge);
    }

    private boolean upperLongEdgeStartPortIsIndicatorPort(Pair<LPort, CEdge> indicatorOfUpperEdge) {
        LPort longEdgeStartPort = indicatorOfUpperEdge.getSecond().getSourceSkippingLongEdges();
        return indicatorOfUpperEdge.getFirst() == longEdgeStartPort;
    }

    private boolean upperLongEdgeEndIsBehindTwigEnd(Pair<LPort, CEdge> indicatorOfTwig, Pair<LPort, CEdge> indicatorOfUpperEdge) {
        int layerIndexOfUpperEdgeEnd;
        int layerIndexOfEndOfTwig = this.getLayerIndexOfEndOfTwig(indicatorOfTwig);
        return layerIndexOfEndOfTwig < (layerIndexOfUpperEdgeEnd = this.getLayerIndexOfUpperEdgeEnd(indicatorOfUpperEdge));
    }

    private int getLayerIndexOfEndOfTwig(Pair<LPort, CEdge> indicatorOfTwig) {
        LNode lastNodeOfTwig = indicatorOfTwig.getSecond().getTargetNodeSkippingLinearNodes().getLastWideNodeDummy();
        return lastNodeOfTwig.getLayer().getIndex();
    }

    private int getLayerIndexOfUpperEdgeEnd(Pair<LPort, CEdge> indicatorOfUpperEdge) {
        LNode endNodeOfUpperEdge = indicatorOfUpperEdge.getSecond().getTargetSkippingLongEdges().getNode();
        return endNodeOfUpperEdge.getLayer().getIndex();
    }

    private void setTwigBelowEdge(Pair<LPort, CEdge> indicatorOfTwig, Pair<LPort, CEdge> indicatorOfUpperEdge) {
        LNode firstNodeOfTwig = indicatorOfTwig.getSecond().getTargetNode();
        LNode firstNodeOfUpperBranch = indicatorOfUpperEdge.getSecond().getTargetNode();
        this.orderProblem.setFirstNodeAboveSecondNode(firstNodeOfUpperBranch, firstNodeOfTwig);
    }

    private boolean enforcedSameOrderAsIndicatorPorts(Pair<LPort, CEdge> indicatorA, Pair<LPort, CEdge> indicatorB) {
        Pair<LPort, LNode> indicatorPortAndNodeA = this.getIndicatorPortAndCorrespondingNodeToOrder(indicatorA);
        Pair<LPort, LNode> indicatorPortAndNodeB = this.getIndicatorPortAndCorrespondingNodeToOrder(indicatorB);
        this.enforceNodeOrderAsPortOrder(indicatorPortAndNodeA, indicatorPortAndNodeB);
        return true;
    }

    private Pair<LPort, LNode> getIndicatorPortAndCorrespondingNodeToOrder(Pair<LPort, CEdge> indicator) {
        LPort indicatorPort = indicator.getFirst();
        LNode correspondingNode = this.getCorrespondingNodeToOrder(indicator);
        return new Pair<LPort, LNode>(indicatorPort, correspondingNode);
    }

    private LNode getCorrespondingNodeToOrder(Pair<LPort, CEdge> indicator) {
        return this.indicatorPortIsSourcePort(indicator) ? indicator.getSecond().getTargetNode() : indicator.getSecond().getSourceNode();
    }

    private boolean indicatorPortIsSourcePort(Pair<LPort, CEdge> indicator) {
        return indicator.getFirst().getSide() == PortSide.EAST;
    }

    private void enforceNodeOrderAsPortOrder(Pair<LPort, LNode> indicatorPortAndNodeA, Pair<LPort, LNode> indicatorPortAndNodeB) {
        if (this.firstIndicatorPortLiesAboveSecond(indicatorPortAndNodeA, indicatorPortAndNodeB)) {
            this.enforceFirstNodeAboveSecond(indicatorPortAndNodeA, indicatorPortAndNodeB);
        } else {
            this.enforceFirstNodeAboveSecond(indicatorPortAndNodeB, indicatorPortAndNodeA);
        }
    }

    private boolean firstIndicatorPortLiesAboveSecond(Pair<LPort, LNode> firstIndicatorPortAndNode, Pair<LPort, LNode> secondIndicatorPortAndNode) {
        return firstIndicatorPortAndNode.getFirst().isAbove(secondIndicatorPortAndNode.getFirst());
    }

    private void enforceFirstNodeAboveSecond(Pair<LPort, LNode> firstIndicatorPortAndNode, Pair<LPort, LNode> secondIndicatorPortAndNode) {
        LNode firstNode = firstIndicatorPortAndNode.getSecond();
        LNode secondNode = secondIndicatorPortAndNode.getSecond();
        if (this.correspondingNodesMustBeDirectlyBelowEachOther(firstIndicatorPortAndNode.getFirst(), secondIndicatorPortAndNode.getFirst())) {
            this.orderProblem.setFirstNodeDirectlyAboveSecondNode(firstNode, secondNode);
        } else {
            this.orderProblem.setFirstNodeAboveSecondNodeInfeasibleSafe(firstNode, secondNode);
        }
    }

    private boolean correspondingNodesMustBeDirectlyBelowEachOther(LPort firstIndicatorPort, LPort secondIndicatorPort) {
        return firstIndicatorPort.isNeighborOf(secondIndicatorPort) && this.portsHaveOnlyOneConnectionEach(firstIndicatorPort, secondIndicatorPort) && this.nodesAtOtherLongEdgeEndDoNotHaveFurtherPortsAtOpposingSide(firstIndicatorPort, secondIndicatorPort);
    }

    private boolean portsHaveOnlyOneConnectionEach(LPort firstPort, LPort secondPort) {
        return firstPort.getNumberOfConnectedPorts() == 1 && secondPort.getNumberOfConnectedPorts() == 1;
    }

    private boolean nodesAtOtherLongEdgeEndDoNotHaveFurtherPortsAtOpposingSide(LPort firstIndicatorPort, LPort secondIndicatorPort) {
        return this.nodeAtOtherLongEdgeEndDoesNotHaveFurtherPortsAtOpposingSide(firstIndicatorPort) && this.nodeAtOtherLongEdgeEndDoesNotHaveFurtherPortsAtOpposingSide(secondIndicatorPort);
    }

    private boolean nodeAtOtherLongEdgeEndDoesNotHaveFurtherPortsAtOpposingSide(LPort indicatorPort) {
        PortSide opposingSide;
        LNode nodeAtOtherEnd = this.getNodeAtOtherEnd(indicatorPort);
        return nodeAtOtherEnd.getPortsAsList(opposingSide = indicatorPort.getSide().opposed()).size() == 1;
    }

    private LNode getNodeAtOtherEnd(LPort indicatorPort) {
        return indicatorPort.getIncomingEdges().isEmpty() ? this.getConnectedNodeSkippingLongEdges(indicatorPort, true) : this.getConnectedNodeSkippingLongEdges(indicatorPort, false);
    }

    private LNode getConnectedNodeSkippingLongEdges(LPort port, boolean forward) {
        return port.getEdges(forward).get(0).getNodeSkippingLongEdges(forward);
    }
}

