/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.common.collect.Lists;
import com.google.ortools.sat.Literal;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.CEdge;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.IObjective;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.ArrayList;
import java.util.List;

class NodeOrderObjective
implements IObjective {
    private Literal literal;
    private long coeff;

    NodeOrderObjective(LNode nodeA, LNode nodeB, BinaryOrderProblem orderProblem) {
        this.literal = orderProblem.isBelow(nodeA, nodeB);
        this.coeff = this.getCoeffForClockwiseInlayerEdges(nodeA, nodeB) + this.getPreferredOrderCoeff(nodeA, nodeB);
    }

    @Override
    public boolean contributesToComplexity() {
        return false;
    }

    private long getCoeffForClockwiseInlayerEdges(LNode nodeA, LNode nodeB) {
        List<CEdge> connectingInlayerEdges = this.getConnectingInlayerEdges(nodeA, nodeB);
        return !connectingInlayerEdges.isEmpty() ? NodeOrderObjective.makeNegativeIfFalse(10000000000000L, this.nodeAShouldBeAboveNodeBAccordingToInlayerEdgeDirection(nodeA, nodeB, connectingInlayerEdges)) : 0L;
    }

    private List<CEdge> getConnectingInlayerEdges(LNode nodeA, LNode nodeB) {
        ArrayList connectingEdges = Lists.newArrayList();
        nodeA.getConnectedEdges().forEach(e -> this.addIfIsConnectedTo(nodeB, (LEdge)e, connectingEdges));
        return connectingEdges;
    }

    private void addIfIsConnectedTo(LNode nodeB, LEdge edge, List<CEdge> connectingEdges) {
        if (edge.isConnectedTo(nodeB)) {
            connectingEdges.add(new CEdge(edge));
        }
    }

    private boolean nodeAShouldBeAboveNodeBAccordingToInlayerEdgeDirection(LNode nodeA, LNode nodeB, List<CEdge> connectingInlayerEdges) {
        CEdge inlayerEdge = connectingInlayerEdges.get(0);
        if (inlayerEdge.getInLayerSide() == PortSide.EAST) {
            return inlayerEdge.getSourceNodeRespectingReversing() == nodeA;
        }
        return inlayerEdge.getSourceNodeRespectingReversing() == nodeB;
    }

    private long getPreferredOrderCoeff(LNode nodeA, LNode nodeB) {
        return this.getCoeffForAlphabeticalOrder(nodeA, nodeB) + this.getCoeffForPortBlockOrder(nodeA, nodeB);
    }

    private long getCoeffForAlphabeticalOrder(LNode nodeA, LNode nodeB) {
        return this.haveUsableSortableNames(nodeA, nodeB) ? NodeOrderObjective.makeNegativeIfFalse(1L, this.nodeAShouldBeAboveNodeBAccordingToAlphabet(nodeA, nodeB)) : 0L;
    }

    private boolean haveUsableSortableNames(LNode nodeA, LNode nodeB) {
        return this.hasUsableSortableName(nodeA) && this.hasUsableSortableName(nodeB);
    }

    private boolean hasUsableSortableName(LNode node) {
        return !node.isLongEdge() && node.toString() != null;
    }

    private long getCoeffForPortBlockOrder(LNode nodeA, LNode nodeB) {
        return this.bothArePortBlockNodes(nodeA, nodeB) ? NodeOrderObjective.makeNegativeIfFalse(100L, this.nodeAShouldBeAboveNodeBAccordingToPortNumber(nodeA, nodeB)) : 0L;
    }

    private boolean nodeAShouldBeAboveNodeBAccordingToAlphabet(LNode nodeA, LNode nodeB) {
        return nodeA.toString().compareTo(nodeB.toString()) <= 0;
    }

    private boolean bothArePortBlockNodes(LNode nodeA, LNode nodeB) {
        return nodeA.isPortBlockNode() && nodeB.isPortBlockNode();
    }

    private boolean nodeAShouldBeAboveNodeBAccordingToPortNumber(LNode nodeA, LNode nodeB) {
        return nodeA.getPortBlockNumber() < nodeB.getPortBlockNumber();
    }

    private static long makeNegativeIfFalse(long a, boolean tf) {
        return tf ? a : -a;
    }

    @Override
    public long getCoeff() {
        return this.coeff;
    }

    @Override
    public Literal getLiteral() {
        return this.literal;
    }
}

