/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.options.GreedySwitchType;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.p3order.LayerSweepCrossingMinimizer;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.MesCrossingMinimizer;

public class MesCrossingMinimizerCaller {
    private static final double MEMORY_UPPER_LIMIT = 1500000.0;

    public MesCrossingMinimizerCaller(LGraph layeredGraph, LGraph parentGraph) throws InterruptedException {
        if (this.probablySufficientMemoryAvailable(layeredGraph)) {
            this.tryCallingMesCrossingMiminzer(layeredGraph, parentGraph);
        } else {
            this.orderUsingHeuristic(layeredGraph, "Model would probably need too much memory.");
        }
    }

    private boolean probablySufficientMemoryAvailable(LGraph graph) {
        return this.estimateMemoryConsumption(graph) < 1500000.0;
    }

    private double estimateMemoryConsumption(LGraph graph) {
        int powerForMemoryEstimation = 3;
        return graph.getLayers().stream().mapToDouble(layer -> Math.pow(layer.getNodes().size(), 3.0)).sum();
    }

    private void tryCallingMesCrossingMiminzer(LGraph layeredGraph, LGraph parentGraph) throws InterruptedException {
        try {
            this.mesCrossingMinimization(layeredGraph);
        }
        catch (BinaryOrderProblem.OrderProblemComplexityThresholdExceededException | OutOfMemoryError e) {
            this.orderUsingHeuristic(layeredGraph, e.getMessage());
        }
    }

    private void mesCrossingMinimization(LGraph layeredGraph) throws InterruptedException {
        MesCrossingMinimizer minimizer = new MesCrossingMinimizer(layeredGraph);
        minimizer.order();
    }

    private void orderUsingHeuristic(LGraph layeredGraph, String optimizationBypassedInfo) {
        if (layeredGraph.loggingEnabled()) {
            System.out.println("MesCrossingMinimizer - Using heuristic P3 due to: " + optimizationBypassedInfo);
        }
        LayerSweepCrossingMinimizer singleComponentCrossingMinimizer = new LayerSweepCrossingMinimizer(LayerSweepCrossingMinimizer.CrossMinType.BARYCENTER);
        singleComponentCrossingMinimizer.orderNodesAndPorts(layeredGraph);
        this.orderUsingGreedySwitch(layeredGraph);
    }

    private void orderUsingGreedySwitch(LGraph layeredGraph) {
        if (layeredGraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE) != GreedySwitchType.OFF) {
            LayerSweepCrossingMinimizer singleComponentGreedySwitch = new LayerSweepCrossingMinimizer(LayerSweepCrossingMinimizer.CrossMinType.TWO_SIDED_GREEDY_SWITCH);
            singleComponentGreedySwitch.orderNodesAndPorts(layeredGraph);
        }
    }
}

