/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.ortools.CpSolverWrapper;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.CEdge;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.CrossingObjective;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.IObjective;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.InLayerCrossing;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.InterLayerCrossing;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.MixedCrossing;
import java.util.List;

public class CrossingObjectivesFactory {
    private BinaryOrderProblem orderProblem;
    private CpSolverWrapper solverWrapper;

    public CrossingObjectivesFactory(BinaryOrderProblem orderProblem) {
        this.orderProblem = orderProblem;
        this.solverWrapper = orderProblem.getSolverWrapper();
    }

    public List<IObjective> createObjectives(CEdge edgeA, CEdge edgeB) {
        switch (this.getCrossingType(edgeA, edgeB)) {
            case IN_LAYER: {
                return this.getInLayerCrossingObjectives(edgeA, edgeB);
            }
            case INTER_LAYER: {
                return this.getInterLayerCrossingObjectives(edgeA, edgeB);
            }
            case MIXED: {
                return this.getMixedCrossingObjectives(edgeA, edgeB);
            }
            case IMPOSSIBLE: {
                return Lists.newArrayList();
            }
        }
        return Lists.newArrayList();
    }

    private CrossingType getCrossingType(CEdge edgeA, CEdge edgeB) {
        if (edgeA.isInLayerEdge() && edgeB.isInLayerEdge()) {
            return edgeA.getInLayerSide() == edgeB.getInLayerSide() ? CrossingType.IN_LAYER : CrossingType.IMPOSSIBLE;
        }
        return edgeA.isInLayerEdge() || edgeB.isInLayerEdge() ? CrossingType.MIXED : CrossingType.INTER_LAYER;
    }

    private List<IObjective> getInLayerCrossingObjectives(CEdge edgeA, CEdge edgeB) {
        CrossingObjective objective = new CrossingObjective(edgeA, edgeB, new InLayerCrossing(edgeA, edgeB, this.orderProblem), 0L, this.solverWrapper);
        return Lists.newArrayList((Object[])new IObjective[]{objective});
    }

    private List<IObjective> getInterLayerCrossingObjectives(CEdge edgeA, CEdge edgeB) {
        CEdge edgeWithPreferredDownCrossing = this.oneEdgeWithPreferredDownCrossing(edgeA, edgeB);
        return edgeWithPreferredDownCrossing != null ? this.getInterLayerCrossingObjectivesWithPreferredDownCrossing(edgeWithPreferredDownCrossing, edgeA, edgeB) : this.getNormalInterLayerCrossingObjectives(edgeA, edgeB);
    }

    private CEdge oneEdgeWithPreferredDownCrossing(CEdge edgeA, CEdge edgeB) {
        if (edgeA.isSplit() && !edgeB.isSplit()) {
            return edgeA;
        }
        if (edgeB.isSplit() && !edgeA.isSplit()) {
            return edgeB;
        }
        return null;
    }

    private List<IObjective> getInterLayerCrossingObjectivesWithPreferredDownCrossing(CEdge edgeWithPreferredDownCrossing, CEdge edgeA, CEdge edgeB) {
        return edgeWithPreferredDownCrossing == edgeA ? this.getInterLayerCrossingObjectivesWithPreferredDownCrossing(edgeA, edgeB) : this.getInterLayerCrossingObjectivesWithPreferredDownCrossing(edgeB, edgeA);
    }

    private List<IObjective> getInterLayerCrossingObjectivesWithPreferredDownCrossing(CEdge edgeWithPreferredDownCrossing, CEdge edge) {
        long coeffDeltaUp = 90L;
        return Lists.newArrayList((Object[])new IObjective[]{this.getInterLayerCrossingObjective(edgeWithPreferredDownCrossing, edge, InterLayerCrossing.CrossingDirection.UP, coeffDeltaUp), this.getInterLayerCrossingObjective(edgeWithPreferredDownCrossing, edge, InterLayerCrossing.CrossingDirection.DOWN, 0L)});
    }

    private IObjective getInterLayerCrossingObjective(CEdge edgeA, CEdge edgeB, InterLayerCrossing.CrossingDirection direction, long coeffDelta) {
        return new CrossingObjective(edgeA, edgeB, new InterLayerCrossing(edgeA, edgeB, direction, this.orderProblem), coeffDelta, this.solverWrapper);
    }

    private List<IObjective> getNormalInterLayerCrossingObjectives(CEdge edgeA, CEdge edgeB) {
        return Lists.newArrayList((Object[])new IObjective[]{this.getInterLayerCrossingObjective(edgeA, edgeB, InterLayerCrossing.CrossingDirection.UP_OR_DOWN, 0L)});
    }

    private List<IObjective> getMixedCrossingObjectives(CEdge edgeA, CEdge edgeB) {
        CrossingObjective objective = new CrossingObjective(edgeA, edgeB, new MixedCrossing(edgeA, edgeB, this.orderProblem), 0L, this.solverWrapper);
        return Lists.newArrayList((Object[])new IObjective[]{objective});
    }

    static enum CrossingType {
        IN_LAYER,
        INTER_LAYER,
        MIXED,
        IMPOSSIBLE;

    }
}

