/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.ortools.sat.Literal;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.ortools.CpSolverWrapper;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.CEdge;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.ICrossingObjectiveCore;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.IObjective;

public class CrossingObjective
implements IObjective {
    private CEdge edgeA;
    private CEdge edgeB;
    private ICrossingObjectiveCore objectiveCore;
    private long coeffDelta;
    private CpSolverWrapper solverWrapper;

    public CrossingObjective(CEdge edgeA, CEdge edgeB, ICrossingObjectiveCore objectiveCore, long coeffDelta, CpSolverWrapper solverWrapper) {
        this.edgeA = edgeA;
        this.edgeB = edgeB;
        this.objectiveCore = objectiveCore;
        this.coeffDelta = coeffDelta;
        this.solverWrapper = solverWrapper;
    }

    @Override
    public long getCoeff() {
        return this.getBaseCoeff() + this.coeffDelta;
    }

    private long getBaseCoeff() {
        long crossingCoeff = this.getCrossingCoefficient();
        long coeffGradient = this.getCoeffGradientToPreventStairs();
        return crossingCoeff + coeffGradient;
    }

    private long getCrossingCoefficient() {
        long individualAddition = this.getAdditionFromIndividualEdges();
        long mutualAddition = this.getAdditionFromMutualInteraction();
        return individualAddition + mutualAddition;
    }

    private long getAdditionFromIndividualEdges() {
        if (this.edgeA.isWideNodeInnerEdge() || this.edgeB.isWideNodeInnerEdge()) {
            return 1000000000000L;
        }
        return this.getAdditionForNormalEdge();
    }

    private long getAdditionForNormalEdge() {
        int numOutEdgesA = this.edgeA.getNumOfSplitEdges();
        int numOutEdgesB = this.edgeB.getNumOfSplitEdges();
        return 100000000L * (long)(numOutEdgesA + numOutEdgesB) / (long)(2 * numOutEdgesA * numOutEdgesB);
    }

    private long getAdditionFromMutualInteraction() {
        long additionForSameTarget = this.getAdditionForSameTarget();
        long additionForTopPortEdgeToSameTarget = this.getAdditionForTopPortEdgeToSameTarget();
        long additionForCrossingOfFeedbackLoop = this.getAdditionForCrossingOfFeedbackLoop();
        return additionForSameTarget + additionForTopPortEdgeToSameTarget + additionForCrossingOfFeedbackLoop;
    }

    private long getAdditionForSameTarget() {
        return this.areEdgesWithSameTargetThatShouldNotCross() ? 1000000000L : 0L;
    }

    private boolean areEdgesWithSameTargetThatShouldNotCross() {
        return this.areEdgesWithSameTarget() && !this.edgeA.isWideNodeInnerEdge() && !this.edgeB.isWideNodeInnerEdge() && !this.edgeA.isSplit() && !this.edgeB.isSplit() && !this.edgeA.isInLayerEdge() && !this.edgeB.isInLayerEdge();
    }

    private boolean areEdgesWithSameTarget() {
        return this.edgeA.getTargetSkippingLongEdges().getNode().equals(this.edgeB.getTargetSkippingLongEdges().getNode());
    }

    private long getAdditionForTopPortEdgeToSameTarget() {
        return this.isPairOfNormalAndTopPortEdgeToSameNode() ? 2000000000L : 0L;
    }

    private boolean isPairOfNormalAndTopPortEdgeToSameNode() {
        return this.firstGoesToTopPortOfSameBlockAsSecondGoes(this.edgeA, this.edgeB) || this.firstGoesToTopPortOfSameBlockAsSecondGoes(this.edgeB, this.edgeA);
    }

    private boolean firstGoesToTopPortOfSameBlockAsSecondGoes(CEdge firstEdge, CEdge secondEdge) {
        LPort firstTargetPort = firstEdge.getTargetSkippingLongEdges();
        if (firstTargetPort.getNode().isNorthSouthDummyForNorthPort()) {
            LNode nodeOfTopPortEdge = ((LPort)firstTargetPort.getProperty(InternalProperties.ORIGIN)).getNode();
            LNode nodeOfSecondEdge = secondEdge.getTargetSkippingLongEdges().getNode();
            return this.arePartOfSameNode(nodeOfTopPortEdge, nodeOfSecondEdge);
        }
        return false;
    }

    private boolean arePartOfSameNode(LNode nodeOfTopPortEdge, LNode nodeOfSecondEdge) {
        return nodeOfTopPortEdge.getWideNodeDummiesOrNodeItself().contains(nodeOfSecondEdge);
    }

    private long getAdditionForCrossingOfFeedbackLoop() {
        long addition = 0L;
        if (this.isSelfCrossingOfFeedbackLoop()) {
            addition += 3000000000L;
        }
        if (this.isNonInlayerCrossingOfFeedbackLoop()) {
            addition += 90000000L;
        }
        return addition;
    }

    private boolean isSelfCrossingOfFeedbackLoop() {
        return this.edgeA.isPartOfSameFeedbackLoopsAs(this.edgeB);
    }

    private boolean isNonInlayerCrossingOfFeedbackLoop() {
        return (this.edgeA.isPartOfFeedbackLoop() || this.edgeB.isPartOfFeedbackLoop()) && !this.edgeA.isInLayerEdge() && !this.edgeB.isInLayerEdge();
    }

    private long getCoeffGradientToPreventStairs() {
        return Math.min(this.edgeA.getLeftLayerIndex(), this.edgeB.getLeftLayerIndex());
    }

    @Override
    public Literal getLiteral() {
        return this.objectiveCore.noObjectiveNeeded() ? null : this.getCrossingLiteral();
    }

    private Literal getCrossingLiteral() {
        Literal literal = this.getCrossingLiteralWithoutConditions(this.edgeA, this.edgeB);
        Literal crossingConditions = this.objectiveCore.getLiteral();
        this.solverWrapper.addEquality(literal, crossingConditions);
        return this.isLiteralThatMayBeTrue(literal) ? literal : null;
    }

    private Literal getCrossingLiteralWithoutConditions(CEdge a, CEdge b) {
        return this.crossingIsForbidden(a, b) ? this.newCrossingLiteralThatIsSetToFalse() : this.newBlankCrossingLiteral(a, b);
    }

    private boolean crossingIsForbidden(CEdge a, CEdge b) {
        return this.isWideNodeInnerCrossing(a, b) && this.cannotLeadToInfeasable(a, b) && this.cannotHinderClockWiseFeedbackLoops(a, b);
    }

    private boolean isWideNodeInnerCrossing(CEdge a, CEdge b) {
        return a.isWideNodeInnerEdge() || b.isWideNodeInnerEdge();
    }

    private boolean cannotLeadToInfeasable(CEdge a, CEdge b) {
        return !a.getTargetNode().isNorthSouthDummy() && !b.getTargetNode().isNorthSouthDummy();
    }

    private boolean cannotHinderClockWiseFeedbackLoops(CEdge a, CEdge b) {
        return !a.isInLayerEdge() && !b.isInLayerEdge();
    }

    private Literal newCrossingLiteralThatIsSetToFalse() {
        return this.solverWrapper.getFalse();
    }

    private Literal newBlankCrossingLiteral(CEdge a, CEdge b) {
        return this.solverWrapper.newBoolVar(String.valueOf(a.toString()) + "_crosses_" + b.toString());
    }

    private boolean isLiteralThatMayBeTrue(Literal crossingLiteral) {
        return crossingLiteral != this.solverWrapper.getFalse();
    }

    @Override
    public boolean contributesToComplexity() {
        return true;
    }
}

