/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.List;

public final class CEdge {
    private LEdge lEdge;

    public CEdge(LEdge lEdge) {
        this.lEdge = lEdge;
    }

    public LPort getIndicatorPort() {
        LPort indicatorPort = this.getPotentialIndicatorPort();
        return indicatorPort != null && indicatorPort.isNorthOrSouthPort() ? null : indicatorPort;
    }

    private LPort getPotentialIndicatorPort() {
        if (this.isSourceTwig()) {
            return this.getTargetSkippingLinearNodes();
        }
        if (this.isTargetTwig()) {
            return this.getSourceSkippingLinearNodes();
        }
        return null;
    }

    private boolean isSourceTwig() {
        return this.isTwig(false);
    }

    public boolean isTargetTwig() {
        return this.isTwig(true);
    }

    private boolean isTwig(boolean forward) {
        return CEdge.isLeafNode(this.getPortSkippingLinearNodes(forward).getNode(), forward);
    }

    private static boolean isLeafNode(LNode node, boolean forward) {
        return node.getTrueEdges(forward).isEmpty() && node.getTrueEdges(!forward).size() == 1 && !node.hasNorthSouthPort() && !node.isNorthSouthDummy();
    }

    private LPort getSourceSkippingLinearNodes() {
        return this.getPortSkippingLinearNodes(false);
    }

    private LPort getTargetSkippingLinearNodes() {
        return this.getPortSkippingLinearNodes(true);
    }

    private LPort getPortSkippingLinearNodes(boolean forward) {
        LPort curPort = this.lEdge.getPortSkippingLongEdges(forward);
        while (this.isLinearNode(curPort.getNode())) {
            curPort = curPort.getNode().getTrueEdges(forward).get(0).getPortSkippingLongEdges(forward);
        }
        return curPort;
    }

    private boolean isLinearNode(LNode node) {
        return node.getTrueIncomingEdges().size() == 1 && node.getTrueOutgoingEdges().size() == 1 && !node.hasNorthSouthPort();
    }

    public LNode getTargetNodeSkippingLinearNodes() {
        return this.getTargetSkippingLinearNodes().getNode();
    }

    public LPort getPortSkippingLongEdges(boolean forward) {
        return this.lEdge.getPortSkippingLongEdges(forward);
    }

    public LPort getTargetSkippingLongEdges() {
        return this.lEdge.getTargetSkippingLongEdges();
    }

    public LPort getSourceSkippingLongEdges() {
        return this.lEdge.getSourceSkippingLongEdges();
    }

    public boolean isWideNodeInnerEdge() {
        return this.getSource().isWideNodeInnerPort();
    }

    public int getLeftLayerIndex() {
        return Math.min(this.getSourceNode().getLayer().getIndex(), this.getTargetNode().getLayer().getIndex());
    }

    public boolean isInLayerEdge() {
        return this.lEdge.isInLayerEdge();
    }

    public PortSide getInLayerSide() {
        return this.getSource().getSide();
    }

    public LPort getSource() {
        return this.lEdge.getSource();
    }

    public LPort getTarget() {
        return this.lEdge.getTarget();
    }

    public LNode getNode(boolean forward) {
        return forward ? this.getTargetNode() : this.getSourceNode();
    }

    public LNode getSourceNode() {
        return this.lEdge.getSourceNode();
    }

    public LNode getTargetNode() {
        return this.lEdge.getTargetNode();
    }

    public LNode getSourceNodeRespectingReversing() {
        return this.isReversed() ? this.getTargetNode() : this.getSourceNode();
    }

    private boolean isReversed() {
        return this.lEdge.getProperty(InternalProperties.REVERSED);
    }

    public boolean isSplit() {
        return this.getNumOfSplitEdges() > 1;
    }

    public int getNumOfSplitEdges() {
        if (this.isReversed()) {
            LPort targetPortSkippingLongEdge = this.getTargetSkippingLongEdges();
            return targetPortSkippingLongEdge.getIncomingEdges().size();
        }
        LPort sourcePortSkippingLongEdge = this.getSourceSkippingLongEdges();
        return sourcePortSkippingLongEdge.getOutgoingEdges().size();
    }

    public boolean hasSameSourceAndTargetNodeAs(CEdge edge) {
        return this.getSourceNode() == edge.getSourceNode() && this.getTargetNode() == edge.getTargetNode();
    }

    public boolean hasCommonPortWith(CEdge edge) {
        return this.getSource() == edge.getSource() || this.getSource() == edge.getTarget() || this.getTarget() == edge.getSource() || this.getTarget() == edge.getTarget();
    }

    public boolean isPartOfFeedbackLoop() {
        return !this.getFeedbackLoopIds().isEmpty();
    }

    public boolean isPartOfSameFeedbackLoopsAs(CEdge otherEdge) {
        List<Integer> feedbackLoopIdsOfOtherEdge = otherEdge.getFeedbackLoopIds();
        return this.getFeedbackLoopIds().stream().anyMatch(feedbackLoopIdsOfOtherEdge::contains);
    }

    private List<Integer> getFeedbackLoopIds() {
        return this.lEdge.getProperty(InternalProperties.FEEDBACK_LOOP_IDS);
    }

    public String toString() {
        return this.lEdge.toString();
    }
}

