/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order;

import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.GreedySwitchType;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.p3order.LGraphSplitter;
import com.modelengineers.MoRe_elk.alg.layered.p3order.LayerSweepCrossingMinimizer;
import com.modelengineers.MoRe_elk.alg.layered.p3order.SeparateComponentSorter;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.MesCrossingMinimizerCaller;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.List;

public class SeparateComponentCrossingMinimizer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private List<LGraph> unsortedComponents;
    private List<LGraph> sortedComponents;
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.LONG_EDGE_SPLITTER).addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR).after(LayeredPhases.P5_EDGE_ROUTING).add(IntermediateProcessorStrategy.LONG_EDGE_JOINER);

    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) throws InterruptedException {
        progressMonitor.begin("Minimize crossings component by component ", 1.0f);
        this.unsortedComponents = LGraphSplitter.split(graph);
        this.orderComponents(graph, progressMonitor);
        this.sortComponents();
        this.updateOrderOfWholeGraph(graph);
        this.changeOrderOfPortBlocksToReduceUnwantedCrossings(graph);
        progressMonitor.done();
    }

    private void orderComponents(LGraph graph, IElkProgressMonitor progressMonitor) throws InterruptedException {
        for (LGraph comp : this.unsortedComponents) {
            this.order(comp, graph, progressMonitor);
        }
    }

    private void order(LGraph component, LGraph layeredGraph, IElkProgressMonitor progressMonitor) throws InterruptedException {
        new MesCrossingMinimizerCaller(component, layeredGraph);
    }

    private void sortComponents() {
        this.sortedComponents = new SeparateComponentSorter(this.unsortedComponents).sort();
    }

    private void updateOrderOfWholeGraph(LGraph graph) {
        for (Layer layer : graph.getLayers()) {
            layer.getNodes().clear();
        }
        for (LGraph component : this.sortedComponents) {
            for (Layer layerOfComponent : component.getLayers()) {
                List<LNode> nodesToSet = layerOfComponent.getNodes();
                LGraphSplitter.setGraphOfNodes(nodesToSet, graph, false);
            }
        }
    }

    private void changeOrderOfPortBlocksToReduceUnwantedCrossings(LGraph graph) {
        if (graph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE) != GreedySwitchType.OFF) {
            new LayerSweepCrossingMinimizer(null).orderFirstAndLastSeparateLayer(graph);
        }
    }

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        LayoutProcessorConfiguration<LayeredPhases, LGraph> configuration = LayoutProcessorConfiguration.createFrom(INTERMEDIATE_PROCESSING_CONFIGURATION);
        configuration.addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.FEEDBACK_LOOP_PROCESSOR);
        configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.PORT_LIST_SORTER);
        return configuration;
    }
}

