/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.Component;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class LGraphSplitter {
    private LGraphSplitter() {
    }

    public static List<LGraph> split(LGraph graph) {
        ArrayList splitGraphs = Lists.newArrayList();
        List<Component> components = LGraphSplitter.getComponents(graph);
        for (Component component : components) {
            LGraph newGraph = LGraphSplitter.buildComponentGraph(graph, component);
            splitGraphs.add(newGraph);
        }
        return splitGraphs;
    }

    public static List<Component> getComponents(LGraph graph) {
        List<List<LNode>> nodesOfComponents = LGraphSplitter.getNodesOfComponents(graph);
        ArrayList components = Lists.newArrayList();
        for (List<LNode> nodesOfComponent : nodesOfComponents) {
            components.add(LGraphSplitter.createComponent(graph, nodesOfComponent));
        }
        return components;
    }

    private static List<List<LNode>> getNodesOfComponents(LGraph graph) {
        List<LNode> nodesOfGraph = LGraphSplitter.getNodesOfGraph(graph);
        nodesOfGraph.forEach(node -> {
            int n = node.id = 0;
        });
        ArrayList nodesOfComponents = Lists.newArrayList();
        for (LNode node2 : nodesOfGraph) {
            List<LNode> nodesOfComponent = LGraphSplitter.getNodesOfComponentAndMarkNodesAsVisited(node2);
            if (nodesOfComponent.isEmpty()) continue;
            nodesOfComponents.add(nodesOfComponent);
        }
        return nodesOfComponents;
    }

    private static List<LNode> getNodesOfGraph(LGraph graph) {
        ArrayList nodesOfGraph = Lists.newArrayList();
        for (Layer layer : graph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                nodesOfGraph.add(node);
            }
        }
        return nodesOfGraph;
    }

    private static List<LNode> getNodesOfComponentAndMarkNodesAsVisited(LNode nodeInComponent) {
        ArrayList nodesOfComponent = Lists.newArrayList();
        LGraphSplitter.dfs(nodeInComponent, nodesOfComponent);
        return nodesOfComponent;
    }

    private static void dfs(LNode node, List<LNode> nodesOfComponent) {
        if (node.id == 0) {
            node.id = 1;
            nodesOfComponent.add(node);
            for (LNode connNode : LGraphSplitter.getAllConnectedNodes(node)) {
                LGraphSplitter.dfs(connNode, nodesOfComponent);
            }
        }
    }

    private static List<LNode> getAllConnectedNodes(LNode node) {
        ArrayList<LNode> connectedNodes = new ArrayList<LNode>();
        for (LPort port1 : node.getPorts()) {
            for (LPort port2 : port1.getConnectedPorts()) {
                connectedNodes.add(port2.getNode());
            }
            LNode northSouthNode = port1.getProperty(InternalProperties.PORT_DUMMY);
            if (northSouthNode == null) continue;
            connectedNodes.add(northSouthNode);
        }
        if (node.getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
            connectedNodes.add((LNode)node.getProperty(InternalProperties.ORIGIN));
        }
        return connectedNodes;
    }

    private static LGraph buildComponentGraph(LGraph graph, Component component) {
        LGraph newGraph = new LGraph();
        newGraph.getComponents().add(component);
        newGraph.copyProperties(graph);
        for (Layer layer : graph.getLayers()) {
            List<LNode> layerNodesInComponent = layer.getNodes().stream().filter(component.getNodes()::contains).collect(Collectors.toList());
            if (layerNodesInComponent.isEmpty()) continue;
            Layer layerOfNewGraph = new Layer(newGraph);
            LGraphSplitter.setGraphOfNodes(layerNodesInComponent, newGraph, true);
            layerOfNewGraph.getNodes().addAll(layerNodesInComponent);
            newGraph.getLayers().add(layerOfNewGraph);
        }
        return newGraph;
    }

    private static Component createComponent(LGraph graph, List<LNode> nodesOfComponent) {
        Component component = new Component(graph);
        LGraphSplitter.addNodesToComponent(component, nodesOfComponent);
        graph.getComponents().add(component);
        return component;
    }

    public static void setGraphOfNodes(List<LNode> nodesOfComponent, LGraph lGraph, boolean retainNodeOrder) {
        for (LNode node : nodesOfComponent) {
            Layer layer = node.getLayer();
            int indexInLayer = node.getIndex();
            node.setLayer(null);
            node.setGraph(lGraph);
            if (retainNodeOrder) {
                node.setLayer(indexInLayer, layer);
                continue;
            }
            node.setLayer(layer);
        }
    }

    private static void addNodesToComponent(Component component, List<LNode> nodesOfComponent) {
        for (LNode node : nodesOfComponent) {
            if (node.isWideNode()) {
                LNode originWideNode = node.getOriginalWideNode();
                if (!component.getNodes().contains(originWideNode)) {
                    LGraphSplitter.addNodeToComponent(component, originWideNode);
                }
            }
            LGraphSplitter.addNodeToComponent(component, node);
        }
    }

    private static void addNodeToComponent(Component component, LNode node) {
        if (node.getNestedGraph() != null) {
            List<LNode> nodesInNestedGraph = LGraphSplitter.getNodesInNestedGraph(node.getNestedGraph());
            LGraphSplitter.addNodesToComponent(component, nodesInNestedGraph);
        }
        node.setComponent(component);
    }

    private static List<LNode> getNodesInNestedGraph(LGraph nestedGraph) {
        ArrayList nodesInNestedGraph = Lists.newArrayList();
        for (Layer layer : nestedGraph.getLayers()) {
            nodesInNestedGraph.addAll(layer.getNodes());
        }
        return nodesInNestedGraph;
    }
}

