/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order;

import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.GraphProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.p3order.LGraphSplitter;
import com.modelengineers.MoRe_elk.alg.layered.p3order.NodeRelativePortDistributor;
import com.modelengineers.MoRe_elk.alg.layered.p3order.counting.IInitializable;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class InteractiveCrossingMinimizer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.LONG_EDGE_SPLITTER).addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.LONG_EDGE_JOINER);

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        LayoutProcessorConfiguration<LayeredPhases, LGraph> configuration = LayoutProcessorConfiguration.createFrom(INTERMEDIATE_PROCESSING_CONFIGURATION);
        if (graph.getProperty(InternalProperties.GRAPH_PROPERTIES).contains((Object)GraphProperties.NON_FREE_PORTS)) {
            configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.PORT_LIST_SORTER);
        }
        return configuration;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Interactive crossing minimization", 1.0f);
        int layerIndex = 0;
        for (Layer layer : layeredGraph.getLayers()) {
            layer.id = layerIndex++;
        }
        LNode[][] nodeOrder = layeredGraph.toNodeArray();
        NodeRelativePortDistributor portDistributor = new NodeRelativePortDistributor(nodeOrder.length);
        IInitializable.init(Arrays.asList(portDistributor), nodeOrder);
        int portCount = 0;
        layerIndex = 0;
        for (Layer layer : layeredGraph) {
            double horizPos = 0.0;
            int nodeCount = 0;
            for (LNode node : layer.getNodes()) {
                if (node.getPosition().x > 0.0) {
                    horizPos += node.getPosition().x + node.getSize().x / 2.0;
                    ++nodeCount;
                }
                for (LPort port : node.getPorts()) {
                    port.id = portCount++;
                }
            }
            if (nodeCount > 0) {
                horizPos /= (double)nodeCount;
            }
            final double[] pos = new double[layer.getNodes().size()];
            int nextIndex = 0;
            for (LNode node : layer) {
                node.id = nextIndex++;
                pos[node.id] = this.getPos(node, horizPos);
                if (node.getType() != LNode.NodeType.LONG_EDGE) continue;
                node.setProperty(InternalProperties.ORIGINAL_DUMMY_NODE_POSITION, (Object)pos[node.id]);
            }
            Collections.sort(layer.getNodes(), new Comparator<LNode>(){

                @Override
                public int compare(LNode node1, LNode node2) {
                    int compare = Double.compare(pos[node1.id], pos[node2.id]);
                    if (compare == 0) {
                        List<LNode> node1Successors = node1.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS);
                        List<LNode> node2Successors = node2.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS);
                        if (node1Successors.contains(node2)) {
                            return -1;
                        }
                        if (node2Successors.contains(node1)) {
                            return 1;
                        }
                    }
                    return compare;
                }
            });
            portDistributor.distributePortsWhileSweeping(nodeOrder, layerIndex, true);
            ++layerIndex;
        }
        LGraphSplitter.getComponents(layeredGraph);
        monitor.done();
    }

    private double getPos(LNode node, double horizPos) {
        switch (node.getType()) {
            case LONG_EDGE: {
                LPort target;
                LEdge edge = (LEdge)node.getProperty(InternalProperties.ORIGIN);
                KVectorChain bendpoints = edge.getProperty(InternalProperties.ORIGINAL_BENDPOINTS);
                if (bendpoints == null) {
                    bendpoints = new KVectorChain();
                } else if (edge.getProperty(InternalProperties.REVERSED).booleanValue()) {
                    bendpoints = KVectorChain.reverse(bendpoints);
                }
                LPort source = node.getProperty(InternalProperties.LONG_EDGE_SOURCE);
                if (source != null) {
                    KVector sourcePoint = source.getAbsoluteAnchor();
                    if (horizPos <= sourcePoint.x) {
                        return sourcePoint.y;
                    }
                    bendpoints.addFirst(sourcePoint);
                }
                if ((target = node.getProperty(InternalProperties.LONG_EDGE_TARGET)) != null) {
                    KVector targetPoint = target.getAbsoluteAnchor();
                    if (targetPoint.x <= horizPos) {
                        return targetPoint.y;
                    }
                    bendpoints.addLast(targetPoint);
                }
                if (bendpoints.size() < 2) break;
                Iterator pointIter = bendpoints.iterator();
                KVector point1 = (KVector)pointIter.next();
                KVector point2 = (KVector)pointIter.next();
                while (point2.x < horizPos && pointIter.hasNext()) {
                    point1 = point2;
                    point2 = (KVector)pointIter.next();
                }
                return point1.y + (horizPos - point1.x) / (point2.x - point1.x) * (point2.y - point1.y);
            }
            case NORTH_SOUTH_PORT: {
                LPort originPort = (LPort)node.getPorts().get(0).getProperty(InternalProperties.ORIGIN);
                LNode originNode = originPort.getNode();
                switch (originPort.getSide()) {
                    case NORTH: {
                        return originNode.getPosition().y;
                    }
                    case SOUTH: {
                        return originNode.getPosition().y + originNode.getSize().y;
                    }
                }
            }
        }
        return node.getInteractiveReferencePoint().y;
    }
}

