/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p2layers.mes;

import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.ortools.MPSolverWrapperInt;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.FinalLayeringProblem;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.List;
import java.util.stream.Stream;

public class SplitSourceNodesConstraints {
    private static final double DISTANCED_THRESHOLD_HEIGHT_VS_WIDTH = 1.5;
    private FinalLayeringProblem finalLayeringProblem;
    private List<LNode> nodes;
    private MPSolverWrapperInt solver;

    public SplitSourceNodesConstraints(FinalLayeringProblem finalLayeringProblem, List<LNode> nodes, MPSolverWrapperInt solver) {
        this.finalLayeringProblem = finalLayeringProblem;
        this.nodes = nodes;
        this.solver = solver;
        this.setConstraints();
    }

    private void setConstraints() {
        this.getSplitSourceNodesWithNearTarget().forEach(p -> this.treatSplitSourceNodeWithNearTarget((LNode)p.getFirst(), (LNode)p.getSecond()));
    }

    private Stream<Pair<LNode, LNode>> getSplitSourceNodesWithNearTarget() {
        return this.nodes.stream().filter(n -> this.isSplitSourceNode((LNode)n)).flatMap(n -> this.getNearTargets((LNode)n).map(t -> new Pair<LNode, LNode>((LNode)n, (LNode)t)));
    }

    private boolean isSplitSourceNode(LNode node) {
        return (!node.isWideNode() || node.isLastWideNodeDummy()) && node.getTruePorts().size() == 1 && node.getNumTrueEastPorts() == 1L && node.getTrueTargetNodes().size() > 1 && !node.isSeparate();
    }

    private Stream<LNode> getNearTargets(LNode node) {
        int ixLayerOfNode = this.getLayerWithoutSimilarity(node.getLastWideNodeDummy());
        return node.getTrueTargetNodes().stream().filter(t -> this.getLayerWithoutSimilarity((LNode)t) - ixLayerOfNode == 1);
    }

    private void treatSplitSourceNodeWithNearTarget(LNode splitSourceNode, LNode nearTarget) {
        nearTarget.getTrueSourceNodes().stream().filter(n -> this.shouldBeLeftFrom((LNode)n, splitSourceNode)).forEach(n -> this.hasToBeLeftFrom((LNode)n, splitSourceNode));
    }

    private boolean shouldBeLeftFrom(LNode node, LNode splitSourceNode) {
        return node.hasTrueWestPorts() && this.layersOverlap(node, splitSourceNode) && this.isHighEnoughToBeDistanced(node, splitSourceNode) && SplitSourceNodesConstraints.haveNeighboringTargetPorts(node, splitSourceNode);
    }

    private boolean layersOverlap(LNode a, LNode b) {
        int leftA = this.getLayerWithoutSimilarity(a.getFirstWideNodeDummy());
        int rightA = this.getLayerWithoutSimilarity(a.getLastWideNodeDummy());
        int leftB = this.getLayerWithoutSimilarity(b.getFirstWideNodeDummy());
        int rightB = this.getLayerWithoutSimilarity(b.getLastWideNodeDummy());
        return leftB <= rightA && rightB >= leftA;
    }

    private int getLayerWithoutSimilarity(LNode node) {
        return this.finalLayeringProblem.getLayerWithoutSimilarity(node);
    }

    private boolean isHighEnoughToBeDistanced(LNode node, LNode splitSourceNode) {
        return node.getTrueNode().getSize().y > 1.5 * splitSourceNode.getTrueNode().getSize().x;
    }

    private static boolean haveNeighboringTargetPorts(LNode a, LNode b) {
        return a.getTrueTargetPorts().stream().anyMatch(tp1 -> b.getTrueTargetPorts().stream().anyMatch(tp2 -> tp2.isNeighborOf((LPort)tp1)));
    }

    private void hasToBeLeftFrom(LNode left, LNode right) {
        this.solver.diffHasToBeInRange(this.finalLayeringProblem.getLayer(right.getFirstWideNodeDummy()), this.finalLayeringProblem.getLayer(left.getLastWideNodeDummy()), 1.0, this.nodes.size() - 1);
    }
}

