/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p2layers.mes;

import com.google.common.collect.Lists;
import com.google.ortools.linearsolver.MPConstraint;
import com.google.ortools.linearsolver.MPVariable;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.ortools.MPSolverWrapperInt;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.SatelliteAndBaseNodesConstraints;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LayerBasedOnOrderProblem {
    private static final double COEFF_LENGTH_OF_EDGE = 100.0;
    private static final double COEFF_LENGTH_OF_EDGE_TO_SEPARATE_NODE = 40.0;
    private static final double COEFF_FACTOR_FOR_LENGTH_OF_EDGE_TO_END_NODE_WITHOUT_EDGE_LABEL = 40.0;
    private static final double COEFF_FACTOR_FOR_LENGTH_OF_EDGE_TO_END_NODE_WITH_EDGE_LABEL = 5.0;
    private static final double COEFF_FACTOR_FOR_LENGTH_OF_EDGE_FROM_TOP_PORT_TO_END_NODE = 100.0;
    private static final double COEFF_DISTANCE_OF_SINGLE_FLIPPED_NODE_FROM_CENTER_OF_LOOP = 20.0;
    private static final double COEFF_DISTANCE_OF_SINGLE_FLIPPED_NODE_LEFT_OF_TARGET_NODES = 20000.0;
    private static final double COEFF_DISTANCE_OF_SINGLE_FLIPPED_NODE_RIGHT_OF_SOURCE_NODES = 10000.0;
    private static final double COEFF_SUM_OF_ALL_LAYER_VALUES = 1.0;
    private MPSolverWrapperInt solver;
    private List<LNode> nodes;
    private Map<LNode, MPVariable> nodeToLayerMap;
    private int[] layersOfNodesForOrder;
    private SatelliteAndBaseNodesConstraints satelliteAndBaseNodesConstraints;

    public LayerBasedOnOrderProblem(MPSolverWrapperInt solver, List<LNode> nodes, Map<LNode, MPVariable> nodeToLayerMap, int[] layersOfNodesForOrder) {
        this.solver = solver;
        this.nodes = nodes;
        this.nodeToLayerMap = nodeToLayerMap;
        this.layersOfNodesForOrder = layersOfNodesForOrder;
        this.addConstraintsAndObjectivesToSolver();
    }

    private void addConstraintsAndObjectivesToSolver() {
        this.markSingleFlippedNodesInFeedbackLoops();
        this.treatEdges();
        this.treatSeparateConstraints();
        this.treatSatelliteAndBaseNodes();
        this.treatSingleFlippedNodesInFeedbackLoops();
        this.treatNodesWithSplitEdgesToFeedbackLoops();
        this.treatGotoFromNodes();
        this.layersShouldStartAtZero();
    }

    private void markSingleFlippedNodesInFeedbackLoops() {
        this.nodes.forEach(n -> n.setIsSingleFlippedNodeInFeedbackLoop(LayerBasedOnOrderProblem.isSingleFlippedNodeInFeedbackLoop(n)));
    }

    private static boolean isSingleFlippedNodeInFeedbackLoop(LNode node) {
        List<LPort> ports = node.getTruePorts();
        List<LPort> westPorts = node.getTruePorts(PortSide.WEST);
        List<LPort> eastPorts = node.getTruePorts(PortSide.EAST);
        boolean tf = false;
        if (!westPorts.isEmpty() && !eastPorts.isEmpty() && westPorts.size() + eastPorts.size() == ports.size() && westPorts.stream().allMatch(p -> p.getIncomingEdges().isEmpty()) && eastPorts.stream().allMatch(p -> p.getOutgoingEdges().isEmpty())) {
            List westOutgoingEdges = westPorts.stream().flatMap(p -> p.getOutgoingEdges().stream()).collect(Collectors.toList());
            List eastIncomingEdges = eastPorts.stream().flatMap(p -> p.getIncomingEdges().stream()).collect(Collectors.toList());
            if (!westOutgoingEdges.isEmpty() && !eastIncomingEdges.isEmpty()) {
                tf = westOutgoingEdges.stream().allMatch(e -> e.getTargetSide().equals((Object)PortSide.WEST)) && eastIncomingEdges.stream().allMatch(e -> e.getSourceSide().equals((Object)PortSide.EAST));
            }
        }
        return tf;
    }

    private void treatEdges() {
        int i = 0;
        while (i < this.nodes.size()) {
            int j = i + 1;
            while (j < this.nodes.size()) {
                this.treatEdgesBetweenNodes(this.nodes.get(i), this.nodes.get(j));
                ++j;
            }
            ++i;
        }
    }

    private void treatEdgesBetweenNodes(LNode a, LNode b) {
        List<LEdge> edges = a.getEdgesConnectedWith(b);
        if (!edges.isEmpty()) {
            if (LayerBasedOnOrderProblem.areDummiesOfSameWideNode(a, b)) {
                this.treatEdgesBetweenDummiesOfSameWideNode(a, b, edges);
            } else {
                this.treatNormalEdgesBetweenNodes(a, b, edges);
            }
        }
    }

    private static boolean areDummiesOfSameWideNode(LNode a, LNode b) {
        return a.getType() == LNode.NodeType.WIDE_NODE && b.getType() == LNode.NodeType.WIDE_NODE && a.getOriginalWideNode().equals(b.getOriginalWideNode());
    }

    private void treatEdgesBetweenDummiesOfSameWideNode(LNode a, LNode b, List<LEdge> edges) {
        if (edges.get(0).getTargetNode().equals(b)) {
            this.treatEdgesBetweenDummiesOfSameWideNode(a, b);
        } else {
            this.treatEdgesBetweenDummiesOfSameWideNode(b, a);
        }
    }

    private void treatEdgesBetweenDummiesOfSameWideNode(LNode left, LNode right) {
        this.solver.diffHasToBe(this.getLayer(right), this.getLayer(left), 1.0);
    }

    private MPVariable getLayer(LNode node) {
        return this.nodeToLayerMap.get(node);
    }

    private void treatNormalEdgesBetweenNodes(LNode a, LNode b, List<LEdge> edges) {
        Map<EdgeDirection, List<LEdge>> edgesDividedByDirection = this.divideEdgesByDirection(edges);
        this.treatHorizontalEdges(edgesDividedByDirection.get((Object)EdgeDirection.HORIZONTAL), a, b);
        this.treatWestWestEdges(edgesDividedByDirection.get((Object)EdgeDirection.WEST_WEST));
        this.treatEastEastEdges(edgesDividedByDirection.get((Object)EdgeDirection.EAST_EAST));
    }

    private Map<EdgeDirection, List<LEdge>> divideEdgesByDirection(List<LEdge> edges) {
        Map<EdgeDirection, List<LEdge>> edgesDividedByDirection = edges.stream().collect(Collectors.groupingBy(LayerBasedOnOrderProblem::getEdgeDirection));
        EdgeDirection[] edgeDirectionArray = EdgeDirection.values();
        int n = edgeDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeDirection dir = edgeDirectionArray[n2];
            edgesDividedByDirection.putIfAbsent(dir, new ArrayList());
            ++n2;
        }
        return edgesDividedByDirection;
    }

    public static EdgeDirection getEdgeDirection(LEdge edge) {
        if (edge.isFromTo(PortSide.WEST, PortSide.WEST)) {
            return EdgeDirection.WEST_WEST;
        }
        if (edge.isFromTo(PortSide.EAST, PortSide.EAST)) {
            return EdgeDirection.EAST_EAST;
        }
        return EdgeDirection.HORIZONTAL;
    }

    private void treatHorizontalEdges(List<LEdge> edges, LNode a, LNode b) {
        if (!edges.isEmpty()) {
            if (this.leftFromDueToOrder(a, b)) {
                this.treatHorizontalEdgesBasedOnOrder(edges, a, b);
            } else if (this.leftFromDueToOrder(b, a)) {
                this.treatHorizontalEdgesBasedOnOrder(edges, b, a);
            } else {
                this.absNodeDistanceShouldBeShort(a, b, edges);
            }
        }
    }

    public boolean leftFromDueToOrder(LNode a, LNode b) {
        return this.layersOfNodesForOrder[this.nodes.indexOf(a)] < this.layersOfNodesForOrder[this.nodes.indexOf(b)];
    }

    private void treatHorizontalEdgesBasedOnOrder(List<LEdge> edges, LNode left, LNode right) {
        this.nodeDistanceShouldBeShort(left, right, edges);
    }

    private void nodeDistanceShouldBeShort(LNode left, LNode right, List<LEdge> edges) {
        MPVariable d = this.solver.makeDiffVar(this.getLayer(right), this.getLayer(left));
        d.setLb(1.0);
        double coeffForHorizontalNodeDistance = LayerBasedOnOrderProblem.getCoeffForHorizontalNodeDistance(left, right, edges);
        this.solver.setObjectiveCoeff(d, coeffForHorizontalNodeDistance);
    }

    private static double getCoeffForHorizontalNodeDistance(LNode a, LNode b, List<LEdge> edges) {
        return LayerBasedOnOrderProblem.getCoeffForSingleEdgeLength(a, b, edges) * LayerBasedOnOrderProblem.getMultiplierForMultipleEdges(edges);
    }

    private static double getCoeffForSingleEdgeLength(LNode a, LNode b, List<LEdge> edges) {
        double coeff = a.isSeparate() || b.isSeparate() ? 40.0 : 100.0;
        return coeff *= LayerBasedOnOrderProblem.getCoeffFactorForSingleEdgeToEndNode(a, b, edges);
    }

    private static double getCoeffFactorForSingleEdgeToEndNode(LNode a, LNode b, List<LEdge> edges) {
        if (LayerBasedOnOrderProblem.isEndNode(a) || LayerBasedOnOrderProblem.isEndNode(b)) {
            if (LayerBasedOnOrderProblem.isEndNode(a) && LayerBasedOnOrderProblem.endNodeIsConnectedToTopPort(a, b) || LayerBasedOnOrderProblem.isEndNode(b) && LayerBasedOnOrderProblem.endNodeIsConnectedToTopPort(b, a)) {
                return 100.0;
            }
            if (edges.stream().anyMatch(e -> e.getSource().labelWasRemovedByLabelMerger())) {
                return 5.0;
            }
            return 40.0;
        }
        return 1.0;
    }

    private static boolean isEndNode(LNode node) {
        return !node.isSeparate() && node.getTrueConnectedNodes().size() == 1;
    }

    private static boolean endNodeIsConnectedToTopPort(LNode endNode, LNode connectedNode) {
        return endNode.getTruePorts().stream().allMatch(p -> p.getConnectedPortsAsStream().allMatch(cp -> cp.getSide().equals((Object)PortSide.NORTH)));
    }

    private static double getMultiplierForMultipleEdges(List<LEdge> edges) {
        return edges.stream().map(e -> e.getSource()).distinct().count();
    }

    private void absNodeDistanceShouldBeShort(LNode a, LNode b, List<LEdge> edges) {
        MPVariable absDiff = this.solver.makeAbsDiffVar(this.getLayer(a), this.getLayer(b));
        this.solver.setObjectiveCoeff(absDiff, LayerBasedOnOrderProblem.getCoeffForHorizontalNodeDistance(a, b, edges));
    }

    private void treatWestWestEdges(List<LEdge> edges) {
        this.treatWestWestOrEastEastEdges(edges);
    }

    private void treatEastEastEdges(List<LEdge> edges) {
        this.treatWestWestOrEastEastEdges(edges);
    }

    private void treatWestWestOrEastEastEdges(List<LEdge> edges) {
        if (!edges.isEmpty()) {
            LNode sourceNode = edges.get(0).getSourceNode();
            LNode targetNode = edges.get(0).getTargetNode();
            if (!sourceNode.isSingleFlippedNodeInFeedbackLoop() && !targetNode.isSingleFlippedNodeInFeedbackLoop()) {
                MPVariable layerDiff = this.makeLayerDiffVar(targetNode, sourceNode);
                MPVariable absLayerDiff = this.solver.makeAbsVar(layerDiff);
                this.solver.setObjectiveCoeff(absLayerDiff, LayerBasedOnOrderProblem.getMultiplierForMultipleEdges(edges) * 100.0);
            }
        }
    }

    private MPVariable makeLayerDiffVar(LNode a, LNode b) {
        return this.solver.makeDiffVar(this.getLayer(a), this.getLayer(b));
    }

    private void treatSeparateConstraints() {
        List<LNode> firstSeparateNodes = this.getNodesWith(LNode::isFirstSeparate);
        List<LNode> lastSeparateNodes = this.getNodesWith(LNode::isLastSeparate);
        List<LNode> otherNodes = this.getNodesWith(n -> !n.isSeparate());
        this.setLayerBoundsBasedOnSeparateConstraints(firstSeparateNodes, lastSeparateNodes, otherNodes);
        if (!otherNodes.isEmpty() && !lastSeparateNodes.isEmpty()) {
            MPVariable maxLayerOfOtherNodes = this.makeMaxLayerOfNodesVar(otherNodes, "maxLayerOfOtherNodes");
            lastSeparateNodes.forEach(n -> this.solver.diffHasToBe(this.getLayer((LNode)n), maxLayerOfOtherNodes, 1.0));
        }
    }

    private List<LNode> getNodesWith(Predicate<LNode> p) {
        return this.nodes.stream().filter(p).collect(Collectors.toList());
    }

    private void setLayerBoundsBasedOnSeparateConstraints(List<LNode> firstSeparateNodes, List<LNode> lastSeparateNodes, List<LNode> otherNodes) {
        this.setLayerBounds(firstSeparateNodes, 0.0, 0.0);
        double lowerBoundOfOtherNodes = !firstSeparateNodes.isEmpty() ? 1 : 0;
        double upperBoundOfOtherNodes = (double)otherNodes.size() + lowerBoundOfOtherNodes - 1.0;
        this.setLayerBounds(otherNodes, lowerBoundOfOtherNodes, upperBoundOfOtherNodes);
        double lowerBoundOfLastSeparateNodes = otherNodes.isEmpty() ? lowerBoundOfOtherNodes : lowerBoundOfOtherNodes + 1.0;
        double upperBoundOfLastSeparateNodes = otherNodes.isEmpty() ? lowerBoundOfOtherNodes : upperBoundOfOtherNodes + 1.0;
        this.setLayerBounds(lastSeparateNodes, lowerBoundOfLastSeparateNodes, upperBoundOfLastSeparateNodes);
    }

    private void setLayerBounds(List<LNode> givenNodes, double lowerBound, double upperBound) {
        givenNodes.forEach(n -> this.getLayer((LNode)n).setBounds(lowerBound, upperBound));
    }

    public MPVariable makeMaxLayerOfNodesVar(List<LNode> givenNodes, String name) {
        return this.makeMaxMinLayerOfNodesVar(givenNodes, name, true);
    }

    public MPVariable makeMinLayerOfNodesVar(List<LNode> givenNodes, String name) {
        return this.makeMaxMinLayerOfNodesVar(givenNodes, name, false);
    }

    private MPVariable makeMaxMinLayerOfNodesVar(List<LNode> givenNodes, String name, boolean max) {
        Stream<LNode> nodesThatCanBeInMaxMinLayer = givenNodes.stream().filter(n -> this.nodeCanBeInMaxMinLayer((LNode)n, givenNodes, max));
        List<MPVariable> layersOfNodesThatCanBeInMaxMinLayer = nodesThatCanBeInMaxMinLayer.map(n -> this.getLayer((LNode)n)).collect(Collectors.toList());
        return max ? this.solver.makeMaxVar(layersOfNodesThatCanBeInMaxMinLayer, name) : this.solver.makeMinVar(layersOfNodesThatCanBeInMaxMinLayer, name);
    }

    private boolean nodeCanBeInMaxMinLayer(LNode node, List<LNode> givenNodes, boolean max) {
        for (LNode otherNode : givenNodes) {
            boolean areConnectedByHorizontalEdge = node.getEdgesConnectedWith(otherNode).stream().anyMatch(e -> LayerBasedOnOrderProblem.getEdgeDirection(e).equals((Object)EdgeDirection.HORIZONTAL));
            if (!areConnectedByHorizontalEdge || (!max || !this.leftFromDueToOrder(node, otherNode)) && (max || !this.leftFromDueToOrder(otherNode, node))) continue;
            return false;
        }
        return true;
    }

    private void treatSatelliteAndBaseNodes() {
        this.satelliteAndBaseNodesConstraints = new SatelliteAndBaseNodesConstraints(this, this.nodes);
    }

    private void treatSingleFlippedNodesInFeedbackLoops() {
        this.getNodesWith(n -> n.isSingleFlippedNodeInFeedbackLoop()).forEach(n -> this.treatSingleFlippedNodeInFeedbackLoops((LNode)n));
    }

    private void treatSingleFlippedNodeInFeedbackLoops(LNode node) {
        this.singleFlippedNodeShouldBeAsCentralAsPossible(node);
        this.singleFlippedNodeShouldNotBeToTheLeftOfItsTargetNodes(node);
        this.singleFlippedNodeShouldNotBeToTheRightOfItsSourceNodes(node);
        this.inEdgesOfSingleFlippedNodeShouldBeShort(node);
        this.outEdgesOfSingleFlippedNodeShouldBeShort(node);
    }

    private void singleFlippedNodeShouldBeAsCentralAsPossible(LNode node) {
        if (node.equals(node.getMiddleOfNonLabelOfWideNodes())) {
            MPVariable maxDiffToSourceNodes = this.makeMaxLayerDiffToSourceNodesOfFlippedNodeVar(node);
            MPVariable maxDiffToTargetNodes = this.makeMaxLayerDiffToTargetNodesOfFlippedNodeVar(node);
            MPVariable diffOfRightLeftDiffWithTieBreaker = this.solver.makeIntVar(-2 * this.nodes.size(), 2 * this.nodes.size(), "flippedNodeDiffRightLeftWithTieBreaker_" + node);
            MPConstraint c = this.solver.makeConstraint(-1.0, -1.0);
            c.setCoefficient(diffOfRightLeftDiffWithTieBreaker, 1.0);
            c.setCoefficient(maxDiffToTargetNodes, -2.0);
            c.setCoefficient(maxDiffToSourceNodes, 2.0);
            MPVariable absDiffOfRightLeftDiffWithTieBreaker = this.solver.makeAbsVar(diffOfRightLeftDiffWithTieBreaker);
            this.solver.setObjectiveCoeff(absDiffOfRightLeftDiffWithTieBreaker, 20.0);
        }
    }

    private MPVariable makeMaxLayerDiffToSourceNodesOfFlippedNodeVar(LNode flippedNode) {
        List<LNode> sourceNodes = flippedNode.getLastWideNodeDummy().getTrueSourceNodes();
        List<MPVariable> diffsToSourceNodes = sourceNodes.stream().map(sourceNode -> this.makeLayerDiffVar((LNode)sourceNode, flippedNode)).collect(Collectors.toList());
        return this.solver.makeMaxVar(diffsToSourceNodes, "maxDiffToSourceNodesOfFlippedNode_" + flippedNode);
    }

    private MPVariable makeMaxLayerDiffToTargetNodesOfFlippedNodeVar(LNode flippedNode) {
        List<LNode> targetNodes = flippedNode.getFirstWideNodeDummy().getTrueTargetNodes();
        List<MPVariable> diffsToTargetNNodes = targetNodes.stream().map(targetNode -> this.makeLayerDiffVar(flippedNode, (LNode)targetNode)).collect(Collectors.toList());
        return this.solver.makeMaxVar(diffsToTargetNNodes, "maxDiffToTargetNodesOfFlippedNode_" + flippedNode);
    }

    private void singleFlippedNodeShouldNotBeToTheLeftOfItsTargetNodes(LNode node) {
        if (node.equals(node.getFirstNonLabelOfWideNodes())) {
            MPVariable maxTargetLayer = this.makeMaxLayerOfNodesVar(node.getTrueTargetNodes(), "flippedNodeMaxTargetLayer_" + node);
            MPVariable diffMaxTargetLayerToNode = this.solver.makeDiffVar(maxTargetLayer, this.getLayer(node));
            MPVariable posDiffMaxTargetLayerToNode = this.solver.makePosVar(diffMaxTargetLayerToNode);
            this.solver.setObjectiveCoeff(posDiffMaxTargetLayerToNode, 20000.0);
        }
    }

    private void singleFlippedNodeShouldNotBeToTheRightOfItsSourceNodes(LNode node) {
        if (node.equals(node.getLastNonLabelWideNodeDummy())) {
            MPVariable minSourceLayer = this.makeMinLayerOfNodesVar(node.getTrueSourceNodes(), "flippedNodeMinSourceLayer_" + node);
            MPVariable diffNodeToMinSourceLayer = this.solver.makeDiffVar(this.getLayer(node), minSourceLayer);
            MPVariable posDiffNodeToMinSourceLayer = this.solver.makePosVar(diffNodeToMinSourceLayer);
            this.solver.setObjectiveCoeff(posDiffNodeToMinSourceLayer, 10000.0);
        }
    }

    private void inEdgesOfSingleFlippedNodeShouldBeShort(LNode node) {
        if (node.equals(node.getLastWideNodeDummy())) {
            MPVariable maxLayerOfSourceNodes = this.makeMaxLayerOfNodesVar(node.getTrueSourceNodes(), "maxLayerOfSourceNodesOf_" + node);
            MPVariable maxAbsDiffToSourceNodes = this.solver.makeAbsDiffVar(maxLayerOfSourceNodes, this.getLayer(node));
            this.solver.setObjectiveCoeff(maxAbsDiffToSourceNodes, 100.0);
        }
    }

    private void outEdgesOfSingleFlippedNodeShouldBeShort(LNode node) {
        if (node.equals(node.getFirstWideNodeDummy())) {
            MPVariable minLayerOfTargetNodes = this.makeMinLayerOfNodesVar(node.getTrueTargetNodes(), "minLayerOfTargetNodesOf_" + node);
            MPVariable maxAbsDiffToTargetNodes = this.solver.makeAbsDiffVar(minLayerOfTargetNodes, this.getLayer(node));
            this.solver.setObjectiveCoeff(maxAbsDiffToTargetNodes, 100.0);
        }
    }

    private void treatNodesWithSplitEdgesToFeedbackLoops() {
        this.nodes.forEach(n -> this.treatNodeWithSplitEdgesToFeedbackLoops((LNode)n));
    }

    private void treatNodeWithSplitEdgesToFeedbackLoops(LNode node) {
        for (LPort eastPort : node.getTruePorts(PortSide.EAST)) {
            this.avoidUTurnsInSplitEdgesToFeedbackLoop(eastPort);
        }
    }

    private void avoidUTurnsInSplitEdgesToFeedbackLoop(LPort eastPort) {
        List<LPort> connEastPorts = eastPort.getConnectedPorts(PortSide.EAST);
        List<LPort> connWestPorts = eastPort.getConnectedPorts(PortSide.WEST);
        for (LPort connEastPort : connEastPorts) {
            for (LPort connWestPort : connWestPorts) {
                if (connEastPort.isOnSameTrueNodeAs(connWestPort) || !connEastPort.isOnlyPortOnSide()) continue;
                List<LNode> leftSatellitesOrConnNode = this.getNodeOrLeftSatellitesIfAny(connWestPort.getNode());
                this.setLayeringConstraintToKeepAtLeastOneLayerGap(Lists.newArrayList((Object[])new LNode[]{connEastPort.getNode()}), leftSatellitesOrConnNode);
            }
        }
    }

    private List<LNode> getNodeOrLeftSatellitesIfAny(LNode connectedNode) {
        ArrayList leftSatellites = this.satelliteAndBaseNodesConstraints.getSatelliteNodesOnSide(connectedNode, PortSide.WEST);
        return leftSatellites.isEmpty() ? Lists.newArrayList((Object[])new LNode[]{connectedNode}) : leftSatellites;
    }

    public void setLayeringConstraintToKeepAtLeastOneLayerGap(List<LNode> leftNodesToKeepDistanceTo, List<LNode> rightNodesToKeepDistanceTo) {
        MPVariable maxLeftLayer = this.makeMaxLayerOfNodesVar(leftNodesToKeepDistanceTo.stream().map(n -> n.getLastWideNodeDummy()).collect(Collectors.toList()), "maxLeftLayerForSatDistance_" + leftNodesToKeepDistanceTo + "_to_" + rightNodesToKeepDistanceTo);
        MPVariable minRightLayer = this.makeMinLayerOfNodesVar(rightNodesToKeepDistanceTo.stream().map(n -> n.getFirstWideNodeDummy()).collect(Collectors.toList()), "minRightLayerForSatDistance_" + rightNodesToKeepDistanceTo + "_to_" + rightNodesToKeepDistanceTo);
        this.solver.diffHasToBeInRange(minRightLayer, maxLeftLayer, 1.0, this.nodes.size() - 1);
    }

    private void treatGotoFromNodes() {
        for (LNode a : this.nodes) {
            for (LNode b : this.nodes) {
                if (!a.isLastGotoWideNodeDummyWithFirstFromWideNodeDummy(b)) continue;
                this.treatGotoFromPair(a, b);
            }
        }
    }

    private void treatGotoFromPair(LNode gotoNode, LNode fromNode) {
        if (this.leftFromDueToOrder(gotoNode, fromNode)) {
            this.layerDiffHasToBeInRange(fromNode, gotoNode, 1.0, this.nodes.size() - 1);
        }
    }

    private void layerDiffHasToBeInRange(LNode a, LNode b, double lb, double ub) {
        this.solver.diffHasToBeInRange(this.getLayer(a), this.getLayer(b), lb, ub);
    }

    private void layersShouldStartAtZero() {
        this.nodes.forEach(n -> this.solver.setObjectiveCoeff(this.getLayer((LNode)n), 1.0));
    }

    public static enum EdgeDirection {
        WEST_WEST,
        EAST_EAST,
        HORIZONTAL;

    }
}

