/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.ortools;

import com.google.ortools.sat.BoolVar;
import com.google.ortools.sat.Constraint;
import com.google.ortools.sat.CpModel;
import com.google.ortools.sat.CpSolver;
import com.google.ortools.sat.CpSolverStatus;
import com.google.ortools.sat.IntVar;
import com.google.ortools.sat.LinearArgument;
import com.google.ortools.sat.LinearExpr;
import com.google.ortools.sat.Literal;
import com.google.ortools.sat.SatParameters;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.ortools.OrToolsLibLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class CpSolverWrapper {
    private static final int RANDOM_SEED = 42;
    private CpModel cpModel;
    private CpSolver solver;
    private CpSolverStatus solverStatus;
    private List<IntVar> vars = new ArrayList<IntVar>();
    private List<LinearArgument> objectiveFactors = new ArrayList<LinearArgument>();
    private List<Long> objectiveCoeffs = new ArrayList<Long>();
    private BoolVar trueBool;
    private BoolVar falseBool;

    public CpSolverWrapper() {
        OrToolsLibLoader.loadLibrary();
        this.cpModel = new CpModel();
        this.solver = new CpSolver();
        this.trueBool = this.getBoolThatIsSetTo(1L);
        this.falseBool = this.getBoolThatIsSetTo(0L);
    }

    private BoolVar getBoolThatIsSetTo(long value) {
        BoolVar boolVar = this.newBoolVar("Bool_set_to : " + value);
        this.cpModel.addEquality((LinearArgument)boolVar, value);
        return boolVar;
    }

    public BoolVar getTrue() {
        return this.trueBool;
    }

    public BoolVar getFalse() {
        return this.falseBool;
    }

    public SatParameters.Builder getParameters() {
        return this.solver.getParameters();
    }

    public void minimize() throws InterruptedException {
        this.solver.getParameters().setRandomSeed(42);
        this.cpModel.minimize(this.getObjective());
        MesUtilMethods.runAsThreadWithInterruptHandling(() -> this.solve(), () -> this.solver.stopSearch());
        assert (this.solverStatus == CpSolverStatus.OPTIMAL);
    }

    private void solve() {
        this.solverStatus = this.solver.solve(this.cpModel);
    }

    public CpSolverStatus getResponseStatus() {
        return this.solver.response().getStatus();
    }

    public long getValue(LinearArgument arg) {
        return this.solver.value(arg);
    }

    public boolean getBooleanValue(Literal bool) {
        return this.solver.booleanValue(bool);
    }

    private LinearArgument getObjective() {
        LinearArgument[] factors = (LinearArgument[])this.objectiveFactors.stream().toArray(LinearArgument[]::new);
        long[] coeffs = this.objectiveCoeffs.stream().mapToLong(Long::longValue).toArray();
        return LinearExpr.weightedSum(factors, coeffs);
    }

    public void addObjectiveFactors(List<Literal> factors, List<Long> coeffs) {
        int ix = 0;
        while (ix < factors.size()) {
            this.addObjectiveFactor(factors.get(ix), coeffs.get(ix));
            ++ix;
        }
    }

    public void addObjectiveFactor(LinearArgument factor, long coeff) {
        this.objectiveFactors.add(factor);
        this.objectiveCoeffs.add(coeff);
    }

    public IntVar newIntVar(long lb, long ub, String name) {
        IntVar v = this.cpModel.newIntVar(lb, ub, name);
        this.vars.add(v);
        return v;
    }

    public BoolVar newBoolVar(String name) {
        BoolVar v = this.cpModel.newBoolVar(name);
        this.vars.add(v);
        return v;
    }

    public BoolVar xor(Literal a, Literal b) {
        BoolVar xOr = this.cpModel.newBoolVar(String.valueOf(a.toString()) + "_Xor_" + b.toString());
        this.cpModel.addBoolOr(new Literal[]{a, b}).onlyEnforceIf(xOr);
        this.cpModel.addDifferent((LinearArgument)a, b).onlyEnforceIf(xOr);
        this.cpModel.addEquality((LinearArgument)a, b).onlyEnforceIf(xOr.not());
        return xOr;
    }

    public Literal and(Literal a, Literal b) {
        String name = String.valueOf(a.toString()) + "_And_" + b.toString();
        return this.and(new Literal[]{a, b}, name);
    }

    public BoolVar and(Literal[] literals, String name) {
        BoolVar and = this.cpModel.newBoolVar(name);
        this.cpModel.addBoolAnd(literals).onlyEnforceIf(and);
        Literal[] negatedBools = (Literal[])Arrays.stream(literals).map(Literal::not).toArray(Literal[]::new);
        this.cpModel.addBoolOr(negatedBools).onlyEnforceIf(and.not());
        return and;
    }

    public IntVar minus(IntVar a, IntVar b) {
        long lowerBound = a.getDomain().min() - b.getDomain().max();
        long upperBound = a.getDomain().max() - b.getDomain().min();
        IntVar m = this.newIntVar(lowerBound, upperBound, a + " - " + b);
        this.cpModel.addEquality((LinearArgument)m, CpSolverWrapper.minusFast(a, b));
        return m;
    }

    public static LinearExpr minusFast(LinearArgument a, LinearArgument b) {
        return LinearExpr.weightedSum(new LinearArgument[]{a, b}, new long[]{1L, -1L});
    }

    public static LinearExpr neg(LinearExpr a) {
        return LinearExpr.term(a, -1L);
    }

    public void addOr(List<Literal> literals) {
        this.addOr(literals.toArray(new Literal[0]));
    }

    public void addOr(Literal[] literals) {
        this.cpModel.addBoolOr(literals);
    }

    public void addEquality(Literal a, Literal b) {
        this.cpModel.addEquality((LinearArgument)a, b);
    }

    public void addEquality(Literal a, long b) {
        this.cpModel.addEquality((LinearArgument)a, b);
    }

    public void addEquality(LinearArgument a, LinearArgument b) {
        this.cpModel.addEquality(a, b);
    }

    public void addImplication(Literal a, Literal b) {
        this.cpModel.addImplication(a, b);
    }

    public Constraint addGreaterOrEqual(LinearArgument a, long b) {
        return this.cpModel.addGreaterOrEqual(a, b);
    }

    public Constraint addGreaterOrEqual(LinearArgument a, LinearArgument b) {
        return this.cpModel.addGreaterOrEqual(a, b);
    }

    public Constraint addLessOrEqual(LinearArgument a, long b) {
        return this.cpModel.addLessOrEqual(a, b);
    }

    public BoolVar isGreater(IntVar a, IntVar b) {
        BoolVar isGreater = this.newBoolVar(a + " > " + b);
        this.cpModel.addGreaterThan((LinearArgument)a, b).onlyEnforceIf(isGreater);
        this.cpModel.addLessOrEqual((LinearArgument)a, b).onlyEnforceIf(isGreater.not());
        return isGreater;
    }

    public BoolVar isEqual(LinearArgument var1, LinearArgument var2) {
        BoolVar isEqual = this.newBoolVar(String.valueOf(var1.toString()) + " == " + var2.toString());
        this.cpModel.addEquality(var1, var2).onlyEnforceIf(isEqual);
        this.cpModel.addDifferent(var1, var2).onlyEnforceIf(isEqual.not());
        return isEqual;
    }

    public IntVar[] splitIntoPositiveAndNegative(IntVar x) {
        long upperBound = Math.max(Math.abs(x.getDomain().min()), Math.abs(x.getDomain().max()));
        IntVar pos = this.newIntVar(0L, upperBound, "pos(" + x + ")");
        IntVar neg = this.newIntVar(0L, upperBound, "neg(" + x + ")");
        this.cpModel.addEquality((LinearArgument)x, CpSolverWrapper.minusFast(pos, neg));
        BoolVar isPositive = this.newBoolVar(x + " >= 0");
        this.cpModel.addEquality((LinearArgument)neg, 0L).onlyEnforceIf(isPositive);
        this.cpModel.addEquality((LinearArgument)pos, 0L).onlyEnforceIf(isPositive.not());
        return new IntVar[]{pos, neg};
    }

    public BoolVar shouldBeLessOrEqualBigM(LinearArgument a, LinearArgument b, long bigM, long coeff) {
        assert (coeff > 0L);
        BoolVar isGreater = this.newBoolVar(a + " > " + b);
        LinearExpr right = LinearExpr.weightedSum(new LinearArgument[]{b, isGreater}, new long[]{1L, bigM});
        this.cpModel.addLessOrEqual(a, right);
        this.addObjectiveFactor(isGreater, coeff);
        return isGreater;
    }

    public void shouldBeGreaterOrEqualFast(LinearArgument a, long b, long coeff) {
        assert (coeff > 0L);
        BoolVar isLess = this.newBoolVar(a + " < " + b);
        this.cpModel.addGreaterOrEqual(a, b).onlyEnforceIf(isLess.not());
        this.addObjectiveFactor(isLess, coeff);
    }

    public BoolVar shouldBeLessOrEqualFast(LinearArgument a, long b, long coeff) {
        return this.shouldBeLessOrEqualFast(a, LinearExpr.constant(b), coeff);
    }

    public BoolVar shouldBeLessOrEqualFast(LinearArgument a, LinearArgument b, long coeff) {
        assert (coeff > 0L);
        BoolVar isGreater = this.newBoolVar(a + " > " + b);
        this.cpModel.addLessOrEqual(a, b).onlyEnforceIf(isGreater.not());
        this.addObjectiveFactor(isGreater, coeff);
        return isGreater;
    }

    public void absDiffShouldBeSmall(IntVar x, IntVar y, long coeff) {
        long max = Math.max(Math.abs(x.getDomain().max() - y.getDomain().min()), Math.abs(y.getDomain().max() - x.getDomain().min()));
        IntVar p = this.newIntVar(0L, max, "|" + x.getName() + " - " + y.getName() + "|");
        this.addGreaterOrEqual((LinearArgument)p, CpSolverWrapper.minusFast(x, y));
        this.addGreaterOrEqual((LinearArgument)p, CpSolverWrapper.minusFast(y, x));
        this.addObjectiveFactor(p, coeff);
    }

    public void printVariables() {
        this.vars.sort(Comparator.comparing(v -> v.toString()));
        this.vars.forEach(v -> this.printVariable((LinearArgument)v));
    }

    private void printVariable(LinearArgument v) {
        System.out.println(String.format("%s = %s", v.toString(), this.solver.value(v)));
    }
}

