/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mesutils;

import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesGraphPropertiesConfigurator;
import com.modelengineers.MoRe_elk.alg.layered.options.LayerConstraint;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.options.Alignment;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.EdgeLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.properties.IPropertyHolder;
import java.util.List;
import java.util.stream.Collectors;

public final class MesElkGraphConfigurator {
    private MesElkGraphConfigurator() {
    }

    public static void configureElkGraph(ElkNode g, boolean isInteractiveMode, boolean adjustNodeHeights, boolean loggingEnabled) {
        MesElkGraphConfigurator.setElkGraphProperties(g, isInteractiveMode, adjustNodeHeights, loggingEnabled);
        MesElkGraphConfigurator.setNodeProperties(g, isInteractiveMode);
        MesElkGraphConfigurator.setEdgeLabelProperty(g);
    }

    private static void setElkGraphProperties(ElkNode g, boolean isInteractiveMode, boolean adjustNodeHeights, boolean loggingEnabled) {
        MesGraphPropertiesConfigurator.setGraphProperties(g, isInteractiveMode, adjustNodeHeights, loggingEnabled);
    }

    private static void setNodeProperties(ElkNode g, boolean isInteractiveMode) {
        for (ElkNode n : g.getChildren()) {
            n.setProperty(CoreOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
            MesElkGraphConfigurator.setNodeLayerConstraint(n, isInteractiveMode);
            MesElkGraphConfigurator.setNodeAlignmentForNode(n, isInteractiveMode);
        }
    }

    private static void setNodeAlignmentForNode(ElkNode n, boolean isInteractiveMode) {
        Alignment alignment = MesElkGraphConfigurator.getNodeAlignmentForBlock(n, isInteractiveMode);
        n.setProperty(LayeredOptions.ALIGNMENT, alignment);
    }

    private static Alignment getNodeAlignmentForBlock(ElkNode n, boolean isInteractiveMode) {
        Alignment alignment = !isInteractiveMode && n.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.FIRST_SEPARATE ? Alignment.LEFT : (!isInteractiveMode && n.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.LAST_SEPARATE ? Alignment.RIGHT : MesElkGraphConfigurator.getAlignmentForNonInOrOutportBlocks(n));
        return alignment;
    }

    private static String getBlockType(ElkNode n) {
        String blockType = n.getProperty(CoreOptions.MES_BLOCK_PARAMETERS_MAP).getMap().get("BlockType");
        if (blockType == null) {
            blockType = "";
        }
        return blockType;
    }

    private static Alignment getAlignmentForNonInOrOutportBlocks(ElkNode n) {
        Alignment alignment = MesElkGraphConfigurator.getPortsOnWestSide(n).isEmpty() && MesElkGraphConfigurator.getPortsOnNorthSide(n).isEmpty() && !MesElkGraphConfigurator.getPortsOnEastSide(n).isEmpty() ? Alignment.RIGHT : Alignment.LEFT;
        return alignment;
    }

    private static List<ElkPort> getPortsOnWestSide(ElkNode n) {
        return n.getPorts().stream().filter(p -> p.getX() <= 0.0).collect(Collectors.toList());
    }

    private static List<ElkPort> getPortsOnNorthSide(ElkNode n) {
        return n.getPorts().stream().filter(p -> p.getY() <= 0.0).collect(Collectors.toList());
    }

    private static List<ElkPort> getPortsOnEastSide(ElkNode n) {
        return n.getPorts().stream().filter(p -> p.getX() >= n.getWidth()).collect(Collectors.toList());
    }

    private static void setNodeLayerConstraint(ElkNode n, boolean isInteractiveMode) {
        LayerConstraint layerConstraint = MesElkGraphConfigurator.getNodeLayerConstraint(n, isInteractiveMode);
        if (!layerConstraint.equals((Object)LayerConstraint.NONE)) {
            n.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, layerConstraint);
        }
    }

    private static LayerConstraint getNodeLayerConstraint(ElkNode n, boolean isInteractiveMode) {
        LayerConstraint layerConstraint = LayerConstraint.NONE;
        String blockType = MesElkGraphConfigurator.getBlockType(n);
        if (!isInteractiveMode) {
            if (blockType.equals("Inport") || blockType.equals("InportShadow")) {
                layerConstraint = MesElkGraphConfigurator.hasPortOnLeftSide(n) ? LayerConstraint.LAST_SEPARATE : LayerConstraint.FIRST_SEPARATE;
            } else if (blockType.equals("Outport")) {
                layerConstraint = MesElkGraphConfigurator.hasPortOnRightSide(n) ? LayerConstraint.FIRST_SEPARATE : LayerConstraint.LAST_SEPARATE;
            }
        }
        return layerConstraint;
    }

    private static boolean hasPortOnLeftSide(ElkNode n) {
        return ((ElkPort)n.getPorts().get(0)).getX() <= 0.0;
    }

    private static boolean hasPortOnRightSide(ElkNode n) {
        return ((ElkPort)n.getPorts().get(0)).getX() >= n.getWidth();
    }

    private static void setEdgeLabelProperty(ElkNode g) {
        for (ElkEdge e : g.getContainedEdges()) {
            e.getLabels().forEach(l -> {
                IPropertyHolder iPropertyHolder = l.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, EdgeLabelPlacement.TAIL);
            });
        }
    }
}

