/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.graph.ElkNode;
import java.util.HashMap;
import java.util.Map;

public final class MaxAllowedRuntime {
    static final int ALLOWED_RUNTIME_COMPLEX = 100000;
    static final int ALLOWED_RUNTIME_SIMPLE = 1000;
    private static final int COMPLEX_GRAPH_BOUND = 300;
    private static final int SIMPLE_GRAPH_BOUND = 50;
    private static final Map<String, Integer> MAX_RUNTIMES = new HashMap<String, Integer>();

    static {
        MAX_RUNTIMES.put("ACTBC_Main_Fnc/IO_Control", 20000);
        MAX_RUNTIMES.put("AICF_A6_tl/FNC_AICF_A6/AICF_A6/Subsystem/AICF_A6", 50000);
        MAX_RUNTIMES.put("AICF_A6_tl/FNC_AICF_A6/AICF_A6/Subsystem/AICF_A6/AICF_A6_main/AICF_A6_input", 6000);
        MAX_RUNTIMES.put("APPSWC_Main_Fnc", 4000);
        MAX_RUNTIMES.put("CPX_function/CPX/Core_Logic", 6000);
        MAX_RUNTIMES.put("EMC_A6_tl/FNC_EMC_A6/EMC_A6/Subsystem/EMC_A6/EMC_A6_main/EMC_A6_input", 10000);
        MAX_RUNTIMES.put("eV_g_8442_VolumePrediction/FlowRateVolumePrediction/Subsystem/FlowRateVolumePrediction/FlowRate_and_Interpolated_Volume_Calculation", 8000);
        MAX_RUNTIMES.put("File_HSML_StrategicModeLogic/HSML_StrategicModeLogic/HSML_20ms/HSML_Prio_Uebergaenge/HSML_EngOff_Req_EDriveEngOn", 30000);
        MAX_RUNTIMES.put("File_HSML_StrategicModeLogic/HSML_StrategicModeLogic/HSML_20ms/HSML_Prio_Uebergaenge/HSML_HDriveCharg_Dis_EDriveEngOn", 12000);
        MAX_RUNTIMES.put("HeatPumpOperation", 80000);
        MAX_RUNTIMES.put("HP_Master/F_Funktionen/FHC_HybridControl/Subsystem/FHC_HybridControl/HCOML_OperatingModeLogic/HCSiProc_Signalprocessing_fcn/HCSiProc_Signalprocessing/Abbruchsteuerung/Abbruchsteuerung_NormalMode/Abbruchueberwachung/Dekodierung_Abbruchcodierung", 3000);
        MAX_RUNTIMES.put("HP_Master/F_Funktionen/FOp_OperativeFunktionen/Subsystem/FOp_OperativeFunktionen/OperativeFunktionen/FOpFcn/FOp_ANS/Action_FOp_ANS/FOp_Schleppstart/St_Ablauf", 50000);
        MAX_RUNTIMES.put("HP_Master/F_Funktionen/TL_FSBi_SignalBerechnung_in/Subsystem/TL_FSBi_SignalBerechnung_in/FSBi_SignalBerechnung_in/Bestimmung_Schaltart", 6000);
        MAX_RUNTIMES.put("lib_op_fct/Decoder_ui32", 4000);
        MAX_RUNTIMES.put("MitL", 20000);
        MAX_RUNTIMES.put("MitL/Controller/ECU_Outputs2/RAMt Data", 25000);
        MAX_RUNTIMES.put("MitL/Controller/PTC Control/10ms_Systems", 12000);
        MAX_RUNTIMES.put("MitL/Controller/ECU_Outputs2/RAMt Data", 40000);
        MAX_RUNTIMES.put("PWC_A5_tl/FNC_PWC_A5/PWC_A5/Subsystem/PWC_A5", 30000);
        MAX_RUNTIMES.put("PWC_A5_tl/FNC_PWC_A5/PWC_A5/Subsystem/PWC_A5/PWC_A5_main/PWC_A5_FCN/PWC_InputAdapter", 50000);
        MAX_RUNTIMES.put("PWC_function/PWC/UserLogic", 20000);
        MAX_RUNTIMES.put("PWC_function/PWC/ThermalProtection/Temperaturschaetzung", 2000);
        MAX_RUNTIMES.put("pos/pos_in_the_loop/pos/Subsystem/pos/POSITION_DETERMINATION/POS1/CFM_POS1/logicalPosition/Conditions/GB_Timeoutt", 4000);
        MAX_RUNTIMES.put("Stimulation_TPT/Stimulation/TPT-Umgebung/Subsystem1", 30000);
        MAX_RUNTIMES.put("testSplitEdges", 25000);
        MAX_RUNTIMES.put("testMaxAllowedRuntimeFromHardCodedList", 1234);
    }

    public static int determine(ElkNode graph) {
        int allowedRuntimeFromList = MaxAllowedRuntime.getAllowedRuntimeFromList(graph);
        return allowedRuntimeFromList > 0 ? allowedRuntimeFromList : MaxAllowedRuntime.interpolateMaxAllowedRuntime(graph);
    }

    private static int getAllowedRuntimeFromList(ElkNode graph) {
        String graphName = MaxAllowedRuntime.getName(graph);
        return MAX_RUNTIMES.getOrDefault(graphName, 0);
    }

    private static String getName(ElkNode graph) {
        String childIdentifier = ((ElkNode)graph.getChildren().get(0)).getIdentifier();
        int lastIndexOfLastSlash = childIdentifier.lastIndexOf("/");
        return childIdentifier.substring(0, lastIndexOfLastSlash);
    }

    private static int interpolateMaxAllowedRuntime(ElkNode graph) {
        int complexity = MaxAllowedRuntime.getComplexity(graph);
        return MaxAllowedRuntime.getAllowedRuntime(complexity);
    }

    private static int getComplexity(ElkNode graph) {
        int numOfEdges = graph.getContainedEdges().size();
        int numOfNodes = graph.getChildren().size();
        return numOfEdges + numOfNodes;
    }

    private static int getAllowedRuntime(int complexity) {
        if (complexity <= 50) {
            return 1000;
        }
        if (complexity > 300) {
            return 100000;
        }
        return 396 * (complexity - 50) + 1000;
    }

    private MaxAllowedRuntime() {
    }
}

