/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkLabel;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LargeVerticalGaps {
    private static final int MAX_Y_GAP_ALLOWED = 40;
    private ElkNode graph;

    public LargeVerticalGaps(ElkNode graph) {
        this.graph = graph;
    }

    public boolean found() {
        return this.getMaxYGap() > 40.0;
    }

    private double getMaxYGap() {
        Stream<Interval> intervals = this.getYIntervalsOfNodesAndEdges();
        List<Interval> intervalsSorted = LargeVerticalGaps.sortByStart(intervals);
        return LargeVerticalGaps.getMaxGap(intervalsSorted);
    }

    private Stream<Interval> getYIntervalsOfNodesAndEdges() {
        return Stream.concat(this.getYIntervalsOfNodes(), this.getYIntervalsOfEdges());
    }

    private Stream<Interval> getYIntervalsOfNodes() {
        return this.graph.getChildren().stream().map(n -> this.getYIntervalOfNode((ElkNode)n));
    }

    private Interval getYIntervalOfNode(ElkNode node) {
        double start = node.getY();
        double end = start + node.getHeight();
        if (!node.getLabels().isEmpty()) {
            ElkLabel label = (ElkLabel)node.getLabels().get(0);
            double labelStart = start + label.getY();
            double labelEnd = labelStart + label.getHeight();
            start = Math.min(start, labelStart);
            end = Math.max(end, labelEnd);
        }
        return new Interval(start, end);
    }

    private Stream<Interval> getYIntervalsOfEdges() {
        return this.graph.getContainedEdges().stream().map(e -> this.getYIntervalOfEdge((ElkEdge)e));
    }

    private Interval getYIntervalOfEdge(ElkEdge edge) {
        KVectorChain points = ElkUtil.getPointsOfEdge(edge);
        List pointsY = points.stream().map(p -> p.y).collect(Collectors.toList());
        double start = (Double)Collections.min(pointsY);
        double end = (Double)Collections.max(pointsY);
        return new Interval(start, end);
    }

    private static List<Interval> sortByStart(Stream<Interval> intervals) {
        return intervals.sorted(Comparator.comparingDouble(i -> ((Interval)i).start)).collect(Collectors.toList());
    }

    private static double getMaxGap(List<Interval> sortedIntervals) {
        double maxGap = 0.0;
        double currentEnd = sortedIntervals.get(0).end;
        int ixNext = 1;
        while (ixNext < sortedIntervals.size()) {
            Interval next = sortedIntervals.get(ixNext);
            maxGap = Math.max(maxGap, next.start - currentEnd);
            currentEnd = Math.max(currentEnd, next.end);
            ++ixNext;
        }
        return maxGap;
    }

    class Interval {
        private double start;
        private double end;

        Interval(double start, double end) {
            this.start = start;
            this.end = end;
        }
    }
}

