/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public final class EnsureSameGraphVersionOfJsonFiles {
    public static final String IMPORT_VERSION_STRING = "GraphVersionChecksum";
    public static final String NO_VERSION_INFO_ERROR = "File does not have graph version info: ";
    public static final String DIFF_VERSION_INFO_ERROR = "Graph version info of the file differs from that of the previous files: ";

    private EnsureSameGraphVersionOfJsonFiles() {
    }

    public static String getErrorMsgForFileWithDiffVerOrInvalidVer(String fullPathToTopDir) throws FileNotFoundException {
        return EnsureSameGraphVersionOfJsonFiles.getErrorMsgForFileWithDiffVerOrInvalidVer(fullPathToTopDir, false);
    }

    public static String getErrorMsgForFileWithDiffVerOrInvalidVer(String fullPathToTopDir, boolean isTestRun) throws FileNotFoundException {
        List<File> files = EnsureSameGraphVersionOfJsonFiles.getFiles(fullPathToTopDir, isTestRun);
        return EnsureSameGraphVersionOfJsonFiles.checkGraphVersion(files);
    }

    private static List<File> getFiles(String fullPathToTopDir, boolean isTestRun) {
        FileCollector fileCollector = EnsureSameGraphVersionOfJsonFiles.getFileCollector(isTestRun);
        return fileCollector.collect(fullPathToTopDir);
    }

    private static FileCollector getFileCollector(boolean isTestRun) {
        if (isTestRun) {
            return new FileCollector(".tson");
        }
        return new FileCollector(".json");
    }

    private static String checkGraphVersion(List<File> files) throws FileNotFoundException {
        String graphVersion = EnsureSameGraphVersionOfJsonFiles.getGraphVersion(files.get(0));
        for (File file : files) {
            if (EnsureSameGraphVersionOfJsonFiles.getGraphVersion(file) == null) {
                return NO_VERSION_INFO_ERROR + file.getAbsolutePath();
            }
            if (graphVersion.equals(EnsureSameGraphVersionOfJsonFiles.getGraphVersion(file))) continue;
            return DIFF_VERSION_INFO_ERROR + file.getAbsolutePath();
        }
        return null;
    }

    private static String getGraphVersion(File file) throws FileNotFoundException {
        Scanner sc = new Scanner(file);
        String graphVersion = null;
        while (sc.hasNextLine() && graphVersion == null) {
            String line = sc.nextLine();
            if (!line.contains(IMPORT_VERSION_STRING)) continue;
            graphVersion = EnsureSameGraphVersionOfJsonFiles.getGraphVersion(line);
        }
        sc.close();
        return graphVersion;
    }

    private static String getGraphVersion(String line) {
        return line.substring(line.indexOf(":"));
    }

    private static class FileCollector {
        private String fileExtension;

        FileCollector(String fileExtension) {
            this.fileExtension = fileExtension;
        }

        private List<File> collect(String fullPathToTopDir) {
            File topDir = new File(fullPathToTopDir);
            ArrayList fileList = Lists.newArrayList();
            this.fetchFilesRecursively(topDir, fileList);
            return fileList;
        }

        private void fetchFilesRecursively(File dir, List<File> fileList) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            fileList.addAll(this.getFilesInDir(dir));
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.fetchFilesRecursively(file, fileList);
                }
                ++n2;
            }
        }

        private List<File> getFilesInDir(File dir) {
            Object[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(fileExtension);
                }
            });
            return Lists.newArrayList((Object[])files);
        }
    }
}

