/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import java.util.List;
import java.util.stream.Collectors;

public class EastWestPortsNotOnSimulinkGrid {
    private static final int SIMULINK_Y_PORT_GRID_DISTANCE = 5;
    private ElkNode graph;

    public EastWestPortsNotOnSimulinkGrid(ElkNode graph) {
        this.graph = graph;
    }

    public boolean found() {
        List<ElkPort> eastWestPorts = this.getEastWestPorts();
        return eastWestPorts.stream().anyMatch(p -> !EastWestPortsNotOnSimulinkGrid.yDiffIsMultipleOfSimulinkYPortGridDistance(p, (ElkPort)eastWestPorts.get(0)));
    }

    private List<ElkPort> getEastWestPorts() {
        return this.graph.getChildren().stream().flatMap(n -> n.getPorts().stream()).filter(p -> EastWestPortsNotOnSimulinkGrid.isEastWestPort(p)).collect(Collectors.toList());
    }

    private static boolean isEastWestPort(ElkPort port) {
        return port.getX() <= 0.0 || port.getX() >= port.getParent().getWidth();
    }

    private static boolean yDiffIsMultipleOfSimulinkYPortGridDistance(ElkPort port1, ElkPort port2) {
        double yDiff = EastWestPortsNotOnSimulinkGrid.getAbsY(port1) - EastWestPortsNotOnSimulinkGrid.getAbsY(port2);
        return yDiff % 5.0 == 0.0;
    }

    private static double getAbsY(ElkPort port) {
        return port.getY() + port.getParent().getY();
    }
}

