/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import java.util.List;

public final class AntiClockwiseEdges {
    private ElkNode graph;
    private static final int TRIPLE = 3;

    public AntiClockwiseEdges(ElkNode graphToTest) {
        this.graph = graphToTest;
    }

    public boolean containsAntiClockWiseEdge() {
        return this.graph.getContainedEdges().stream().anyMatch(e -> this.isAntiClockwise((ElkEdge)e));
    }

    private boolean isAntiClockwise(ElkEdge edge) {
        List<ElkUtil.Segment> segmentsOfEdge = ElkUtil.getSegments(edge);
        if (segmentsOfEdge.size() < 3) {
            return false;
        }
        int i = 0;
        while (i <= segmentsOfEdge.size() - 3) {
            List<ElkUtil.Segment> tripleOfSegments = segmentsOfEdge.subList(i, i + 3);
            if (this.isAntiClockwise(tripleOfSegments)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isAntiClockwise(List<ElkUtil.Segment> triple) {
        return triple.get(0).runsLeftwards() && triple.get(1).runsDownwards() && triple.get(2).runsRightwards() || triple.get(0).runsRightwards() && triple.get(1).runsUpwards() && triple.get(2).runsLeftwards();
    }
}

