/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting.LabelMerger;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting.WideNodeSplitter;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public final class WideNodePreProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Wide node preprocessing", 1.0f);
        layeredGraph.getLayerlessNodes().forEach(n -> new LabelMerger((LNode)n).mergeLabelsWithNode());
        new WideNodeSplitter(layeredGraph).splitNodes();
        assert (this.noSplittableWideNodesRemaining(layeredGraph));
        monitor.done();
    }

    private boolean noSplittableWideNodesRemaining(LGraph lGraph) {
        WideNodeSplitter wideNodeSplitter = new WideNodeSplitter(lGraph);
        return !lGraph.getLayerlessNodes().stream().anyMatch(node -> wideNodeSplitter.isSplittableWideNode((LNode)node));
    }
}

