/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.loops;

import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.Set;

public enum SelfLoopType {
    ONE_SIDE,
    TWO_SIDES_CORNER,
    TWO_SIDES_OPPOSING,
    THREE_SIDES,
    FOUR_SIDES;


    public static SelfLoopType fromPortSides(Set<PortSide> portSides) {
        if (portSides.contains((Object)PortSide.UNDEFINED)) {
            throw new IllegalArgumentException("Port sides must not contain UNDEFINED");
        }
        switch (portSides.size()) {
            case 1: {
                return ONE_SIDE;
            }
            case 2: {
                boolean northSouth;
                boolean eastWest = portSides.contains((Object)PortSide.EAST) && portSides.contains((Object)PortSide.WEST);
                boolean bl = northSouth = portSides.contains((Object)PortSide.NORTH) && portSides.contains((Object)PortSide.SOUTH);
                if (eastWest || northSouth) {
                    return TWO_SIDES_OPPOSING;
                }
                return TWO_SIDES_CORNER;
            }
            case 3: {
                return THREE_SIDES;
            }
            case 4: {
                return FOUR_SIDES;
            }
        }
        return null;
    }
}

