/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.loops;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfHyperLoop;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopEdge;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;

public final class SelfLoopHolder {
    private final LNode lNode;
    private final List<SelfHyperLoop> slHyperLoops = new ArrayList<SelfHyperLoop>();
    private final Map<LPort, SelfLoopPort> slPorts = new LinkedHashMap<LPort, SelfLoopPort>();
    private boolean arePortsHidden = false;
    private int[] routingSlotCount = new int[PortSide.values().length];
    private static final int UNVISITED = 0;
    private static final int VISITED = 1;

    private SelfLoopHolder(LNode node) {
        this.lNode = node;
    }

    public static SelfLoopHolder install(LNode lNode) {
        assert (SelfLoopHolder.needsSelfLoopProcessing(lNode));
        SelfLoopHolder holder = new SelfLoopHolder(lNode);
        lNode.setProperty(InternalProperties.SELF_LOOP_HOLDER, holder);
        holder.initialize();
        return holder;
    }

    public static boolean needsSelfLoopProcessing(LNode lNode) {
        if (lNode.getType() != LNode.NodeType.NORMAL) {
            return false;
        }
        return StreamSupport.stream(lNode.getOutgoingEdges().spliterator(), false).anyMatch(edge -> edge.isSelfLoop());
    }

    private void initialize() {
        ArrayList<SelfLoopEdge> slEdges = new ArrayList<SelfLoopEdge>();
        for (LEdge lEdge : this.lNode.getOutgoingEdges()) {
            if (!lEdge.isSelfLoop()) continue;
            slEdges.add(new SelfLoopEdge(lEdge, this.selfLoopPortFor(lEdge.getSource()), this.selfLoopPortFor(lEdge.getTarget())));
        }
        for (SelfLoopPort slPort : this.slPorts.values()) {
            slPort.getLPort().id = 0;
        }
        for (SelfLoopPort slPort : this.slPorts.values()) {
            if (slPort.getLPort().id != 0) continue;
            this.slHyperLoops.add(this.initializeHyperLoop(slPort));
        }
    }

    private SelfLoopPort selfLoopPortFor(LPort lport) {
        if (!this.slPorts.containsKey(lport)) {
            this.slPorts.put(lport, new SelfLoopPort(lport));
        }
        return this.slPorts.get(lport);
    }

    private SelfHyperLoop initializeHyperLoop(SelfLoopPort slPort) {
        SelfHyperLoop slLoop = new SelfHyperLoop(this);
        LinkedList<SelfLoopPort> bfsQueue = new LinkedList<SelfLoopPort>();
        bfsQueue.add(slPort);
        while (!bfsQueue.isEmpty()) {
            SelfLoopPort currentSLPort = (SelfLoopPort)bfsQueue.poll();
            currentSLPort.getLPort().id = 1;
            for (SelfLoopEdge slEdge : currentSLPort.getOutgoingSLEdges()) {
                slLoop.addSelfLoopEdge(slEdge);
                SelfLoopPort slTargetPort = slEdge.getSLTarget();
                if (slTargetPort.getLPort().id != 0) continue;
                bfsQueue.add(slTargetPort);
            }
            for (SelfLoopEdge slEdge : currentSLPort.getIncomingSLEdges()) {
                slLoop.addSelfLoopEdge(slEdge);
                SelfLoopPort slSourcePort = slEdge.getSLSource();
                if (slSourcePort.getLPort().id != 0) continue;
                bfsQueue.add(slSourcePort);
            }
        }
        return slLoop;
    }

    public LNode getLNode() {
        return this.lNode;
    }

    public List<SelfHyperLoop> getSLHyperLoops() {
        return this.slHyperLoops;
    }

    public Map<LPort, SelfLoopPort> getSLPortMap() {
        return this.slPorts;
    }

    public boolean arePortsHidden() {
        return this.arePortsHidden;
    }

    public void setPortsHidden(boolean hidden) {
        this.arePortsHidden = hidden;
    }

    public int[] getRoutingSlotCount() {
        return this.routingSlotCount;
    }
}

