/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.hyperedgedummymerger;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public final class MergeUtils {
    private MergeUtils() {
    }

    public static void merge(List<LNode> dummies) {
        List sortedDummies = dummies.stream().sorted(Comparator.comparingInt(n -> -n.getIndex())).collect(Collectors.toList());
        int ix = 0;
        while (ix < sortedDummies.size() - 1) {
            MergeUtils.mergeNodes((LNode)sortedDummies.get(ix), (LNode)sortedDummies.get(ix + 1));
            ++ix;
        }
    }

    private static void mergeNodes(LNode mergeSource, LNode mergeTarget) {
        MergeUtils.mergeEdges(mergeSource, mergeTarget);
        MergeUtils.updateLongEdgeProperties(mergeSource, mergeTarget);
        mergeSource.getLayer().getNodes().remove(mergeSource);
    }

    private static void mergeEdges(LNode mergeSource, LNode mergeTarget) {
        mergeSource.getEdges().forEach(e -> MergeUtils.redirectEdge(e, mergeSource, mergeTarget));
    }

    private static void redirectEdge(LEdge edge, LNode mergeSource, LNode mergeTarget) {
        if (edge.getTargetNode() == mergeSource) {
            LPort newTargetPort = mergeTarget.getPortsAsList(edge.getTargetSide()).get(0);
            edge.setTarget(newTargetPort);
        }
        if (edge.getSourceNode() == mergeSource) {
            LPort newSourcePort = mergeTarget.getPortsAsList(edge.getSourceSide()).get(0);
            edge.setSource(newSourcePort);
        }
    }

    private static void updateLongEdgeProperties(LNode mergeSource, LNode mergeTarget) {
        MergeUtils.updateLongEdgeProperty(mergeSource, mergeTarget, InternalProperties.LONG_EDGE_SOURCE);
        MergeUtils.updateLongEdgeProperty(mergeSource, mergeTarget, InternalProperties.LONG_EDGE_TARGET);
    }

    private static void updateLongEdgeProperty(LNode mergeSource, LNode mergeTarget, IProperty<LPort> property) {
        if (mergeSource.getProperty(property) != mergeTarget.getProperty(property)) {
            mergeTarget.setProperty(property, (Object)null);
        }
    }
}

