/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.hyperedgedummymerger;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.hyperedgedummymerger.MergeUtils;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.UpDown;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class HyperedgeDummyMergerBeforeP4
implements ILayoutProcessor<LGraph> {
    private LGraph graph;
    private int minimumMergeLength;

    @Override
    public void process(LGraph lGraph, IElkProgressMonitor monitor) {
        monitor.begin("Hyperedge merging", 1.0f);
        this.graph = lGraph;
        this.minimumMergeLength = this.graph.getProperty(LayeredOptions.MINIMUM_HYPEREDGE_MERGE_LENGTH);
        this.mergeHyperEdges();
        monitor.done();
    }

    private void mergeHyperEdges() {
        List<LPort> startPorts = this.getStartPorts();
        this.mergeHyperEdges(startPorts, true, true);
        this.mergeHyperEdges(startPorts, true, false);
        this.mergeHyperEdges(startPorts, false, true);
        this.mergeHyperEdges(startPorts, false, false);
    }

    private List<LPort> getStartPorts() {
        return this.graph.getNodesFromAllLayers().stream().filter(n -> !n.isLongEdge()).flatMap(n -> n.getTruePorts().stream()).collect(Collectors.toList());
    }

    private void mergeHyperEdges(List<LPort> startPorts, boolean startAtInLayerEdges, boolean forward) {
        startPorts.forEach(p -> this.merge((LPort)p, startAtInLayerEdges, forward));
    }

    private void merge(LPort startPort, boolean startAtInLayerEdges, boolean forward) {
        List<MergeChain> mergeChains = HyperedgeDummyMergerBeforeP4.getMergeChains(startPort, startAtInLayerEdges, forward);
        this.merge(mergeChains, 1);
    }

    private static List<MergeChain> getMergeChains(LPort startPort, boolean startAtInLayerEdges, boolean forward) {
        List<LNode> startNodes = HyperedgeDummyMergerBeforeP4.getStartNodes(startPort, startAtInLayerEdges, forward);
        return MesUtilMethods.mapConsecutivePairs(startNodes, (n1, n2) -> HyperedgeDummyMergerBeforeP4.getMergeChain(n1, n2, forward));
    }

    private static List<LNode> getStartNodes(LPort startPort, boolean startAtInLayerEdges, boolean forward) {
        List<LNode> startNodes = startAtInLayerEdges ? startPort.getConnectedNodesInSameLayerFromTopToBottom(forward) : startPort.getConnectedNodesInNextLayerFromTopToBottom(forward);
        HyperedgeDummyMergerBeforeP4.removeLowestStartNodeIfItIsEndNode(startNodes);
        return startNodes;
    }

    private static void removeLowestStartNodeIfItIsEndNode(List<LNode> startNodes) {
        LNode lastNode;
        int ixLastNode = startNodes.size() - 1;
        if (ixLastNode >= 0 && (lastNode = startNodes.get(ixLastNode)).getTrueConnectedNodes().size() == 1) {
            startNodes.remove(ixLastNode);
        }
    }

    private static MergeChain getMergeChain(LNode upperStartNode, LNode lowerStartNode, boolean forward) {
        MergeChain chain = new MergeChain();
        LNode upperNode = upperStartNode;
        LNode lowerNode = lowerStartNode;
        while (upperNode.isLongEdge() && lowerNode.isLongEdge() && upperNode.getLowerNeighbor() == lowerNode) {
            chain.dummies.add(new UpDown<LNode>(upperNode, lowerNode));
            upperNode = upperNode.getConnectedNodes(forward).get(0);
            lowerNode = lowerNode.getConnectedNodes(forward).get(0);
        }
        return chain;
    }

    private void merge(List<MergeChain> mergeChains, int minMergeLength) {
        if (!mergeChains.isEmpty()) {
            this.mergeNonEmptyChains(mergeChains, minMergeLength);
        }
    }

    private void mergeNonEmptyChains(List<MergeChain> mergeChains, int minMergeLength) {
        int[] lengthsOfChains = mergeChains.stream().mapToInt(c -> ((MergeChain)c).getLength()).toArray();
        int mergeLength = MesUtilMethods.min(lengthsOfChains);
        if (mergeLength >= minMergeLength) {
            this.mergeGivenLengthAndContinue(mergeChains, mergeLength);
        } else {
            this.splitAndMerge(mergeChains, lengthsOfChains, minMergeLength);
        }
    }

    private void mergeGivenLengthAndContinue(List<MergeChain> mergeChains, int mergeLength) {
        int ixLayer = 0;
        while (ixLayer < mergeLength) {
            this.mergeDummiesOfLayer(mergeChains, ixLayer);
            ++ixLayer;
        }
        mergeChains.forEach(c -> ((MergeChain)c).removeFirstN(mergeLength));
        this.mergeNonEmptyChains(mergeChains, this.minimumMergeLength);
    }

    private void mergeDummiesOfLayer(List<MergeChain> mergeChains, int ixLayer) {
        List<LNode> dummiesToMerge = this.getDummiesOfLayerToMerge(mergeChains, ixLayer);
        MergeUtils.merge(dummiesToMerge);
    }

    private List<LNode> getDummiesOfLayerToMerge(List<MergeChain> mergeChains, int ixLayer) {
        ArrayList<LNode> dummiesToMerge = new ArrayList<LNode>();
        LNode firstUpperDummy = (LNode)((UpDown)mergeChains.get(0).dummies.get(ixLayer)).getUp();
        dummiesToMerge.add(firstUpperDummy);
        mergeChains.forEach(c -> {
            boolean bl = dummiesToMerge.add((LNode)((UpDown)((MergeChain)c).dummies.get(ixLayer)).getDown());
        });
        return dummiesToMerge;
    }

    private void splitAndMerge(List<MergeChain> mergeChains, int[] lengthsOfChains, int minMergeLength) {
        List<List<MergeChain>> splitMergeChains = this.splitUpMergeChains(mergeChains, lengthsOfChains, minMergeLength);
        splitMergeChains.forEach(cs -> this.merge((List<MergeChain>)cs, this.minimumMergeLength));
    }

    private List<List<MergeChain>> splitUpMergeChains(List<MergeChain> mergeChains, int[] lengthsOfChains, int minMergeLength) {
        List<Integer> splitPoints = MesUtilMethods.getIndicesOfValuesLessThan(lengthsOfChains, minMergeLength);
        return MesUtilMethods.splitExcludingIndices(mergeChains, splitPoints);
    }

    private static class MergeChain {
        private List<UpDown<LNode>> dummies = new ArrayList<UpDown<LNode>>();

        private MergeChain() {
        }

        private int getLength() {
            return this.dummies.size();
        }

        private void removeFirstN(int n) {
            this.dummies = this.dummies.subList(n, this.dummies.size());
        }
    }
}

