/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.hyperedgedummymerger;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.hyperedgedummymerger.MergeUtils;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayList;
import java.util.List;

public final class HyperedgeDummyMergerAfterP4
implements ILayoutProcessor<LGraph> {
    private LGraph graph;
    private boolean forward;

    @Override
    public void process(LGraph lGraph, IElkProgressMonitor monitor) {
        monitor.begin("Hyperedge merging after P4", 1.0f);
        this.graph = lGraph;
        this.mergeHyperEdgesForwardAndBackward();
        monitor.done();
    }

    private void mergeHyperEdgesForwardAndBackward() {
        this.forward = true;
        this.mergeHyperEdges();
        this.forward = false;
        this.mergeHyperEdges();
    }

    private void mergeHyperEdges() {
        this.graph.getLayers(this.forward).forEach(l -> this.mergeHyperEdges((Layer)l));
    }

    private void mergeHyperEdges(Layer layer) {
        if (!layer.isEmpty()) {
            this.mergeHyperEdgesOfNonEmptyLayer(layer);
        }
    }

    private void mergeHyperEdgesOfNonEmptyLayer(Layer layer) {
        LNode currNode = layer.getFirstNode();
        while (currNode != null) {
            this.mergeNodesToBeMerged(currNode);
            currNode = currNode.getLowerNeighbor();
        }
    }

    private void mergeNodesToBeMerged(LNode node) {
        List<LNode> nodesToBeMerged = this.getNodesToBeMerged(node);
        if (nodesToBeMerged.size() > 1) {
            MergeUtils.merge(nodesToBeMerged);
        }
    }

    private List<LNode> getNodesToBeMerged(LNode node) {
        ArrayList nodesToBeMerged = Lists.newArrayList((Object[])new LNode[]{node});
        LNode currNode = node.getLowerNeighbor();
        while (currNode != null && this.shouldBeMerged(node, currNode)) {
            nodesToBeMerged.add(currNode);
            currNode = currNode.getLowerNeighbor();
        }
        return nodesToBeMerged;
    }

    private boolean shouldBeMerged(LNode a, LNode b) {
        return a.getPosition().y == b.getPosition().y && a.isLongEdge() && b.isLongEdge() && this.getConnectedPort(a) == this.getConnectedPort(b);
    }

    private LPort getConnectedPort(LNode dummyNode) {
        return dummyNode.getEdges(!this.forward).get(0).getPort(!this.forward);
    }
}

