/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.adjustnodeheight;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.adjustnodeheight.AdjustNodeHeight;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public class NodeHeightAdjustmentProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("nodeheightadjustprocessor", 1.0f);
        this.adjustNodeHeights(layeredGraph);
        progressMonitor.done();
    }

    private void adjustNodeHeights(LGraph layeredGraph) {
        Spacings spacings = layeredGraph.getProperty(InternalProperties.SPACINGS);
        layeredGraph.getNodesFromAllLayers().forEach(n -> this.adjust((LNode)n, spacings));
    }

    private void adjust(LNode node, Spacings spacings) {
        new AdjustNodeHeight(node, spacings).adjust();
    }
}

