/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopEdge;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopHolder;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public class SelfLoopPostProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Self-Loop post-processing", 1.0f);
        graph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).filter(lNode -> lNode.getType() == LNode.NodeType.NORMAL).filter(lNode -> lNode.hasProperty(InternalProperties.SELF_LOOP_HOLDER)).forEach(lNode -> this.processNode((LNode)lNode));
        progressMonitor.done();
    }

    private void processNode(LNode lNode) {
        SelfLoopHolder slHolder = lNode.getProperty(InternalProperties.SELF_LOOP_HOLDER);
        slHolder.getSLHyperLoops().stream().flatMap(slLoop -> slLoop.getSLEdges().stream()).forEach(slEdge -> this.restoreEdge(lNode, (SelfLoopEdge)slEdge));
        slHolder.getSLHyperLoops().stream().filter(slLoop -> slLoop.getSLLabels() != null).forEach(slLoop -> slLoop.getSLLabels().applyPlacement(lNode.getPosition()));
    }

    private void restoreEdge(LNode lNode, SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getLEdge();
        lEdge.setSource(slEdge.getSLSource().getLPort());
        lEdge.setTarget(slEdge.getSLTarget().getLPort());
        lEdge.getBendPoints().offset(lNode.getPosition());
    }
}

