/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.Iterator;

public final class NorthSouthPortPostprocessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Odd port side processing", 1.0f);
        this.process(layeredGraph);
        assert (this.noNorthSouthPortDummiesRemaining(layeredGraph));
        monitor.done();
    }

    private void process(LGraph layeredGraph) {
        for (Layer layer : layeredGraph) {
            LNode[] nodeArray;
            LNode[] lNodeArray = nodeArray = LGraphUtil.toNodeArray(layer.getNodes());
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                if (node.getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
                    if (node.getProperty(InternalProperties.ORIGIN) instanceof LEdge) {
                        this.processSelfLoop(node);
                    } else {
                        boolean sameOriginPort;
                        if (node.getPorts().size() >= 2) {
                            sameOriginPort = true;
                            Iterator<LPort> portIterator = node.getPorts().iterator();
                            LPort currentPort = portIterator.next();
                            LPort previousPort = null;
                            while (portIterator.hasNext()) {
                                previousPort = currentPort;
                                currentPort = portIterator.next();
                                if (previousPort.getProperty(InternalProperties.ORIGIN).equals(currentPort.getProperty(InternalProperties.ORIGIN))) continue;
                                sameOriginPort = false;
                                break;
                            }
                        } else {
                            sameOriginPort = false;
                        }
                        for (LPort port : node.getPorts()) {
                            if (!port.getIncomingEdges().isEmpty()) {
                                this.processInputPort(port, sameOriginPort);
                            }
                            if (port.getOutgoingEdges().isEmpty()) continue;
                            this.processOutputPort(port, sameOriginPort);
                        }
                    }
                    node.setLayer(null);
                }
                ++n2;
            }
        }
    }

    private void processInputPort(LPort inputPort, boolean addJunctionPoints) {
        LEdge[] edgeArray;
        LPort originPort = (LPort)inputPort.getProperty(InternalProperties.ORIGIN);
        double x = originPort.getAbsoluteAnchor().x;
        double y = inputPort.getNode().getPosition().y;
        LEdge[] lEdgeArray = edgeArray = LGraphUtil.toEdgeArray(inputPort.getIncomingEdges());
        int n = edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge inEdge = lEdgeArray[n2];
            inEdge.setTarget(originPort);
            inEdge.getBendPoints().addLast(x, y);
            if (addJunctionPoints) {
                KVectorChain junctionPoints = inEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
                if (junctionPoints == null) {
                    junctionPoints = new KVectorChain();
                    inEdge.setProperty(LayeredOptions.JUNCTION_POINTS, junctionPoints);
                }
                junctionPoints.add(new KVector(x, y));
            }
            ++n2;
        }
    }

    private void processOutputPort(LPort outputPort, boolean addJunctionPoints) {
        LEdge[] edgeArray;
        LPort originPort = (LPort)outputPort.getProperty(InternalProperties.ORIGIN);
        double x = originPort.getAbsoluteAnchor().x;
        double y = outputPort.getNode().getPosition().y;
        LEdge[] lEdgeArray = edgeArray = LGraphUtil.toEdgeArray(outputPort.getOutgoingEdges());
        int n = edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEdge outEdge = lEdgeArray[n2];
            outEdge.setSource(originPort);
            outEdge.getBendPoints().addFirst(x, y);
            if (addJunctionPoints) {
                KVectorChain junctionPoints = outEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
                if (junctionPoints == null) {
                    junctionPoints = new KVectorChain();
                    outEdge.setProperty(LayeredOptions.JUNCTION_POINTS, junctionPoints);
                }
                junctionPoints.add(new KVector(x, y));
            }
            ++n2;
        }
    }

    private void processSelfLoop(LNode dummy) {
        LEdge selfLoop = (LEdge)dummy.getProperty(InternalProperties.ORIGIN);
        LPort inputPort = dummy.getPorts(PortSide.WEST).iterator().next();
        LPort outputPort = dummy.getPorts(PortSide.EAST).iterator().next();
        LPort originInputPort = (LPort)inputPort.getProperty(InternalProperties.ORIGIN);
        LPort originOutputPort = (LPort)outputPort.getProperty(InternalProperties.ORIGIN);
        selfLoop.setSource(originOutputPort);
        selfLoop.setTarget(originInputPort);
        KVector bendPoint = new KVector(outputPort.getNode().getPosition());
        bendPoint.x = originOutputPort.getAbsoluteAnchor().x;
        selfLoop.getBendPoints().add(bendPoint);
        bendPoint = new KVector(inputPort.getNode().getPosition());
        bendPoint.x = originInputPort.getAbsoluteAnchor().x;
        selfLoop.getBendPoints().add(bendPoint);
    }

    private boolean noNorthSouthPortDummiesRemaining(LGraph layeredGraph) {
        return layeredGraph.getNodesFromAllLayers().stream().noneMatch(node -> node.getType() == LNode.NodeType.NORTH_SOUTH_PORT);
    }
}

